#-*- coding: utf-8 -*-
""" 
theme action - an easy way to try themes
========================================

This action let you try themes without going to userpreferences, selecting, saving, refreshing, selecting another... and so on.

Usage
-----

Call any page with a these query::

    http://example.com/wiki/FrontPage?action=theme&theme=mytheme
    
Or put the Themes macro (included in this package) on a page:

    [[Themes]]

Install
-------

Put in your wiki/data/plugin/action/

    
Compatibility
--------------
Original version by Nir Soffer was tested with release 1.3.5, worked through 1.6.0.
Modified by Roger Haase to work with 1.6.1 on 2008-02-14.
Modified by Roger Haase to work with 1.9.0beta4 (try 2) on 2009-10-23.

Legal
-----
@copyright  2005 Nir Soffer <nirs@freeshell.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
from MoinMoin.error import Error

#~ from MoinMoin import log
#~ logging = log.getLogger(__name__)


class ThemeAction:
        
    def __init__(self, request, pagename):
        self.request = request
        self.pagename = pagename
        # Initialized on execute
        self.themeName = None
        
    def execute(self):
        _ = self.request.getText

        try:
            self.validateArgs()
            self.switchTheme()
            message = self.themeDescription()
        except Error, err:
            message = unicode(err)
        self.request.page.send_page(msg=message)
        
    def populateForm(self):
        '''Return a dictionary of keys and values extracted from query string.'''
        query = self.request.environ.get('QUERY_STRING','')
        queryItems = query.split('&')
        queryDict = {}
        for keyValue in queryItems:
            k, v = keyValue.split('=')
            values = v.split(',')
            queryDict[k] = values
        return queryDict

    def validateArgs(self):
        _ = self.request.getText
        try:
            self.themeName = self.request.values.get('theme')
        except KeyError:
            raise Error(_('Missing theme argument.'))
        if self.themeName.isspace():
            raise Error(_('Invalid theme: "%s".') % self.themeName)
        if not self.themeAllowed():
            raise Error(_('"%s" theme is not allowed.') % self.themeName)

    def themeAllowed(self):
        return not (self.request.cfg.theme_force and 
                    self.request.cfg.theme_default != self.themeName)

    def switchTheme(self):
        _ = self.request.getText
        from MoinMoin import wikiutil        
        try:
            theme = wikiutil.importPlugin(self.request.cfg, 'theme', 
                                          self.themeName, function='Theme')
        except ImportError:
            raise Error(_('"%s" theme is not available.') % self.themeName)
        self.request.theme = theme(self.request)

    def themeDescription(self):
        _ = self.request.getText
        # TODO: have an author variable for each theme and show:
        # <Theme Name> theme by <Author Name>
        return _('This is the "%s" theme') % self.themeName
    

def execute(pagename, request):
    ThemeAction(request, pagename).execute()

