# -*- coding: iso-8859-1 -*-
"""
	Top Matter:
		MentalHealth is a MoinMoin theme
		by robin.escalation@ACM.org
		dated this 20th of April 2005

		let's call it version 0.9
		and by golly this is GPLed

	Description:
		It may look something like the standard "rightsidebar" theme.
		But in reality it is so much better. ;-)

		For example:
		* smaller type so more fits
		* very nice colours to soothe the soul
		* but main page still white background so no clashes
		* nice alignment, sizes etc. 
		* search form integrated with right panel look
		* got rid of damn ugly action pulldown menu
		* no loss of functionality
		
		Seems to look good but if you have an issue on a browser then
		let me know.

	Accompanying files:
		No files changed in folder "img".
		Only file changed in folder "css" is "screen.css".
		(Though see next.)
		
	Skinning the theme:
		This theme uses four compatible colours, as mentioned in the
		header "screen.css". If you like you can search'n'replace for
		those more to your liking. I have a couple of alternate versions
		of the stylesheet, named screen01.css, screen02.css, etc., just
		to show how this works. Rename each in tun to screen.css and
		check it out.

	Installation:
		* move mentalhealth.py to $python/Lib/site-packages/MoinMoin/theme/
		* move the mentalhealth folder under $python/share/moin/htdocs/

	And Finally:
		"Oh we're in love with beauty,
		 We're in love with wealth,
		 We're in love with mental health."
		 -- Julian Cope

"""

from MoinMoin.theme import ThemeBase
from MoinMoin.wikiutil import link_tag as link
from MoinMoin.wikiutil import quoteWikinameURL as quoteURL

class Theme(ThemeBase):
	name = "mentalhealth"

	def editbar(self, d):
		"""
			Assemble the page edit bar.

			This is rewritten here to get rid of fugly drop-down menu.
			(Obviating the need for the actionsMenu() method).

			Also I tried to reduce the number of aliases 'cause I find
			that hard to follow.
			
			@param d: parameter dictionary
			@rtype: unicode
			@return: iconbar html
		"""
		# short circuit
		if not self.shouldShowEditbar(d['page']):
			return ''

		# initialisations & optimisation
		_ = self.request.getText
		page = d['page']
		cacheKey = 'editbar'
		quotedname = quoteURL(page.page_name)
		
		# use cached copy if possible
		cached = self._cache.get(cacheKey)
		if cached:
			return cached

		# each action in this list is a line on the editbar panel
		links = []

		# parent page
		parent = page.getParentPage()
		if parent:
			links += [parent.link_to(self.request, _("Show Parent", formatted=False))]
		
		# the rest we will do cleverly :-)
		# these are the possible actions and their text labels
		choices = [	['edit',			'edit'],
					['diff',			'show changes'],
					['info',			'get info'],
					['raw',				'show raw text'],
					['print',			'show print view'],
					['refresh',			'delete cache'],
					['AttachFile',		'attach file'],
					['SpellCheck',		'check spelling'],
					['LikePages',		'show like pages'],
					['LocalSiteMap',	'show local site map'],
					['RenamePage',		'rename page'],
					['DeletePage',		'delete page']
					]
		
		# determine which actions we can use
		available = self.request.getAvailableActions(page)
		for action, label in choices:
			if action == 'refresh' and not page.canUseCache():
				continue
			if action == 'edit' and not (page.isWritable() and self.request.user.may.write(page.page_name)):
				continue

			if action[0].isupper() and not action in available:
				continue

			links += [link(self.request, '%s?action=%s' % (quotedname, action),
						   _(label, formatted=False))]
			
		# we will still delegate this next so I can stop rewriting code
		links += [self.subscribeLink(page)]

		# wrap it all up nicely
		html = u'<ul class="editbar">\n%s\n</ul>\n' %\
			   '\n'.join(['<li>%s</li>' % item for item in links if item != ''])

		# cache for next call
		self._cache[cacheKey] = html
		return html

	def header(self, d, **kw):
		"""
			Assemble page header, which is to say our right-hand panel.
			
			@param d: parameter dictionary
			@rtype: string
			@return: page header html
		"""
		_ = self.request.getText

		# there are 5 main panels: each one follows this markup
		html = u'<div class="sidepanel"><h1>%s</h1>%s</div>'
		
		# "search" panel hack so I don't have to rewrite searchform()
		searchpanel = self.searchform(d).replace('<input id="titlesearch"',
												 '<br><input id="titlesearch"')

		# bundle up all our parts
		parts = [	self.emit_custom_html(self.cfg.page_header1),
					'<div id="header"></div>',
					self.emit_custom_html(self.cfg.page_header2),

					u'<div id="sidebar">',
					html % (_('Search'), searchpanel),
					html % (_('Navigation'), self.navibar(d)),
					html % (_('Recent'), self.trail(d)),
					html % (_('This Page'), self.editbar(d)),
					html % (_('User'), self.username(d)),
					self.credits(d),
					u'</div>',

					self.msg(d),		
					self.startPage(),
					self.title(d)
					]
		return u'\n'.join(parts)
	
	def footer(self, d, **kw):
		"""
			Assemble page footer
			
			@param d: parameter dictionary
			@keyword ...:...
			@rtype: string
			@return: page footer html
		"""
		parts = [	u'<div id="pagebottom"></div>',
					self.pageinfo(d['page']),
					self.endPage(),
					self.emit_custom_html(self.cfg.page_footer1),
					self.emit_custom_html(self.cfg.page_footer2),
					]
		return u'\n'.join(parts)

def execute(request):
	"""
		Generate and return a theme object.
	"""
	return Theme(request)
