# -*- coding: iso-8859-1 -*-
"""MoinMoin theme "sinorca4moin" by David Linke.

Credits to "Haran" who published his sinorca-design at www.oswd.org
"""

from MoinMoin import wikiutil
from MoinMoin.Page import Page
from MoinMoin.theme import ThemeBase

class Theme(ThemeBase):
    """ here are the functions generating the html responsible for
        the look and feel of your wiki site
    """

    name = "sinorca4moin"

    def iconbar(self, d):
        """
        Assemble the iconbar
        
        @param d: parameter dictionary
        @rtype: string
        @return: iconbar html
        """
        iconbar = []
        if self.cfg.page_iconbar and self.request.user.show_toolbar and d['page_name']:
            iconbar.append('<ul id="iconbar">\n')
            icons = self.cfg.page_iconbar[:]
            for icon in icons:
                if icon == "up":
                    if d['page_parent_page']:
                        iconbar.append('<li>%s</li>\n' % self.make_iconlink(icon, d))
                elif icon == "subscribe":
                    iconbar.append('<li>%s</li>\n' % self.make_iconlink(
                        ["subscribe", "unsubscribe"][self.request.user.isSubscribedTo([d['page_name']])], d))
                elif icon == "home":
                    if d['page_home_page']:
                        iconbar.append('<li>%s</li>\n' % self.make_iconlink(icon, d))
                else:
                    iconbar.append('<li>%s</li>\n' % self.make_iconlink(icon, d))
            iconbar.append('</ul>\n')
        return ''.join(iconbar)

    def editbar(self, d):
        """ Assemble the page edit bar.

        Display on existing page. Replace iconbar, showtext, edit text,
        refresh cache and available actions.
        
        @param d: parameter dictionary
        @rtype: unicode
        @return: iconbar html
        """
        page = d['page']       
        if not self.shouldShowEditbar(page):
            return ''

        # Use cached editbar if possible.
        cacheKey = 'editbar'
        cached = self._cache.get(cacheKey)
        if cached:
            return cached

        # Make new edit bar
        request = self.request
        _ = self.request.getText
        link = wikiutil.link_tag
        quotedname = wikiutil.quoteWikinameURL(page.page_name)
        links = []
        add = links.append
        
        # Parent page
        #parent = page.getParentPage()
        #if parent:
        #   add(parent.link_to(request, _("Show Parent", formatted=False))) 
        
        # Page actions
        if page.isWritable() and request.user.may.write(page.page_name):
            add(link(request, quotedname + '?action=edit', _('Edit')))
        else:
            add(_('Immutable Page', formatted=False))              
        
        add(link(request, quotedname + '?action=info', 
                 _('Get Info', formatted=False)))
        add(self.actionsMenu(page))
        
        # Format
        items = '\n'.join(['<li>%s</li>' % item for item in links if item != ''])
        html = u'<ul class="editbar">\n%s\n</ul>\n' % items
        
        # cache for next call
        self._cache[cacheKey] = html
        return html
   
    def wikipanel(self, d):
        """ Create wiki panel """
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'  <p class="sideBarTitle">%s</p>' % _("Wiki"),
            self.navibar(d),
            u'</div>',
            ]
        return u'\n'.join(html)
    
    def pagepanel(self, d):
        """ Create page panel """
        _ = self.request.getText
        if self.shouldShowEditbar(d['page']):
            html = [
                u'<div class="sidepanel">',
                u'  <p class="sideBarTitle">%s</p>' % _("Page"),
                self.editbar(d),
                u'</div>',
                ]
            return u'\n'.join(html)
        return ''   
        
    def userpanel(self, d):
        """ Create user panel """
        _ = self.request.getText

        html = [
            u'<div class="sidepanel">',
            u'  <p class="sideBarTitle">%s</p>' %  _("User"),
            self.username(d),
            u'</div>'
            ]
        return u'\n'.join(html)

    def logo(self):
        """ Assemble logo with link to front page

        adds h1-tags for sinorca
        """
        if self.cfg.logo_string:
            pagename = wikiutil.getFrontPage(self.request).page_name
            pagename = wikiutil.quoteWikinameURL(pagename)
            logo = wikiutil.link_tag(self.request, pagename, self.cfg.logo_string)
            html = u'''<div id="logo"> <h1 class="headerTitle">%s</h1></div>''' % logo
            return html
        return u''

    def header(self, d):
        """
        Assemble page header
        
        @param d: parameter dictionary
        @rtype: string
        @return: page header html
        """
        _ = self.request.getText

        trail = self.trail(d)

        html = [
            # Header
            u'<div id="header">',
            # Custom html super-header
            self.emit_custom_html(self.cfg.page_header1),
            u'  <div class="midHeader">',
            self.logo(),
            u'  </div>',
            # Custom html below header (not recomended!)
            self.emit_custom_html(self.cfg.page_header2),
            trail,
            u'</div>',
            
            # Iconbar
            self.iconbar(d),

            # Sidebar   
            u'<!-- ##### Side Bar ##### -->',
            u'<div id="sidebar">',
            
            u'<div class="sidepanel">',
            u'  <p class="sideBarTitle">Search in %s</p>' % _(self.cfg.sitename),
            self.searchform(d),
            u'</div>',

            self.wikipanel(d),
            self.pagepanel(d),
            self.userpanel(d),
            self.credits(d),
            u'</div>',

            self.msg(d),
            
            # Page
            self.startPage(),
            self.title(d),
            ]
        return u'\n'.join(html)
    
    def footer(self, d, **keywords):
        """ Assemble page footer
        
        @param d: parameter dictionary
        @keyword ...:...
        @rtype: string
        @return: page footer html
        """
        page = d['page']
        html = [
            # Page end
            # Used to extend the page to the bottom of the sidebar
            u'<div id="pagebottom"></div>',
            self.pageinfo(page),
            self.endPage(),
            
            # Custom html above footer
            self.emit_custom_html(self.cfg.page_footer1),
            
            # And bellow
            self.emit_custom_html(self.cfg.page_footer2),
            ]
        return u'\n'.join(html)


def execute(request):
    """
    Generate and return a theme object
        
    @param request: the request object
    @rtype: MoinTheme
    @return: Theme object
    """
    return Theme(request)

