# -*- coding: iso-8859-1 -*-
"""
    MoinMoin theme monomoin v0.5

    Jan 2006, HpK
"""

from MoinMoin import wikiutil, version
from MoinMoin.Page import Page
from MoinMoin.theme import ThemeBase

class Theme(ThemeBase):
    """ here are the functions generating the html responsible for
        the look and feel of your wiki site
    """

    name = "monomoin"

    # fake _ function to get gettext recognize those texts:
    _ = lambda x: x

    icons = {
        # key         alt                        icon filename      w   h
        # ------------------------------------------------------------------
        # iconbar
        'help':       ("%(page_help_contents)s", "moin-help.png",   12, 11),
        'find':       ("%(page_find_page)s",     "moin-search.png", 12, 12),
        'diff':       (_("Diffs"),               "moin-diff.png",   16, 16),
        'info':       (_("Info"),                "moin-info.png",   16, 16),
        'edit':       (_("Edit"),                "moin-edit.png",   16, 16),
        'unsubscribe':(_("Unsubscribe"),         "moin-unsubscribe.png",  14, 10),
        'subscribe':  (_("Subscribe"),           "moin-subscribe.png",16, 16),
        'raw':        (_("Raw"),                 "moin-raw.png",    16, 16),
        'xml':        (_("XML"),                 "moin-xml.png",    20, 13),
        'print':      (_("Print"),               "moin-print.png",  16, 16),
        'view':       (_("View"),                "moin-show.png",   16, 16),
        'home':       (_("Home"),                "moin-home.png",   13, 12),
        'up':         (_("Up"),                  "moin-parent.png", 15, 13),
        # FileAttach
        'attach':     ("%(attach_count)s",       "moin-attach.png",  7, 15),
        # RecentChanges
        'rss':        (_("[RSS]"),               "moin-rss.png",    36, 14),
        'deleted':    (_("[DELETED]"),           "moin-deleted.png",60, 12),
        'updated':    (_("[UPDATED]"),           "moin-updated.png",60, 12),
        'new':        (_("[NEW]"),               "moin-new.png",    31, 12),
        'diffrc':     (_("[DIFF]"),              "moin-diff.png",   15, 11),
        # General
        'bottom':     (_("[BOTTOM]"),            "moin-bottom.png", 14, 10),
        'top':        (_("[TOP]"),               "moin-top.png",    14, 10),
        'www':        ("[WWW]",                  "moin-www.png",    16, 16),
        'mailto':     ("[MAILTO]",               "moin-email.png",  14, 10),
        'news':       ("[NEWS]",                 "moin-news.png",   10, 11),
        'telnet':     ("[TELNET]",               "moin-telnet.png", 10, 11),
        'ftp':        ("[FTP]",                  "moin-ftp.png",    11, 11),
        'file':       ("[FILE]",                 "moin-ftp.png",    11, 11),
        # search forms
        'searchbutton': ("[?]",                  "moin-search.png", 16, 16),
        'interwiki':  ("[%(wikitag)s]",          "moin-inter.png",  16, 16),
    }
    del _

    def iconbar(self, d):
        """
        Assemble the iconbar

        @param d: parameter dictionary
        @rtype: string
        @return: iconbar html
        """
        iconbar = []
        if self.cfg.page_iconbar and self.request.user.show_toolbar and d['page_name']:
            iconbar.append('<ul id="iconbar">\n')
            icons = self.cfg.page_iconbar[:]
            for icon in icons:
                if icon == "up":
                    if d['page_parent_page']:
                        iconbar.append('<li>%s</li>\n' % self.make_iconlink(icon, d))
                elif icon == "subscribe":
                    iconbar.append('<li>%s</li>\n' % self.make_iconlink(
                        ["subscribe", "unsubscribe"][self.request.user.isSubscribedTo([d['page_name']])], d))
                elif icon == "home":
                    if d['page_home_page']:
                        iconbar.append('<li>%s</li>\n' % self.make_iconlink(icon, d))
                else:
                    iconbar.append('<li>%s</li>\n' % self.make_iconlink(icon, d))
            iconbar.append('</ul>\n')
        return ''.join(iconbar)

    def wikipanel(self, d):
        """ Create wiki panel """
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' % _("Navigation"),
            self.navibar(d),
            u'</div>',
            ]
        return u'\n'.join(html)
    
    def pagepanel(self, d):
        """ Create page panel """
        _ = self.request.getText
        if 1: #self.shouldShowEditbar(d['page']):
            html = [
                u'<div class="pagepanel">',
#                u'<h1>%s</h1>' % _("Page"),
		self.editbar(d),
                self.iconbar(d),
                u'</div>',
                ]
            return u'\n'.join(html)
        return ''   
        
    def userpanel(self, d):
        """ Create user panel """
        _ = self.request.getText

        trail = self.trail(d)
        if trail:
            trail = u'<h2>%s</h2>\n' % _("Recently viewed pages") + trail

        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' %  _("User"),
            self.username(d),
            trail,
            u'</div>'
            ]
        return u'\n'.join(html)

    def header(self, d, **keywords):
        """
        Assemble page header
        
        @param d: parameter dictionary
        @rtype: string
        @return: page header html
        """
        _ = self.request.getText

        html = [
            # Custom html above header
            #self.emit_custom_html(self.cfg.page_header1),

            # Header
            u'<div id="header">',
	    u'&nbsp;',
            u'</div>',
            
            # Custom html below header (not recomended!)
            #self.emit_custom_html(self.cfg.page_header2),

            # Sidebar
            u'<div id="sidebar">',
            u'<div class="sidepanel">',
            self.logo(),
            u'</div>',
            self.wikipanel(d),
            u'<div class="sidepanel"><h1>Search</h1>',
            self.searchform(d),
            u'</div>',
#            self.pagepanel(d),
            self.userpanel(d),
#            u'<div class="sidepanel">',
            self.credits(d),
            self.showversion(d, **keywords),
#            u'</div>',
            u'</div>',

            # Pagebar
            u'<div id="pagebar">',
            self.pagepanel(d),
            u'</div>',

            # Page
            u'<div id="outer">',
            self.startPage(),
            self.msg(d),
            self.title(d),
            ]
        return u'\n'.join(html)
    
    def footer(self, d, **keywords):
        """ Assemble page footer
        
        @param d: parameter dictionary
        @keyword ...:...
        @rtype: string
        @return: page footer html
        """
        page = d['page']
        html = [
            # Page end
            # Used to extend the page to the bottom of the sidebar
#            u'<div id="pagebottom">',
            self.pageinfo(page),
#            u'</div>', 
            u'</div>',
            self.endPage(),

            # Custom html above footer
            # self.emit_custom_html(self.cfg.page_footer1),
            
            # And bellow
            # self.emit_custom_html(self.cfg.page_footer2),
            ]
        return u'\n'.join(html)


def execute(request):
    """
    Generate and return a theme object
        
    @param request: the request object
    @rtype: MoinTheme
    @return: Theme object
    """
    return Theme(request)

