// ========================================
// Copyright (c) 2007 by Wolfgang Fischer
// ========================================

var body, header, content_header_area, tree_header_area, tree_header, page_header_area, tree_content_area, page_content_area, split_bar, footer, is_ltr;

var dragged, old_ondrag, old_onselect;
var MIN_TREE_WIDTH = 15; // in pixel

var agt=navigator.userAgent.toLowerCase();
var IS_IE = ((agt.indexOf("msie") != -1) && (agt.indexOf("opera") == -1));
var LEFT_BUTTON = IS_IE ? 1 : 0;

function explorer_init() {
    body = document.body;
    is_ltr = (body.dir == "ltr");
    header = document.getElementById("header");
    content_header_area = document.getElementById("content_header_area");
    tree_header_area = document.getElementById("tree_header_area");
    tree_header = document.getElementById("tree_header");
    page_header_area = document.getElementById("page_header_area");
    tree_content_area = document.getElementById("tree_content_area");
    page_content_area = document.getElementById("page_content_area");
    split_bar = document.getElementById("split_bar");
    footer = document.getElementById("footer");

    init_cookies();
    if (tree_content_area != null) {
        body.style.overflow = "hidden";
        if (IS_IE) body.scroll = "no";
        size_areas_to_window();
        tree_left = get_cookie("explorer_tree_left");
        if (tree_left != "") {
            tree_content_area.scrollLeft = tree_left;
        }
        tree_top = get_cookie("explorer_tree_top");
        if (tree_top != "") {
            tree_content_area.scrollTop = tree_top;
        }
        window.onresize = size_areas_to_window;
        window.onunload = save_tree_scroll_position;
        split_bar.ondblclick = toggle_display_tree;
        split_bar.onmousedown = drag_init;
    }
}

function toggle_comments(element) {
    parent_item = element.parentNode
    is_show_comments = (parent_item.className == "ib_selected")
    parent_item.className = is_show_comments ? "" : "ib_selected"
    toggleComments();
}


// ===================================
// Split bar event handling
// ===================================
function toggle_display_tree(e) {
    var evt = e || window.event;
    consume_event(evt);
    if (get_split_bar_posx() < MIN_TREE_WIDTH) { // Show tree
        split_bar_posx = get_cookie("explorer_split_bar_posx");
        if (split_bar_posx != "") {
            set_split_bar_posx(split_bar_posx);
        } else {
            set_cookie("explorer_split_bar_posx", '15em');
            set_split_bar_posx('15em');
        }
        set_cookie("explorer_hide_tree", "");
    } else { // Hide tree
        set_cookie("explorer_split_bar_posx", get_split_bar_posx() + "px");
        set_cookie("explorer_hide_tree", 1);
        set_split_bar_posx("0px");
    }
    size_areas_to_split_bar();
}


function consume_event(evt) {
    if (evt.stopPropagation) {
        evt.stopPropagation();
        evt.preventDefault();
    } else {
        evt.cancelBubble = true;
        evt.returnValue = false;
    }
}


function drag_init(e) {
    var evt = e || window.event;
    if (evt.button == LEFT_BUTTON) {
        dragged = false;
        document.onmousemove = drag;
        document.onmouseup = drop;
        // prevent IE text selection while dragging
        old_ondrag = document.body.ondrag;
        old_onselectstart = document.body.onselectstart;
        document.body.ondrag = function () { return false; };
        document.body.onselectstart = function () { return false; };
    }
    return false;
}


function drag(e) {
    var evt = e || window.event;
    dragged = true;
    posX = is_ltr ? evt.clientX : get_inner_width() - evt.clientX;
    if (posX < MIN_TREE_WIDTH) posX = 0;
    set_split_bar_posx(posX + 'px')
    size_areas_to_split_bar();
}


function drop(e) {
    var evt = e || window.event;
    document.onmouseup = null;
    document.onmousemove = null;
    // enables IE text selection while dragging
    document.body.ondrag = old_ondrag;
    document.body.onselectstart = old_onselectstart;
    if (dragged) {
        posX = is_ltr ? evt.clientX : get_inner_width() - evt.clientX;
        if (posX > 0) {
            set_cookie("explorer_split_bar_posx", posX + 'px');
            set_cookie("explorer_hide_tree", "");
        } else {
            set_cookie("explorer_hide_tree", 1);
        }
    }
}


function get_split_bar_posx() {
    return is_ltr ? split_bar.offsetLeft : get_inner_width() - split_bar.offsetLeft;
}


function set_split_bar_posx(posX) {
    if (is_ltr) split_bar.style.left = posX;
    else split_bar.style.right = posX;
}


function get_inner_width() {
    if (window.innerWidth) { // all except Explorer
        return window.innerWidth;
    }
    else if (document.documentElement && document.documentElement.clientWidth) {
        // Explorer 6 Strict Mode
        return document.documentElement.clientWidth;
    }
}



// ===================================
// Resizing of areas
// ===================================
function size_areas_to_split_bar() {
    posX = is_ltr ? split_bar.style.left : split_bar.style.right;
    tree_header.style.display = (posX == "0px") ? "none" : "block"
    tree_header_area.style.width = posX;
    tree_content_area.style.width = posX;
    size_areas_to_window()
}


function size_areas_to_window() {
    full_height = get_full_height();
    content_area_height = (full_height-header.offsetHeight-content_header_area.offsetHeight-footer.offsetHeight) + "px";
    tree_content_area.style.height = content_area_height;
    page_content_area.style.height = content_area_height;
    split_bar.style.height = (full_height-header.offsetHeight-footer.offsetHeight-1) + "px";
    split_bar.style.top = tree_header_area.offsetTop + "px";
    set_cookie("explorer_content_area_height", content_area_height);
    set_cookie("explorer_split_bar_top", split_bar.style.top);
    set_cookie("explorer_split_bar_height", split_bar.style.height);
}


function get_full_height() {
    if (window.innerHeight) { // all except Explorer
        return window.innerHeight;
    }
    else if (document.documentElement && document.documentElement.clientHeight) {
        // Explorer 6 Strict Mode
        return document.documentElement.clientHeight;
    }
}


function save_tree_scroll_position() {
    set_cookie("explorer_tree_left", tree_content_area.scrollLeft);
    set_cookie("explorer_tree_top", tree_content_area.scrollTop);
}


// ===================================
// Handle toggle button click events
// ===================================
function toggle_display_element(toggle_button, display_element_id) {
    // Displays or hide the coresponding element and toggles the button image
    displayed = (get_cookie(display_element_id) != "");
    set_cookie(display_element_id, displayed ? "" : 1);
    display_element = document.getElementById(display_element_id);
    if (display_element != null) {
        // Element to display is available
        if (displayed) {
            display_element.style.display = "none";
            toggle_button.src = url_prefix_static+'/explorer/img/expand.png';
        } else {
            display_element.style.display = "block";
            toggle_button.src = url_prefix_static+'/explorer/img/collapse.png';
        }
    } else {
        save_tree_scroll_position();
        // Reload the document to show the missing element
        window.location.reload();
    }
}


// ===================================
// Cookie handling library
// ===================================
var cookies = new Object();

function init_cookies() {
    var saved_cookies = document.cookie.split(';');
    var cookie;
    for (var i=0; i < saved_cookies.length; i++) {
        cookie = saved_cookies[i].replace(/^\s+/,"");
        if (cookie.indexOf("=") != 0) {
            cookies[cookie.substring(0, cookie.indexOf("="))]
                = cookie.substring(cookie.indexOf("=")+1, cookie.length);
        }
    }
}


function set_cookie(name, value, days) {
    var expires;
    if (value == "") days = -1;
    if (days) {
        var date = new Date();
        date.setTime(date.getTime()+days*24*60*60*1000);
        expires = "; expires="+date.toGMTString();
    } else expires = "";
    document.cookie = name+"="+value+expires+"; path=";
    cookies[name] = value;
}


function get_cookie(name) {
    value = cookies[name];
    if (value == null) return "";
    else return value;
}


// ===================================
// Initialize after loading the page
// ===================================
addLoadEvent(explorer_init)
