# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - modern theme

    @copyright: 2003-2005 by Nir Soffer, Thomas Waldmann
    @license: GNU GPL, see COPYING for details.
"""

from MoinMoin.theme import ThemeBase

class Theme(ThemeBase):
    # fake _ function to get gettext recognize those texts:
    _ = lambda x: x

    # TODO: remove icons that are not used any more.
    icons = {
        # key         alt                        icon filename      w   h
        # ------------------------------------------------------------------
        # navibar
        'help':       ("%(page_help_contents)s", "moin-help.png",   12, 11),
        'find':       ("%(page_find_page)s",     "moin-search.png", 12, 12),
        'diff':       (_("Diffs"),               "moin-diff.png",   15, 11),
        'info':       (_("Info"),                "moin-info.png",   12, 11),
        'edit':       (_("Edit"),                "moin-edit.png",   12, 12),
        'unsubscribe':(_("Unsubscribe"),         "moin-unsubscribe.png",  14, 10),
        'subscribe':  (_("Subscribe"),           "moin-subscribe.png",14, 10),
        'raw':        (_("Raw"),                 "moin-raw.png",    12, 13),
        'xml':        (_("XML"),                 "moin-xml.png",    20, 13),
        'print':      (_("Print"),               "moin-print.png",  16, 14),
        'view':       (_("View"),                "moin-show.png",   12, 13),
        'home':       (_("Home"),                "moin-home.png",   13, 12),
        'up':         (_("Up"),                  "moin-parent.png", 15, 13),
        # FileAttach
        'attach':     ("%(attach_count)s",       "moin-attach.png",  7, 15),
        # RecentChanges
        'rss':        (_("[RSS]"),               "moin-rss.png",    36, 14),
        'deleted':    (_("[DELETED]"),           "moin-deleted.png",60, 12),
        'updated':    (_("[UPDATED]"),           "moin-updated.png",60, 12),
        'new':        (_("[NEW]"),               "moin-new.png",    31, 12),
        'diffrc':     (_("[DIFF]"),              "moin-diff.png",   15, 11),
        # General
        'bottom':     (_("[BOTTOM]"),            "moin-bottom.png", 14, 10),
        'top':        (_("[TOP]"),               "moin-top.png",    14, 10),
        'www':        ("[WWW]",                  "moin-www.png",    11, 11),
        'mailto':     ("[MAILTO]",               "moin-email.png",  14, 10),
        'news':       ("[NEWS]",                 "moin-news.png",   10, 11),
        'telnet':     ("[TELNET]",               "moin-telnet.png", 10, 11),
        'ftp':        ("[FTP]",                  "moin-ftp.png",    11, 11),
        'file':       ("[FILE]",                 "moin-ftp.png",    11, 11),
        # search forms
        'searchbutton': ("[?]",                  "moin-search.png", 12, 12),
        'interwiki':  ("[%(wikitag)s]",          "moin-inter.png",  16, 16),
        # -- from TaskPlanner __init__.diff (modified) --
        # AttachTable and TaskTable toggle controls
        'table-null':               ("",                            "taskplanner/table-null.png", 16, 16),
        'table-close':              (_("Click to collapse table"),  "taskplanner/table-close.png", 16, 16),
        'table-open':               (_("Click to expand table"),    "taskplanner/table-open.png", 16, 16),
        # TaskTable icons
        'task--todo':               (_("To Do"),                    "taskplanner/task-no-todo.png", 48, 48),
        'task--inprogress':         (_("In Progress"),              "taskplanner/task-no-inprogress.png", 48, 48),
        'task--pending':            (_("Pending"),                  "taskplanner/task-no-pending.png", 48, 48),
        'task--done':               (_("Done"),                     "taskplanner/task-no-done.png", 48, 48),
        'task--failed':             (_("Failed"),                   "taskplanner/task-no-failed.png", 48, 48),
        'task-low-todo':            (_("Low - To Do"),              "taskplanner/task-low-todo.png", 48, 48),
        'task-low-inprogress':      (_("Low - In Progress"),        "taskplanner/task-low-inprogress.png", 48, 48),
        'task-low-pending':         (_("Low - Pending"),            "taskplanner/task-low-pending.png", 48, 48),
        'task-low-done':            (_("Low - Done"),               "taskplanner/task-low-done.png", 48, 48),
        'task-low-failed':          (_("Low - Failed"),             "taskplanner/task-low-failed.png", 48, 48),
        'task-medium-todo':         (_("Medium - To Do"),           "taskplanner/task-medium-todo.png", 48, 48),
        'task-medium-inprogress':   (_("Medium - In Progress"),     "taskplanner/task-medium-inprogress.png", 48, 48),
        'task-medium-pending':      (_("Medium - Pending"),         "taskplanner/task-medium-pending.png", 48, 48),
        'task-medium-done':         (_("Medium - Done"),            "taskplanner/task-medium-done.png", 48, 48),
        'task-medium-failed':       (_("Medium - Failed"),          "taskplanner/task-medium-failed.png", 48, 48),
        'task-high-todo':           (_("High - To Do"),             "taskplanner/task-high-todo.png", 48, 48),
        'task-high-inprogress':     (_("High - In Progress"),       "taskplanner/task-high-inprogress.png", 48, 48),
        'task-high-pending':        (_("High - Pending"),           "taskplanner/task-high-pending.png", 48, 48),
        'task-high-done':           (_("High - Done"),              "taskplanner/task-high-done.png", 48, 48),
        'task-high-failed':         (_("High - Failed"),            "taskplanner/task-high-failed.png", 48, 48),
        'task-critical-todo':       (_("Critical - To Do"),         "taskplanner/task-critical-todo.png", 48, 48),
        'task-critical-inprogress': (_("Critical - In Progress"),   "taskplanner/task-critical-inprogress.png", 48, 48),
        'task-critical-pending':    (_("Critical - Pending"),       "taskplanner/task-critical-pending.png", 48, 48),
        'task-critical-done':       (_("Critical - Done"),          "taskplanner/task-critical-done.png", 48, 48),
        'task-critical-failed':     (_("Critical - Failed"),        "taskplanner/task-critical-failed.png", 48, 48),
        'task-closed':              (_("Closed"),                   "taskplanner/task-closed.png", 48, 48),
        'task-removeme':            (_("Remove Me"),                "taskplanner/task-removeme.png", 48, 48),
        # AttachTable mimetypes
        'unknown':                  (_("Unknown filetype"),         "taskplanner/filetype-unknown.png", 48, 48),
        'generic-x-archive':        (_("Archive file"),             "taskplanner/generic-x-archive.png", 48, 48),
        'generic-x-audio':          (_("Audio file"),               "taskplanner/generic-x-audio.png", 48, 48),
        'generic-x-image':          (_("Image file"),               "taskplanner/generic-x-image.png", 48, 48),
        'generic-text-x-source':    (_("Source code file"),         "taskplanner/generic-text-x-source.png", 48, 48),
        'generic-x-video':          (_("Video file"),               "taskplanner/generic-x-video.png", 48, 48),
        '.doc':                     (_("MS Word file"),             "taskplanner/mime-msword.png", 48, 48),
        '.html':                    (_("HTML file"),                "taskplanner/mime-text-html.png", 48, 48),
        '.mdb':                     (_("MS Access file"),           "taskplanner/mime-msaccess.png", 48, 48),
        '.pdf':                     (_("PDF file"),                 "taskplanner/mime-pdf.png", 48, 48),  
        '.ppt':                     (_("MS PowerPoint file"),       "taskplanner/mime-mspowerpoint.png", 48, 48),
        '.txt':                     (_("Text file"),                "taskplanner/generic-x-text.png", 48, 48),
        '.xls':                     (_("MS Excel file"),            "taskplanner/mime-msexcel.png", 48, 48),
        # -- from Dropline's __init__.py (modified) --
        # smileys
        'X-(':        ("X-(",                    'dropline/angry.png',       18, 18),
        ':D':         (":D",                     'dropline/biggrin.png',     18, 18),
        '<:(':        ("<:(",                    'dropline/frown.png',       18, 18),
        ':o':         (":o",                     'dropline/redface.png',     18, 18),
        ':(':         (":(",                     'dropline/sad.png',         18, 18),
        ':)':         (":)",                     'dropline/smile.png',       18, 18),
        'B)':         ("B)",                     'dropline/smile2.png',      18, 18),
        ':))':        (":))",                    'dropline/smile3.png',      18, 18),
        ';)':         (";)",                     'dropline/smile4.png',      18, 18),
        '/!\\':       ("/!\\",                   'dropline/alert.png',       16, 16),
        '<!>':        ("<!>",                    'dropline/attention.png',   16, 16),
        '(!)':        ("(!)",                    'dropline/idea.png',        16, 16),
        ':-?':        (":-?",                    'dropline/tongue.png',      18, 18),
        ':\\':        (":\\",                    'dropline/ohwell.png',      18, 18),
        '>:>':        (">:>",                    'dropline/devil.png',       18, 18),
        '|)':         ("|)",                     'dropline/tired.png',       18, 18),

        # some folks use noses in their emoticons
        ':-(':        (":-(",                    'dropline/sad.png',         18, 18),
        ':-)':        (":-)",                    'dropline/smile.png',       18, 18),
        'B-)':        ("B-)",                    'dropline/smile2.png',      18, 18),
        ':-))':       (":-))",                   'dropline/smile3.png',      18, 18),
        ';-)':        (";-)",                    'dropline/smile4.png',      18, 18),
        '|-)':        ("|-)",                    'dropline/tired.png',       18, 18),

        # version 1.0
        '(./)':       ("(./)",                   'dropline/checkmark.png',   16, 16),
        '{OK}':       ("{OK}",                   'dropline/thumbs-up.png',   16, 16),
        '{X}':        ("{X}",                    'dropline/icon-error.png',  16, 16),
        '{i}':        ("{i}",                    'dropline/icon-info.png',   16, 16),
        '{1}':        ("{1}",                    'dropline/prio1.png',       16, 16),
        '{2}':        ("{2}",                    'dropline/prio2.png',       16, 16),
        '{3}':        ("{3}",                    'dropline/prio3.png',       16, 16),

        # version 1.3.4 (stars)
        # try {*}{*}{o}
        '{*}':        ("{*}",                    'dropline/star_on.png',     16, 16),
        '{o}':        ("{o}",                    'dropline/star_off.png',    16, 16),

        # new question mark smiley
        '<?>':        ("<?>",                    'dropline/question.png',     16, 16),

        # new big icons for classic theme
        'diff-big':       (_("Diffs"),           "dropline/moin-diff-big.png",   31, 25),
        'info-big':       (_("Info"),            "dropline/moin-info-big.png",   25, 25),
        'edit-big':       (_("Edit"),            "dropline/moin-edit-big.png",   25, 25),
        'unsubscribe-big':(_("Unsubscribe"),     "dropline/moin-unsubscribe-big.png",  25, 25),
        'subscribe-big':  (_("Subscribe"),       "dropline/moin-subscribe-big.png", 25, 25),
        'raw-big':        (_("Raw"),             "dropline/moin-raw-big.png",    25, 25),
        'print-big':      (_("Print"),           "dropline/moin-print-big.png",  25, 25),
        'view-big':       (_("View"),            "dropline/moin-show-big.png",   25, 25),
        
    }
    del _


    name = "modern"

    def header(self, d, **kw):
        """ Assemble wiki header
        
        @param d: parameter dictionary
        @rtype: unicode
        @return: page header html
        """
        html = [
            # Pre header custom html
            self.emit_custom_html(self.cfg.page_header1),
            
            # Header
            u'<div id="header">',
            self.logo(),
            self.searchform(d),
            self.username(d),
            u'<div id="locationline">',
            self.interwiki(d),
            self.title(d),
            u'</div>',
            self.trail(d),
            self.navibar(d),
            #u'<hr id="pageline">',
            u'<div id="pageline"><hr style="display:none;"></div>',
            self.msg(d),
            self.editbar(d),
            u'</div>',
            
            # Post header custom html (not recommended)
            self.emit_custom_html(self.cfg.page_header2),
            
            # Start of page
            self.startPage(),
        ]
        return u'\n'.join(html)

    def editorheader(self, d, **kw):
        """ Assemble wiki header for editor
        
        @param d: parameter dictionary
        @rtype: unicode
        @return: page header html
        """
        html = [
            # Pre header custom html
            self.emit_custom_html(self.cfg.page_header1),
            
            # Header
            u'<div id="header">',
            self.title(d),
            self.msg(d),
            u'</div>',
            
            # Post header custom html (not recommended)
            self.emit_custom_html(self.cfg.page_header2),
            
            # Start of page
            self.startPage(),
        ]
        return u'\n'.join(html)

    def footer(self, d, **keywords):
        """ Assemble wiki footer
        
        @param d: parameter dictionary
        @keyword ...:...
        @rtype: unicode
        @return: page footer html
        """
        page = d['page']
        html = [
            # End of page
            self.pageinfo(page),
            self.endPage(),
            
            # Pre footer custom html (not recommended!)
            self.emit_custom_html(self.cfg.page_footer1),
            
            # Footer
            u'<div id="footer">',
            self.editbar(d),
            self.credits(d),
            self.showversion(d, **keywords),
            u'</div>',
            
            # Post footer custom html
            self.emit_custom_html(self.cfg.page_footer2),
            ]
        return u'\n'.join(html)

        
def execute(request):
    """
    Generate and return a theme object
        
    @param request: the request object
    @rtype: MoinTheme
    @return: Theme object
    """
    return Theme(request)

