# This allows the administrator to undisable him when he is
# authenticated.
#
import MoinMoin
from   MoinMoin import userform
import os
import time

def execute(pagename, request):
  #
  # Execute the form identically to how wikiaction.do_userform()
  # does it.
  #
  form = request.form
  userName = form['name'][0]
  isCreate = (
    form.has_key('create') or
    form.has_key('create_only') or
    form.has_key('create_and_mail'))
  isNewUser = not MoinMoin.user.getUserId(request, userName)
  message = userform.savedata(request)
  #
  # If that created a new user then generate a cookie and
  # see if he wants to send an email.
  #
  user = MoinMoin.user.User(request, auth_username=userName)
  custom_data = None
  if isCreate and isNewUser and user.exists():
    urandom_file = file("/dev/urandom")
    user.confirm_cookie = "".join(
        ["%02x" % ord(c) for c in urandom_file.read(8)])
    url = "%s?n=%s&c=%s"  % (
	request.getBaseURL() + "/ConfirmCreateAccount",
	user.name, user.confirm_cookie)
    urandom_file.close()
    func = getattr(request.cfg, "ConfirmCreateAccount_email", None)
    if not func:
      custom_data = []
    else:
      custom_data = func(request, user, url)
  #
  # If he wants to generate an email then disable the account
  # and sent it.
  #
  if custom_data != None:
    email_data = default_email(request, user, url, custom_data)
    email_to, email_subject, email_text, cookie_expire, message = email_data
    user.confirm_ctime = str(time.time() + cookie_expire)
    user.disabled = 1
    user.valid = 0
    user.save()
    if not type(email_to) in (type([]), type(())):
     email_to = [email_to]
    mailok, msg = MoinMoin.util.mail.sendmail(
	request, email_to, email_subject, email_text,
	mail_from=request.cfg.mail_from)
  MoinMoin.Page.Page(request, pagename).send_page(request, msg=message)

EMAIL_TEXT = """
Somebody (hopefully you) tried to create an account on
this wiki with your email address.  If it was you then
you can finish the process by following the link below.
If it wasn't you then you can safely ignore this email.

%(url)s

Account Details:
  Name   %(user.name)s
  Email  %(user.email)s

--
Regards,
The %(sitename)s administrator
"""

def default_email(request, user, url, custom_data):
  #
  # The defaults.
  #
  to = user.email
  subject = request.cfg.sitename + " account creation"
  emailVars = {
      'sitename':		request.cfg.sitename,
      'url':			url,
      'user.name':		user.name,
      'user.confirm_cookie':	user.confirm_cookie,
      'user.email':		user.email,
    }
  text = EMAIL_TEXT % emailVars
  message = None
  default_data = [to, subject, text, 7*24*60*60, message]
  #
  # Use the defaults where he didn't give us something.
  #
  custom_data = list(custom_data)
  if len(custom_data) < len(default_data):
    custom_data += [None] * (len(default_data) - len(custom_data))
  else:
    custom_data = custom_data[:len(default_data)]
  email_data = [
      (c != None and c or d) for c, d in zip(custom_data, default_data)]
  #
  # If he didn't specify a message, then create a default one
  # depending on who he is sending the email to.
  #
  if email_data[4] == None:
    if email_data[0] == user.email:
      email_data[4] = "You should receive an email with further instructions shortly!"
    else:
      email_data[4] = "Your new account is waiting for the wiki administrator's for approval."
  return email_data
