/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapEdge;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.JLabel;

public abstract class EdgeView {
    protected NodeView source;
    protected NodeView target;
    private JLabel label = new JLabel();
    protected Point start;
    protected Point end;
    private static int i;
    static final Stroke DEF_STROKE;

    protected EdgeView(NodeView source, NodeView target) {
        this.source = source;
        this.target = target;
        this.label.setFont(this.getMap().getController().getFontThroughMap(new Font("Sans Serif", 0, 10)));
        this.label.setText(this.getModel().toString());
        this.getMap().add(this.label);
    }

    public void update() {
        this.label.setText(this.getModel().toString());
    }

    public void paint(Graphics2D g) {
    }

    public JLabel getLabel() {
        return this.label;
    }

    void remove() {
        this.getMap().remove(this.label);
    }

    public abstract Color getColor();

    public Stroke getStroke() {
        Stroke result = this.getModel().getStroke();
        if (result == null) {
            return DEF_STROKE;
        }
        return result;
    }

    public int getWidth() {
        return this.getModel().getWidth();
    }

    public int getRealWidth() {
        int width = this.getWidth();
        return width < 1 ? 1 : width;
    }

    protected MindMapEdge getModel() {
        return this.target.getModel().getEdge();
    }

    protected MapView getMap() {
        return this.source.getMap();
    }

    protected int getNodeShift(NodeView node) {
        if (node.getAlignment() == 0) {
            return 0;
        }
        if (node.getAlignment() == -1) {
            return -this.getRealWidth() / 2 + 1;
        }
        return 0;
    }

    protected int getTargetShift() {
        return this.getNodeShift(this.target);
    }

    protected int getSourceShift() {
        return this.getNodeShift(this.source);
    }

    protected void setRendering(Graphics2D g) {
        if (this.getMap().getController().getAntialiasEdges() || this.getMap().getController().getAntialiasAll()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public boolean isAntialiasAll() {
        return true;
    }

    public boolean isAntialiasEdges() {
        return true;
    }

    static {
        DEF_STROKE = new BasicStroke();
    }
}

