/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.browsemode;

import freemind.main.Tools;
import freemind.modes.ControllerAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.browsemode.BrowseArrowLinkModel;
import freemind.modes.browsemode.BrowseMapModel;
import freemind.modes.browsemode.BrowseNodeModel;
import freemind.modes.browsemode.BrowsePopupMenu;
import freemind.modes.browsemode.BrowseToolBar;
import freemind.view.mindmapview.NodeView;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class BrowseController
extends ControllerAdapter {
    private JPopupMenu popupmenu;
    private JToolBar toolbar;
    Action toggleFolded = new ControllerAdapter.ToggleFoldedAction();
    Action toggleChildrenFolded = new ControllerAdapter.ToggleChildrenFoldedAction();
    Action find = new ControllerAdapter.FindAction();
    Action findNext = new ControllerAdapter.FindNextAction();
    Action followLink = new FollowLinkAction();
    Action nodeUp = new ControllerAdapter.NodeUpAction();
    Action nodeDown = new ControllerAdapter.NodeDownAction();

    public void edit(KeyEvent e, boolean addNew, boolean editLong) {
    }

    public void addNew(NodeView target, int newNodeMode, KeyEvent e) {
    }

    public BrowseController(Mode mode) {
        super.setMode(mode);
        this.popupmenu = new BrowsePopupMenu(this);
        this.toolbar = new BrowseToolBar(this);
        this.setAllActions(false);
    }

    public MapAdapter newModel() {
        return new BrowseMapModel(this.getFrame());
    }

    public void doubleClick() {
        if (this.getSelected().getLink() == null) {
            this.toggleFolded();
        } else {
            this.loadURL();
        }
    }

    protected MindMapNode newNode() {
        return new BrowseNodeModel(this.getText("new_node"), this.getFrame());
    }

    JMenu getEditMenu() {
        JMenu editMenu = new JMenu();
        editMenu.add(this.getPopupMenu());
        return editMenu;
    }

    JMenu getFileMenu() {
        JMenu fileMenu = new JMenu();
        return fileMenu;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public JPopupMenu getPopupForModel(Object obj) {
        if (obj instanceof BrowseArrowLinkModel) {
            BrowseArrowLinkModel link = (BrowseArrowLinkModel)obj;
            JPopupMenu arrowLinkPopup = new JPopupMenu();
            arrowLinkPopup.add(new ControllerAdapter.GotoLinkNodeAction(((Object)link.getSource()).toString(), link.getSource()));
            arrowLinkPopup.add(new ControllerAdapter.GotoLinkNodeAction(((Object)link.getTarget()).toString(), link.getTarget()));
            arrowLinkPopup.addSeparator();
            HashSet<MindMapNode> NodeAlreadyVisited = new HashSet<MindMapNode>();
            NodeAlreadyVisited.add(link.getSource());
            NodeAlreadyVisited.add(link.getTarget());
            Vector links = this.getModel().getLinkRegistry().getAllLinks(link.getSource());
            links.addAll(this.getModel().getLinkRegistry().getAllLinks(link.getTarget()));
            for (int i = 0; i < links.size(); ++i) {
                BrowseArrowLinkModel foreign_link = (BrowseArrowLinkModel)links.get(i);
                if (NodeAlreadyVisited.add(foreign_link.getTarget())) {
                    arrowLinkPopup.add(new ControllerAdapter.GotoLinkNodeAction(((Object)foreign_link.getTarget()).toString(), foreign_link.getTarget()));
                }
                if (!NodeAlreadyVisited.add(foreign_link.getSource())) continue;
                arrowLinkPopup.add(new ControllerAdapter.GotoLinkNodeAction(((Object)foreign_link.getSource()).toString(), foreign_link.getSource()));
            }
            return arrowLinkPopup;
        }
        return null;
    }

    private BrowseMapModel getModel() {
        return (BrowseMapModel)this.getController().getModel();
    }

    private BrowseNodeModel getSelected() {
        return (BrowseNodeModel)this.getView().getSelected().getModel();
    }

    BrowseToolBar getToolBar() {
        return (BrowseToolBar)this.toolbar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadURL(String relative) {
        URL absolute = null;
        try {
            BrowseMapModel map = (BrowseMapModel)this.getMap();
            absolute = map != null ? new URL(map.getURL(), relative) : new URL(relative);
            this.getFrame().out(absolute.toString());
        }
        catch (MalformedURLException ex) {
            this.getController().errorMessage(this.getText("url_error") + " " + ex.getMessage());
            return;
        }
        String type = Tools.getExtension(absolute.getFile());
        try {
            this.getFrame().setWaitingCursor(true);
            this.load(absolute);
        }
        catch (Exception ex) {
            this.getController().errorMessage(this.getText("url_load_error") + absolute);
            ex.printStackTrace();
        }
        finally {
            this.getFrame().setWaitingCursor(false);
        }
    }

    public void loadURL() {
        String link = this.getSelected().getLink();
        if (link != null) {
            this.loadURL(link);
        }
    }

    private void load(URL url) throws Exception {
        this.getToolBar().setURLField(url.toString());
        BrowseMapModel model = (BrowseMapModel)this.newModel();
        model.load(url);
        this.newMap(model);
        this.mapOpened(true);
    }

    protected void setAllActions(boolean enabled) {
        this.toggleFolded.setEnabled(enabled);
        this.toggleChildrenFolded.setEnabled(enabled);
        this.followLink.setEnabled(enabled);
    }

    private class FollowLinkAction
    extends AbstractAction {
        FollowLinkAction() {
            super(BrowseController.this.getText("follow_link"));
        }

        public void actionPerformed(ActionEvent e) {
            BrowseController.this.loadURL();
        }
    }
}

