/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.controller.MindMapNodesSelection;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.view.mindmapview.NodeView;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ListIterator;
import javax.swing.JOptionPane;

public class NodeDropListener
implements DropTargetListener {
    private final Controller c;

    public NodeDropListener(Controller controller) {
        this.c = controller;
    }

    private boolean isDragAcceptable(DropTargetDragEvent ev) {
        if (ev.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return true;
        }
        return ev.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor);
    }

    private boolean isDropAcceptable(DropTargetDropEvent event) {
        MindMapNode selected;
        MindMapNode node = ((NodeView)event.getDropTargetContext().getComponent()).getModel();
        return node != (selected = this.c.getView().getSelected().getModel()) && !node.isDescendantOf(selected);
    }

    public void drop(DropTargetDropEvent dtde) {
        try {
            int dropAction = dtde.getDropAction();
            Transferable t = dtde.getTransferable();
            NodeView targetNodeView = (NodeView)dtde.getDropTargetContext().getComponent();
            MindMapNode targetNode = targetNodeView.getModel();
            MindMapNodeModel targetNodeModel = (MindMapNodeModel)targetNode;
            if (dtde.isLocalTransfer() && t.isDataFlavorSupported(MindMapNodesSelection.dropActionFlavor)) {
                String sourceAction = (String)t.getTransferData(MindMapNodesSelection.dropActionFlavor);
                if (sourceAction.equals("LINK")) {
                    dropAction = 0x40000000;
                }
                if (sourceAction.equals("COPY")) {
                    dropAction = 1;
                }
            }
            targetNodeView.setDraggedOver(0);
            targetNodeView.repaint();
            if (dtde.isLocalTransfer() && dropAction == 2 && !this.isDropAcceptable(dtde)) {
                dtde.rejectDrop();
                return;
            }
            dtde.acceptDrop(dtde.getDropAction());
            if (!dtde.isLocalTransfer()) {
                this.c.getModel().paste(t, targetNode, targetNodeView.dropAsSibling(dtde.getLocation().getX()), targetNodeView.dropPosition(dtde.getLocation().getX()));
                dtde.dropComplete(true);
                return;
            }
            if (dropAction == 0x40000000) {
                MindMapMapModel mindMapMapModel = (MindMapMapModel)this.c.getModel();
                int yesorno = 0;
                if (this.c.getView().getSelecteds().size() >= 5) {
                    yesorno = JOptionPane.showConfirmDialog(this.c.getFrame().getContentPane(), this.c.getResourceString("lots_of_links_warning"), Integer.toString(this.c.getView().getSelecteds().size()) + " links to the same node", 0);
                }
                if (yesorno == 0) {
                    ListIterator it = this.c.getView().getSelecteds().listIterator();
                    while (it.hasNext()) {
                        MindMapNodeModel selectedNodeModel = (MindMapNodeModel)((NodeView)it.next()).getModel();
                        mindMapMapModel.addLink(selectedNodeModel, targetNodeModel);
                    }
                }
            } else {
                this.c.getModel().paste(dropAction == 2 ? this.c.getModel().cut() : this.c.getModel().copy(), targetNode, targetNodeView.dropAsSibling(dtde.getLocation().getX()), targetNodeView.dropPosition(dtde.getLocation().getX()));
            }
            this.c.getView().selectAsTheOnlyOneSelected(targetNodeModel.getViewer());
        }
        catch (Exception e) {
            System.err.println("Drop exception:" + e);
            e.printStackTrace();
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent e) {
        boolean repaint;
        NodeView draggedNode = (NodeView)e.getDropTargetContext().getComponent();
        int oldDraggedOver = draggedNode.getDraggedOver();
        draggedNode.setDraggedOver(e.getLocation());
        int newDraggedOver = draggedNode.getDraggedOver();
        boolean bl = repaint = newDraggedOver != oldDraggedOver;
        if (repaint) {
            draggedNode.repaint();
        }
    }

    public void dragExit(DropTargetEvent e) {
        NodeView draggedNode = (NodeView)e.getDropTargetContext().getComponent();
        draggedNode.setDraggedOver(0);
        draggedNode.repaint();
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }
}

