/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.twiki;

import Acme.JPM.Encoders.GifEncoder;
import CH.ifa.draw.appframe.Application;
import CH.ifa.draw.appframe.DrawFrame;
import CH.ifa.draw.contrib.PolygonTool;
import CH.ifa.draw.figures.BorderTool;
import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.ElbowConnection;
import CH.ifa.draw.figures.EllipseFigure;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineFigure;
import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.figures.ScribbleTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.figures.TextTool;
import CH.ifa.draw.figures.URLTool;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.AlignCommand;
import CH.ifa.draw.standard.BringToFrontCommand;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ConnectionTool;
import CH.ifa.draw.standard.CopyCommand;
import CH.ifa.draw.standard.CreationTool;
import CH.ifa.draw.standard.CutCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.PasteCommand;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.standard.ToggleGuidesCommand;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.Command;
import CH.ifa.draw.util.CommandButton;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.StorableOutput;
import com.eteks.filter.Web216ColorsFilter;
import com.keypoint.PngEncoderIndexed;
import java.awt.Button;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;

public class TWikiFrame
extends DrawFrame {
    private static String UNTITLED_PARAMETER = "untitled";
    private static String DRAWPATH_PARAMETER = "drawpath";
    private static String GIFPATH_PARAMETER = "gifpath";
    private static String PNGPATH_PARAMETER = "pngpath";
    private static String SVGPATH_PARAMETER = "svgpath";
    private static String SAVEPATH_PARAMETER = "savepath";
    private static String BASENAME_PARAMETER = "basename";
    private static String HELPPATH_PARAMETER = "helppath";
    private static String BORDERSIZE_PARAMETER = "bordersize";
    private Label fStatusLabel;
    private boolean bPostEnabled = true;

    public TWikiFrame(Application application, String string) {
        super("TWikiDraw", application);
        this.view().setBackground(Color.white);
        ColorMap.reset();
        if (string != null) {
            do {
                String string2;
                int n;
                if ((n = string.indexOf(44)) == -1) {
                    string2 = string;
                    string = "";
                } else {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                }
                n = string2.indexOf(61);
                if (n == -1) continue;
                String string3 = string2.substring(0, n).trim();
                if (n < string2.length() - 1 && string2.charAt(n + 1) == '#') {
                    ++n;
                }
                String string4 = string2.substring(n + 1).trim();
                try {
                    int n2 = Integer.valueOf(string4, 16);
                    ColorMap.getColorMap().addColor(string3, new Color(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            } while (string.length() > 0);
        }
        if (application.getParameter(DRAWPATH_PARAMETER) != null) {
            this.loadDrawing(DRAWPATH_PARAMETER);
        }
    }

    protected void populateMenuBar(MenuBar menuBar) {
        menuBar.add(this.createDrawingMenu());
        menuBar.add(this.createEditMenu());
        menuBar.add(this.createSelectionMenu());
        menuBar.add(this.createFillMenu());
        menuBar.add(this.createLineMenu());
        menuBar.add(this.createTextMenu());
        this.setMenuBar(menuBar);
    }

    protected CommandMenu createDrawingMenu() {
        CommandMenu commandMenu = new CommandMenu("Drawing");
        commandMenu.add(new NewDrawingCommand(this));
        commandMenu.add(new ReloadDrawingCommand(this));
        commandMenu.add(new SaveDrawingCommand(this));
        commandMenu.add(new ExitDrawingCommand(this));
        return commandMenu;
    }

    protected CommandMenu createEditMenu() {
        CommandMenu commandMenu = new CommandMenu("Edit");
        commandMenu.add(new DeleteCommand("Delete", this.view()));
        commandMenu.add(new CutCommand("Cut", this.view()));
        commandMenu.add(new CopyCommand("Copy", this.view()));
        commandMenu.add(new PasteCommand("Paste", this.view()));
        commandMenu.add(new ToggleGuidesCommand("Toggle guides", this.view()));
        return commandMenu;
    }

    protected CommandMenu createSelectionMenu() {
        CommandMenu commandMenu = new CommandMenu("Selection");
        commandMenu.add(new DuplicateCommand("Duplicate", this.view()));
        commandMenu.add(new GroupCommand("Group", this.view()));
        commandMenu.add(new UngroupCommand("Ungroup", this.view()));
        commandMenu.add(new SendToBackCommand("Send to Back", this.view()));
        commandMenu.add(new BringToFrontCommand("Bring to Front", this.view()));
        CommandMenu commandMenu2 = new CommandMenu("Align");
        commandMenu2.add(new AlignCommand("Lefts", this.view(), 0));
        commandMenu2.add(new AlignCommand("Centres", this.view(), 1));
        commandMenu2.add(new AlignCommand("Rights", this.view(), 2));
        commandMenu2.add(new AlignCommand("Tops", this.view(), 3));
        commandMenu2.add(new AlignCommand("Middles", this.view(), 4));
        commandMenu2.add(new AlignCommand("Bottoms", this.view(), 5));
        commandMenu.add(commandMenu2);
        return commandMenu;
    }

    protected CommandMenu createFillMenu() {
        CommandMenu commandMenu = new CommandMenu("Fill");
        commandMenu.add(this.createColorMenu("FillColor"));
        return commandMenu;
    }

    protected CommandMenu createLineMenu() {
        CommandMenu commandMenu = new CommandMenu("Line");
        commandMenu.add(this.createColorMenu("FrameColor"));
        CommandMenu commandMenu2 = new CommandMenu("Arrows");
        commandMenu2.add(new ChangeAttributeCommand("none", "ArrowMode", new Integer(0), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("at Start", "ArrowMode", new Integer(1), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("at End", "ArrowMode", new Integer(2), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("at Both ends", "ArrowMode", new Integer(3), this.view()));
        commandMenu.add(commandMenu2);
        return commandMenu;
    }

    protected CommandMenu createTextMenu() {
        CommandMenu commandMenu = new CommandMenu("Text");
        commandMenu.add(this.createFontMenu());
        commandMenu.add(this.createColorMenu("TextColor"));
        CommandMenu commandMenu2 = new CommandMenu("Style");
        commandMenu2.add(new ChangeAttributeCommand("Plain", "FontStyle", new Integer(0), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("Italic", "FontStyle", new Integer(2), this.view()));
        commandMenu2.add(new ChangeAttributeCommand("Bold", "FontStyle", new Integer(1), this.view()));
        commandMenu.add(commandMenu2);
        CommandMenu commandMenu3 = new CommandMenu("Align");
        commandMenu3.add(new ChangeAttributeCommand("Left", "TextAlign", "Left", this.view()));
        commandMenu3.add(new ChangeAttributeCommand("Centre", "TextAlign", "Centre", this.view()));
        commandMenu3.add(new ChangeAttributeCommand("Right", "TextAlign", "Right", this.view()));
        commandMenu.add(commandMenu3);
        return commandMenu;
    }

    protected void populateWestPanel(Panel panel) {
        super.populateWestPanel(panel);
        AbstractTool abstractTool = new TextTool(this.view(), new TextFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/TEXT", "Text Tool", abstractTool));
        abstractTool = new ConnectedTextTool(this.view(), new TextFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/ATEXT", "Connected Text Tool", abstractTool));
        abstractTool = new CreationTool(this.view(), new RectangleFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/RECT", "Rectangle Tool", abstractTool));
        abstractTool = new CreationTool(this.view(), new RoundRectangleFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/RRECT", "Round Rectangle Tool", abstractTool));
        abstractTool = new CreationTool(this.view(), new EllipseFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/ELLIPSE", "Ellipse Tool", abstractTool));
        abstractTool = new CreationTool(this.view(), new LineFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/LINE", "Line Tool", abstractTool));
        abstractTool = new ConnectionTool(this.view(), new LineConnection());
        panel.add(this.createToolButton("/CH/ifa/draw/images/CONN", "Connection Tool", abstractTool));
        abstractTool = new ConnectionTool(this.view(), new ElbowConnection());
        panel.add(this.createToolButton("/CH/ifa/draw/images/OCONN", "Elbow Connection Tool", abstractTool));
        abstractTool = new ScribbleTool(this.view());
        panel.add(this.createToolButton("/CH/ifa/draw/images/SCRIBBL", "Scribble Tool", abstractTool));
        abstractTool = new PolygonTool(this.view());
        panel.add(this.createToolButton("/CH/ifa/draw/images/POLYGON", "Polygon Tool", abstractTool));
        abstractTool = new BorderTool(this.view());
        panel.add(this.createToolButton("/CH/ifa/draw/images/BORDDEC", "Border Tool", abstractTool));
        abstractTool = new URLTool(this.view(), new RectangleFigure());
        panel.add(this.createToolButton("/CH/ifa/draw/images/URL", "URL Tool", abstractTool));
    }

    protected Panel createSouthPanel() {
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        return panel;
    }

    protected void populateSouthPanel(Panel panel) {
        Panel panel2 = new Panel();
        Button button = new CommandButton(new DeleteCommand("Delete", this.view()));
        panel2.add(button);
        button = new CommandButton(new DuplicateCommand("Duplicate", this.view()));
        panel2.add(button);
        button = new CommandButton(new GroupCommand("Group", this.view()));
        panel2.add(button);
        button = new CommandButton(new UngroupCommand("Ungroup", this.view()));
        panel2.add(button);
        button = new CommandButton(new BringToFrontCommand("Bring To Front", this.view()));
        panel2.add(button);
        button = new CommandButton(new SendToBackCommand("Send To Back", this.view()));
        panel2.add(button);
        button = new Button("Help");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TWikiFrame.this.showHelp();
            }
        });
        panel2.add(button);
        panel.add(panel2);
        this.fStatusLabel = new Label("Status");
        panel.add(this.fStatusLabel);
    }

    public void showStatus(String string) {
        if (this.fStatusLabel != null) {
            this.fStatusLabel.setText(string);
        } else {
            this.getApplication().showStatus(string);
        }
    }

    protected void setSimpleDisplayUpdate() {
    }

    protected void setBufferedDisplayUpdate() {
    }

    protected void showHelp() {
        String string = this.getApplication().getParameter(HELPPATH_PARAMETER);
        this.getApplication().popupFrame(string, "Help");
    }

    public void doLoadDrawing(String string) {
        this.loadDrawing(string);
        this.view().setBackground(Color.white);
    }

    public boolean doSaveDrawing() {
        Application application = this.getApplication();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        this.setCursor(new Cursor(3));
        try {
            Object object;
            String string;
            String string2;
            String string3;
            Object object2;
            String string4;
            String string5;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            StorableOutput storableOutput = new StorableOutput(byteArrayOutputStream);
            storableOutput.writeStorable(this.drawing());
            storableOutput.close();
            String string6 = application.getParameter(DRAWPATH_PARAMETER);
            if (string6 == null) {
                string6 = "untitled.draw";
            }
            if ((string5 = application.getParameter(SAVEPATH_PARAMETER)) == null) {
                string5 = "";
            }
            if ((string4 = application.getParameter(BASENAME_PARAMETER)) == null) {
                string4 = "SET_BASENAME_PARAM";
            }
            this.showStatus("Saving " + string4 + ".draw");
            if (this.bPostEnabled) {
                bl5 = application.post(string5, string4 + ".draw", "text/plain", string6, byteArrayOutputStream.toString(), "TWiki Draw draw file");
            }
            Dimension dimension = new Dimension(0, 0);
            FigureEnumeration figureEnumeration = this.drawing().figuresReverse();
            while (figureEnumeration.hasMoreElements()) {
                Figure figure = figureEnumeration.nextFigure();
                object2 = figure.displayBox();
                if (((Rectangle)object2).x + ((Rectangle)object2).width > dimension.width) {
                    dimension.setSize(((Rectangle)object2).x + ((Rectangle)object2).width, dimension.height);
                }
                if (((Rectangle)object2).y + ((Rectangle)object2).height <= dimension.height) continue;
                dimension.setSize(dimension.width, ((Rectangle)object2).y + ((Rectangle)object2).height);
            }
            int n = 10;
            object2 = this.getApplication().getParameter(BORDERSIZE_PARAMETER);
            if (object2 != null && (n = Integer.valueOf((String)object2).intValue()) < 0) {
                n = 0;
            }
            if ((string3 = this.drawing().getMap()).length() > 0) {
                string2 = string6.substring(0, string6.length() - 5) + ".map";
                this.showStatus("Saving " + string4 + ".map");
                string = "<area shape=\"rect\" coords=\"";
                object = "\" href=\"%TWIKIDRAW%\" alt=\"%EDITTEXT%\" title=\"%EDITTEXT%\" %HOVER% />";
                string3 = "<map name=\"%MAPNAME%\">" + string3 + string + "0,0," + (dimension.width + n) + "," + n / 2 + (String)object + string + "0,0," + n / 2 + "," + (dimension.height + n) + (String)object + string + (dimension.width + n / 2) + ",0," + (dimension.width + n) + "," + (dimension.height + n) + (String)object + string + "0," + (dimension.height + n / 2) + "," + (dimension.width + n) + "," + (dimension.height + n) + (String)object + "</map>";
                bl = application.post(string5, string4 + ".map", "text/plain", string2 + ".map", string3, "TWiki Draw map file");
            } else {
                string2 = string6.substring(0, string6.length() - 5);
                bl = application.post(string5, string4 + ".map", "text/plain", string2 + ".map", "", "");
            }
            string2 = this.getApplication().getParameter(GIFPATH_PARAMETER);
            if (string2 == null || string2.length() == 0) {
                string2 = null;
            }
            if ((string = this.getApplication().getParameter(PNGPATH_PARAMETER)) == null || string.length() == 0) {
                string = null;
            }
            if (string2 != null || string != null) {
                char[] cArray;
                object = this.createImage(dimension, n);
                if (this.bPostEnabled && string != null) {
                    this.showStatus("Saving " + string4 + ".png");
                    cArray = this.convertToPng((Image)object);
                    bl2 = application.post(string5, string4 + ".png", "image/png", string, String.valueOf(cArray, 0, cArray.length), "TWiki Draw PNG file");
                }
                if (this.bPostEnabled && string2 != null) {
                    this.showStatus("Saving " + string4 + ".gif");
                    cArray = this.convertToGif((Image)object);
                    bl3 = application.post(string5, string4 + ".gif", "image/gif", string2, String.valueOf(cArray, 0, cArray.length), "TWiki Draw GIF file");
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.setCursor(new Cursor(0));
            this.showStatus("Bad Wiki servlet URL: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.setCursor(new Cursor(0));
            this.showStatus(iOException.toString());
        }
        this.setCursor(new Cursor(0));
        this.showStatus("Saved .draw " + (bl5 ? "OK" : "Failed") + " .map " + (bl ? "OK" : "Failed") + " .gif " + (bl3 ? "OK" : "Failed") + " .png " + (bl2 ? "OK" : "Failed"));
        return bl5;
    }

    void enablePost(boolean bl) {
        this.bPostEnabled = bl;
        if (!this.bPostEnabled) {
            this.setTitle(this.getTitle() + " - POST DISABLED FOR TESTING");
        }
    }

    static void debug(String string) {
        System.err.println("TWikiDraw:" + string);
    }

    private Image createImage(Dimension dimension, int n) {
        this.view().clearSelection();
        Image image = this.view().createImage(dimension.width + n, dimension.height + n);
        Graphics graphics = image.getGraphics();
        this.view().enableGuides(false);
        this.view().drawAll(graphics);
        return image;
    }

    private char[] convertToGif(Image image) throws IOException {
        TWikiFrame.debug("converting data to GIF...");
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            new GifEncoder(image, (OutputStream)byteArrayOutputStream).encode();
        }
        catch (IOException iOException) {
            TWikiFrame.debug("GIF uses too many colors, reducing to 216 colors...");
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new Web216ColorsFilter());
            byteArrayOutputStream = new ByteArrayOutputStream();
            new GifEncoder(filteredImageSource, (OutputStream)byteArrayOutputStream).encode();
            TWikiFrame.debug("Color reduction successful.");
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        int n = byteArrayOutputStream.size();
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray[i];
        }
        TWikiFrame.debug("conversion to GIF successful.");
        return cArray;
    }

    private char[] convertToPng(Image image) throws IOException {
        TWikiFrame.debug("converting data to PNG...");
        PngEncoderIndexed pngEncoderIndexed = new PngEncoderIndexed(image);
        byte[] byArray = pngEncoderIndexed.pngEncode();
        int n = byArray.length;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)byArray[i];
        }
        TWikiFrame.debug("conversion to PNG successful.");
        return cArray;
    }

    class ExitDrawingCommand
    extends Command {
        TWikiFrame frame;

        public ExitDrawingCommand(TWikiFrame tWikiFrame2) {
            super("Exit without saving");
            this.frame = tWikiFrame2;
        }

        public void execute() {
            TWikiFrame.this.getApplication().exit();
        }
    }

    class SaveDrawingCommand
    extends Command {
        TWikiFrame frame;

        public SaveDrawingCommand(TWikiFrame tWikiFrame2) {
            super("Save and Exit");
            this.frame = tWikiFrame2;
        }

        public void execute() {
            if (this.frame.doSaveDrawing()) {
                TWikiFrame.this.getApplication().exit();
            }
        }
    }

    class ReloadDrawingCommand
    extends Command {
        TWikiFrame frame;

        public ReloadDrawingCommand(TWikiFrame tWikiFrame2) {
            super("Reload");
            this.frame = tWikiFrame2;
        }

        public void execute() {
            this.frame.doLoadDrawing(DRAWPATH_PARAMETER);
        }
    }

    class NewDrawingCommand
    extends Command {
        TWikiFrame frame;

        public NewDrawingCommand(TWikiFrame tWikiFrame2) {
            super("Clear");
            this.frame = tWikiFrame2;
        }

        public void execute() {
            this.frame.doLoadDrawing(UNTITLED_PARAMETER);
        }
    }
}

