/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.ChopPolygonConnector;
import CH.ifa.draw.contrib.PolygonHandle;
import CH.ifa.draw.contrib.PolygonScaleHandle;
import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.Connector;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.standard.AbstractLocator;
import CH.ifa.draw.util.Geom;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Vector;

public class PolygonFigure
extends AttributeFigure {
    static final int TOO_CLOSE = 2;
    private static final long serialVersionUID = 6254089689239215026L;
    private int polygonFigureSerializedDataVersion = 1;
    protected Polygon fPoly = new Polygon();

    public PolygonFigure() {
    }

    public PolygonFigure(int n, int n2) {
        this.fPoly.addPoint(n, n2);
    }

    public PolygonFigure(Polygon polygon) {
        this.fPoly = new Polygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public Rectangle displayBox() {
        return PolygonFigure.bounds(this.fPoly);
    }

    public boolean isEmpty() {
        return this.fPoly.npoints < 3 || this.size().width < 2 && this.size().height < 2;
    }

    public Vector handles() {
        Vector<AbstractHandle> vector = new Vector<AbstractHandle>(this.fPoly.npoints);
        for (int i = 0; i < this.fPoly.npoints; ++i) {
            vector.addElement(new PolygonHandle(this, PolygonFigure.locator(i), i));
        }
        vector.addElement(new PolygonScaleHandle(this));
        return vector;
    }

    public void basicDisplayBox(Point point, Point point2) {
        Rectangle rectangle = this.displayBox();
        int n = point.x - rectangle.x;
        int n2 = point.y - rectangle.y;
        this.fPoly.translate(n, n2);
        rectangle = this.displayBox();
        Point point3 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Polygon polygon = this.getPolygon();
        this.scaleRotate(point3, polygon, point2);
    }

    public Polygon getPolygon() {
        return new Polygon(this.fPoly.xpoints, this.fPoly.ypoints, this.fPoly.npoints);
    }

    public Point center() {
        return PolygonFigure.center(this.fPoly);
    }

    public Enumeration points() {
        Vector<Point> vector = new Vector<Point>(this.fPoly.npoints);
        for (int i = 0; i < this.fPoly.npoints; ++i) {
            vector.addElement(new Point(this.fPoly.xpoints[i], this.fPoly.ypoints[i]));
        }
        return vector.elements();
    }

    public int pointCount() {
        return this.fPoly.npoints;
    }

    public void basicMoveBy(int n, int n2) {
        this.fPoly.translate(n, n2);
    }

    public void drawBackground(Graphics graphics) {
        graphics.fillPolygon(this.fPoly);
    }

    public void drawFrame(Graphics graphics) {
        graphics.drawPolygon(this.fPoly);
    }

    public boolean containsPoint(int n, int n2) {
        return this.fPoly.contains(n, n2);
    }

    public Connector connectorAt(int n, int n2) {
        return new ChopPolygonConnector(this);
    }

    public void addPoint(int n, int n2) {
        this.fPoly.addPoint(n, n2);
        this.changed();
    }

    public void setPointAt(Point point, int n) {
        this.willChange();
        this.fPoly.xpoints[n] = point.x;
        this.fPoly.ypoints[n] = point.y;
        this.changed();
    }

    public void insertPointAt(Point point, int n) {
        int n2;
        this.willChange();
        int n3 = this.fPoly.npoints + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = this.fPoly.xpoints[n2];
            nArray2[n2] = this.fPoly.ypoints[n2];
        }
        nArray[n] = point.x;
        nArray2[n] = point.y;
        for (n2 = n; n2 < this.fPoly.npoints; ++n2) {
            nArray[n2 + 1] = this.fPoly.xpoints[n2];
            nArray2[n2 + 1] = this.fPoly.ypoints[n2];
        }
        this.fPoly = new Polygon(nArray, nArray2, n3);
        this.changed();
    }

    public void removePointAt(int n) {
        int n2;
        this.willChange();
        int n3 = this.fPoly.npoints - 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = this.fPoly.xpoints[n2];
            nArray2[n2] = this.fPoly.ypoints[n2];
        }
        for (n2 = n; n2 < n3; ++n2) {
            nArray[n2] = this.fPoly.xpoints[n2 + 1];
            nArray2[n2] = this.fPoly.ypoints[n2 + 1];
        }
        this.fPoly = new Polygon(nArray, nArray2, n3);
        this.changed();
    }

    public void scaleRotate(Point point, Polygon polygon, Point point2) {
        this.willChange();
        Point point3 = PolygonFigure.center(polygon);
        double d = Geom.length(point3.x, point3.y, point.x, point.y);
        if (d > 0.0) {
            double d2 = Geom.length(point3.x, point3.y, point2.x, point2.y);
            double d3 = d2 / d;
            double d4 = Math.atan2(point.y - point3.y, point.x - point3.x);
            double d5 = Math.atan2(point2.y - point3.y, point2.x - point3.x);
            double d6 = d5 - d4;
            int n = polygon.npoints;
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2 = polygon.xpoints[i];
                int n3 = polygon.ypoints[i];
                double d7 = (double)Geom.length(point3.x, point3.y, n2, n3) * d3;
                double d8 = Math.atan2(n3 - point3.y, n2 - point3.x) + d6;
                nArray[i] = (int)((double)point3.x + d7 * Math.cos(d8) + 0.5);
                nArray2[i] = (int)((double)point3.y + d7 * Math.sin(d8) + 0.5);
            }
            this.fPoly = new Polygon(nArray, nArray2, n);
        }
        this.changed();
    }

    public void smoothPoints() {
        this.willChange();
        boolean bl = false;
        int n = this.fPoly.npoints;
        do {
            bl = false;
            int n2 = 0;
            while (n2 < n && n >= 3) {
                int n3 = (n2 - 1 + n) % n;
                int n4 = (n2 + 1) % n;
                if (PolygonFigure.distanceFromLine(this.fPoly.xpoints[n3], this.fPoly.ypoints[n3], this.fPoly.xpoints[n4], this.fPoly.ypoints[n4], this.fPoly.xpoints[n2], this.fPoly.ypoints[n2]) < 2.0) {
                    bl = true;
                    --n;
                    for (int i = n2; i < n; ++i) {
                        this.fPoly.xpoints[i] = this.fPoly.xpoints[i + 1];
                        this.fPoly.ypoints[i] = this.fPoly.ypoints[i + 1];
                    }
                    continue;
                }
                ++n2;
            }
        } while (bl);
        if (n != this.fPoly.npoints) {
            this.fPoly = new Polygon(this.fPoly.xpoints, this.fPoly.ypoints, n);
        }
        this.changed();
    }

    public int splitSegment(int n, int n2) {
        int n3 = this.findSegment(n, n2);
        if (n3 != -1) {
            this.insertPointAt(new Point(n, n2), n3 + 1);
            return n3 + 1;
        }
        return -1;
    }

    public Point pointAt(int n) {
        return new Point(this.fPoly.xpoints[n], this.fPoly.ypoints[n]);
    }

    public Point outermostPoint() {
        Point point = this.center();
        int n = 0;
        long l = 0L;
        for (int i = 0; i < this.fPoly.npoints; ++i) {
            long l2 = Geom.length2(point.x, point.y, this.fPoly.xpoints[i], this.fPoly.ypoints[i]);
            if (l2 <= l) continue;
            l = l2;
            n = i;
        }
        return new Point(this.fPoly.xpoints[n], this.fPoly.ypoints[n]);
    }

    public int findSegment(int n, int n2) {
        double d = 2.0;
        int n3 = -1;
        for (int i = 0; i < this.fPoly.npoints; ++i) {
            int n4 = (i + 1) % this.fPoly.npoints;
            double d2 = PolygonFigure.distanceFromLine(this.fPoly.xpoints[i], this.fPoly.ypoints[i], this.fPoly.xpoints[n4], this.fPoly.ypoints[n4], n, n2);
            if (!(d2 < d)) continue;
            d = d2;
            n3 = i;
        }
        return n3;
    }

    public Point chop(Point point) {
        return PolygonFigure.chop(this.fPoly, point);
    }

    public String getMap() {
        String string = (String)this.getAttribute("Sensitive");
        if (string == null || string.length() == 0) {
            return "";
        }
        try {
            string = URLDecoder.decode(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Rectangle rectangle = this.displayBox();
        String string2 = "";
        for (int i = 0; i < this.fPoly.npoints; ++i) {
            if (i > 0) {
                string2 = string2 + ",";
            }
            string2 = string2 + this.fPoly.xpoints[i] + "," + this.fPoly.ypoints[i];
        }
        return "<area shape=\"poly\" coords=\"" + string2 + "\" href=\"" + string + "\" alt=\"" + string + "\" />";
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeInt(this.fPoly.npoints);
        for (int i = 0; i < this.fPoly.npoints; ++i) {
            storableOutput.writeInt(this.fPoly.xpoints[i]);
            storableOutput.writeInt(this.fPoly.ypoints[i]);
        }
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        int n = storableInput.readInt();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = storableInput.readInt();
            nArray2[i] = storableInput.readInt();
        }
        this.fPoly = new Polygon(nArray, nArray2, n);
    }

    public static Locator locator(final int n) {
        return new AbstractLocator(){

            public Point locate(Figure figure) {
                PolygonFigure polygonFigure = (PolygonFigure)figure;
                if (n < polygonFigure.pointCount()) {
                    return ((PolygonFigure)figure).pointAt(n);
                }
                return new Point(-1, -1);
            }
        };
    }

    public static double distanceFromLine(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n3 - n;
        int n8 = n4 - n2;
        long l = n7 * n7 + n8 * n8;
        if (l == 0L) {
            return Geom.length(n, n2, n5, n6);
        }
        double d = (n2 - n6) * (n2 - n4) - (n - n5) * (n3 - n);
        double d2 = d / (double)l;
        if (d2 < 0.0 || d2 > 1.0) {
            return Double.MAX_VALUE;
        }
        double d3 = (double)n + d2 * (double)n7;
        double d4 = (double)n2 + d2 * (double)n8;
        double d5 = (double)n5 - d3;
        double d6 = (double)n6 - d4;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public static Rectangle bounds(Polygon polygon) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = polygon.npoints;
        for (int i = 0; i < n5; ++i) {
            int n6 = polygon.xpoints[i];
            int n7 = polygon.ypoints[i];
            if (n6 > n3) {
                n3 = n6;
            }
            if (n6 < n) {
                n = n6;
            }
            if (n7 > n4) {
                n4 = n7;
            }
            if (n7 >= n2) continue;
            n2 = n7;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    public static Point center(Polygon polygon) {
        long l = 0L;
        long l2 = 0L;
        int n = polygon.npoints;
        for (int i = 0; i < n; ++i) {
            l += (long)polygon.xpoints[i];
            l2 += (long)polygon.ypoints[i];
        }
        return new Point((int)(l / (long)n), (int)(l2 / (long)n));
    }

    public static Point chop(Polygon polygon, Point point) {
        int n;
        Point point2 = PolygonFigure.center(polygon);
        int n2 = -1;
        int n3 = -1;
        long l = Long.MAX_VALUE;
        for (n = 0; n < polygon.npoints; ++n) {
            long l2;
            int n4 = (n + 1) % polygon.npoints;
            Point point3 = Geom.intersect(polygon.xpoints[n], polygon.ypoints[n], polygon.xpoints[n4], polygon.ypoints[n4], point.x, point.y, point2.x, point2.y);
            if (point3 == null || (l2 = Geom.length2(point3.x, point3.y, point.x, point.y)) >= l) continue;
            l = l2;
            n2 = point3.x;
            n3 = point3.y;
        }
        for (n = 0; n < polygon.npoints; ++n) {
            long l3 = Geom.length2(polygon.xpoints[n], polygon.ypoints[n], point.x, point.y);
            if (l3 >= l) continue;
            l = l3;
            n2 = polygon.xpoints[n];
            n3 = polygon.ypoints[n];
        }
        return new Point(n2, n3);
    }
}

