/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.appframe;

import CH.ifa.draw.appframe.Application;
import CH.ifa.draw.figures.GroupCommand;
import CH.ifa.draw.figures.UngroupCommand;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.DuplicateCommand;
import CH.ifa.draw.standard.SelectionTool;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.ToolButton;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.CommandButton;
import CH.ifa.draw.util.CommandMenu;
import CH.ifa.draw.util.Filler;
import CH.ifa.draw.util.Iconkit;
import CH.ifa.draw.util.PaletteButton;
import CH.ifa.draw.util.PaletteLayout;
import CH.ifa.draw.util.PaletteListener;
import CH.ifa.draw.util.StorableInput;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Frame;
import java.awt.Label;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.StringTokenizer;

public class DrawFrame
extends Frame
implements DrawingEditor,
PaletteListener {
    private transient Drawing fDrawing;
    private transient Tool fTool;
    private transient StandardDrawingView fView;
    private transient ToolButton fDefaultToolButton;
    private transient ToolButton fSelectedToolButton;
    private transient boolean fSimpleUpdate;
    private transient Button fUpdateButton;
    private transient Panel fPanel;
    private Iconkit fIconkit;
    static String fgUntitled = "untitled";
    private static final String fgDrawPath = "/CH/ifa/draw/";
    public static final String IMAGES = "/CH/ifa/draw/images/";
    private Application fApplication;

    public DrawFrame(String string, Application application) {
        super(string);
        this.fApplication = application;
        this.fIconkit = new Iconkit(this);
        this.setLayout(new BorderLayout());
        this.fView = this.createDrawingView();
        MenuBar menuBar = new MenuBar();
        this.populateMenuBar(menuBar);
        this.setMenuBar(menuBar);
        Panel panel = this.createSouthPanel();
        if (panel != null) {
            this.populateSouthPanel(panel);
            this.add("South", panel);
        }
        if ((panel = this.createWestPanel()) != null) {
            this.populateWestPanel(panel);
            this.add("West", panel);
        }
        if ((panel = this.createEastPanel()) != null) {
            this.populateEastPanel(panel);
            this.add("East", panel);
        }
        if ((panel = this.createNorthPanel()) != null) {
            this.populateNorthPanel(panel);
            this.add("North", panel);
        }
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.fView);
        this.add("Center", scrollPane);
        this.initDrawing();
        this.setBufferedDisplayUpdate();
    }

    public Application getApplication() {
        return this.fApplication;
    }

    public void showStatus(String string) {
        this.fApplication.showStatus(string);
    }

    protected void populateMenuBar(MenuBar menuBar) {
    }

    protected Panel createSouthPanel() {
        Panel panel = new Panel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2), false));
        return panel;
    }

    protected void populateSouthPanel(Panel panel) {
        panel.add(new Filler(24, 20));
        Choice choice = new Choice();
        choice.addItem(fgUntitled);
        String string = this.fApplication.getParameter("DRAWINGS");
        if (string == null) {
            string = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            choice.addItem(stringTokenizer.nextToken());
        }
        if (choice.getItemCount() > 1) {
            panel.add(choice);
        } else {
            panel.add(new Label(fgUntitled));
        }
        choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    DrawFrame.this.loadDrawing((String)itemEvent.getItem());
                }
            }
        });
        panel.add(new Filler(6, 20));
        Button button = new CommandButton(new DeleteCommand("Delete", this.fView));
        panel.add(button);
        button = new CommandButton(new DuplicateCommand("Duplicate", this.fView));
        panel.add(button);
        button = new CommandButton(new GroupCommand("Group", this.fView));
        panel.add(button);
        button = new CommandButton(new UngroupCommand("Ungroup", this.fView));
        panel.add(button);
        button = new Button("Help");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DrawFrame.this.showHelp();
            }
        });
        panel.add(button);
        this.fUpdateButton = new Button("Simple Update");
        this.fUpdateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DrawFrame.this.fSimpleUpdate) {
                    DrawFrame.this.setBufferedDisplayUpdate();
                } else {
                    DrawFrame.this.setSimpleDisplayUpdate();
                }
            }
        });
        panel.add(this.fUpdateButton);
    }

    protected CommandMenu createColorMenu(String string) {
        CommandMenu commandMenu = new CommandMenu("Colour");
        ColorMap colorMap = ColorMap.getColorMap();
        for (int i = 0; i < colorMap.size(); ++i) {
            commandMenu.add(new ChangeAttributeCommand(colorMap.name(i), string, colorMap.color(i), this.fView));
        }
        return commandMenu;
    }

    protected CommandMenu createFontMenu() {
        CommandMenu commandMenu = new CommandMenu("Font");
        String[] stringArray = Toolkit.getDefaultToolkit().getFontList();
        for (int i = 0; i < stringArray.length; ++i) {
            commandMenu.add(new ChangeAttributeCommand(stringArray[i], "FontName", stringArray[i], this.fView));
        }
        return commandMenu;
    }

    protected Panel createEastPanel() {
        return null;
    }

    protected void populateEastPanel(Panel panel) {
    }

    protected Panel createNorthPanel() {
        return null;
    }

    protected void populateNorthPanel(Panel panel) {
    }

    protected Panel createWestPanel() {
        Panel panel = new Panel();
        panel.setLayout(new PaletteLayout(2, new Point(2, 2)));
        return panel;
    }

    protected void populateWestPanel(Panel panel) {
        Tool tool = this.createSelectionTool();
        this.fDefaultToolButton = this.createToolButton("/CH/ifa/draw/images/SEL", "Selection Tool", tool);
        panel.add(this.fDefaultToolButton);
    }

    protected Tool createSelectionTool() {
        return new SelectionTool(this.fView);
    }

    protected ToolButton createToolButton(String string, String string2, Tool tool) {
        return new ToolButton(this, string, string2, tool);
    }

    protected Drawing createDrawing() {
        return new StandardDrawing();
    }

    protected StandardDrawingView createDrawingView() {
        return new StandardDrawingView(this, 410, 370);
    }

    public void paletteUserSelected(PaletteButton paletteButton) {
        ToolButton toolButton = (ToolButton)paletteButton;
        this.setTool(toolButton.tool(), toolButton.name());
        this.setSelected(toolButton);
    }

    public void paletteUserOver(PaletteButton paletteButton, boolean bl) {
        if (bl) {
            this.showStatus(((ToolButton)paletteButton).name());
        } else {
            this.showStatus(this.fSelectedToolButton.name());
        }
    }

    public Drawing drawing() {
        return this.fDrawing;
    }

    public Tool tool() {
        return this.fTool;
    }

    public DrawingView view() {
        return this.fView;
    }

    public void toolDone() {
        this.setTool(this.fDefaultToolButton.tool(), this.fDefaultToolButton.name());
        this.setSelected(this.fDefaultToolButton);
    }

    public void selectionChanged(DrawingView drawingView) {
    }

    private void initDrawing() {
        this.fDrawing = this.createDrawing();
        this.fView.setDrawing(this.fDrawing);
        this.toolDone();
    }

    private void setTool(Tool tool, String string) {
        if (this.fTool != null) {
            this.fTool.deactivate();
        }
        this.fTool = tool;
        if (this.fTool != null) {
            this.showStatus(string);
            this.fTool.activate();
        }
    }

    private void setSelected(ToolButton toolButton) {
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.reset();
        }
        this.fSelectedToolButton = toolButton;
        if (this.fSelectedToolButton != null) {
            this.fSelectedToolButton.select();
        }
    }

    protected void loadDrawing(String string) {
        if (string == fgUntitled) {
            this.fDrawing.release();
            this.initDrawing();
            return;
        }
        String string2 = this.fApplication.getParameter(string);
        if (string2 != null) {
            this.readDrawing(string2);
        }
    }

    private void readDrawing(String string) {
        this.toolDone();
        String string2 = this.guessType(string);
        if (string2.equals("storable")) {
            this.readFromStorableInput(string);
        } else if (string2.equals("serialized")) {
            this.readFromObjectInput(string);
        } else {
            this.showStatus("Unknown file type");
        }
    }

    private void readFromStorableInput(String string) {
        try {
            InputStream inputStream = this.fApplication.getStream(string);
            StorableInput storableInput = new StorableInput(inputStream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)storableInput.readStorable();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException iOException) {
            this.initDrawing();
            this.showStatus("Error reading " + string + ": " + iOException);
            iOException.printStackTrace();
        }
    }

    private void readFromObjectInput(String string) {
        try {
            InputStream inputStream = this.fApplication.getStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            this.fDrawing.release();
            this.fDrawing = (Drawing)objectInputStream.readObject();
            this.fView.setDrawing(this.fDrawing);
        }
        catch (IOException iOException) {
            this.initDrawing();
            this.showStatus("Error reading (OI) " + string + ": " + iOException);
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.initDrawing();
            this.showStatus("Class not found: " + classNotFoundException);
        }
    }

    private String guessType(String string) {
        if (string.endsWith(".draw")) {
            return "storable";
        }
        if (string.endsWith(".ser")) {
            return "serialized";
        }
        return "unknown";
    }

    protected void setSimpleDisplayUpdate() {
        this.fView.setDisplayUpdate(new SimpleUpdateStrategy());
        this.fUpdateButton.setLabel("Simple Update");
        this.fSimpleUpdate = true;
    }

    protected void setBufferedDisplayUpdate() {
        this.fView.setDisplayUpdate(new BufferedUpdateStrategy());
        this.fUpdateButton.setLabel("Buffered Update");
        this.fSimpleUpdate = false;
    }

    protected void showHelp() {
        String string = this.getClass().getName().replace('.', '/');
        this.fApplication.popupFrame(string + "Help.html", "Help");
    }
}

