
/*
 A Moin page we are editing.
 */

package moineditorapplet;

import javax.swing.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import java.awt.event.*;
import java.lang.*;

public class MoinPageEditor implements ActionListener {
  JTextArea editArea; // Our text edit control

  public MoinPageEditor(JTextArea ctrl) {
    editArea = ctrl;
  }

  public void setPageContent(String content) {
    editArea.setText(content);
  }

  public void actionPerformed(ActionEvent e) {
    String cmd = e.getActionCommand();
    if (cmd.startsWith("style")) {
      applyStyle(cmd.substring(5));
    }
    else if (cmd.startsWith("section")) {
      applySection(cmd.substring(7));
    }
    else if (cmd.startsWith("list")) {
      applyList(cmd.substring(4));
    }
  }

  protected void applyStyle(String style) {
    if (style.equals("Italic")) {
      applyToSelection("''", "''");
    }
    else if (style.equals("Bold")) {
      applyToSelection("'''", "'''");
    }
  }

  protected void applySection(String nb) {
    String headingFmt[] = { "=", "==", "===", "====" };
    int heading = new Integer(nb).intValue() - 1;
    applyToCurrentLine(headingFmt[heading], headingFmt[heading]);
  }

  protected void applyList(String type) {
    // which type
    if (type.equals("Bullet")) type = " * ";
    else if (type.equals("Abc")) type = " a. ";
    else if (type.equals("Roman")) type = " i. ";

    // we'll apply the list markup at the start of the current line
    Caret crt = editArea.getCaret();
    int cursor = crt.getDot();
    try {
      // find the start the line where the cursor is
      int currln = editArea.getLineOfOffset(cursor);
      int begin = editArea.getLineStartOffset(currln);
      // add our text in the correct place
      editArea.insert(type, begin);
    } catch (Exception e) {
      System.err.println("Oops");
    }
  }

  protected void applyToCurrentLine(String before, String after) {
    // find out where we are
    Caret crt = editArea.getCaret();
    int cursor = crt.getDot();
    try {
      // find the start and finish of the line where the cursor is
      int currln = editArea.getLineOfOffset(cursor);
      int begin = editArea.getLineStartOffset(currln);
      int end = editArea.getLineEndOffset(currln);
      // add our text in the correct places
      editArea.insert(after, end-1);
      editArea.insert(before, begin);
    } catch (Exception e) {
      System.err.println("Oops");
    }
  }

  protected void applyToSelection(String before, String after) {
    // get cursor position
    Caret crt = editArea.getCaret();
    int begin = crt.getDot();
    int end = crt.getMark();

    // insert text depending on whether text is selected or not
    if (begin == end) {
      editArea.insert(before + "_" + after, begin);
    }
    else {
      // insert our text before and after the current selection.
      // we must make sure begin is before end or nothing happens.
      editArea.replaceRange(before + editArea.getSelectedText() + after,
                            begin<end ? begin : end, begin<end ? end : begin);
    }
  }
}


