# -*- coding: utf-8 -*-

# CallPage macro for MoinMoin 1.9
#
# Usage: [[CallPage(MyPage value1,value2,var1=value,var2=value,value3)]]
# Then in place of this macro you get content of MyPage with substituted parameters.
# Parameters must be in form ${varname}. Unnamed parameters appears like ${arg0..N}
# You may use predefined parameters:
#   ${CALLER} - name of page from which macro called
#   ${COUNT} - number of arguments in macro call
#   ${PAGE} - name of the page with macro template
#   ${TODAY} - current date and time   
#
# Original author: Axel <axel@linuxrulez.ru>
# Fix for MoinMoin 1.9: Ueli <usc@ieee.org>
# Licence: GPL v2

from string import Template
from MoinMoin.Page import Page, wikiutil
from time import time as now

Dependencies = ["time"]

def getArgs(string, separator):
    """
    @param string: string with args 'arg1,arg2,var1=value,var2=value'
    @rtype: dict
    @return: dictionary with macro options
    """
    if not string:
        return {}
    pairs = string.split(' ', 1)
    args = {'PAGE': 'Card' + pairs[0].strip()}

    if len(pairs) == 1:
        return args
    pairs = [s.strip() for s in pairs[1].split(separator)]

    for idx, pair in enumerate(pairs):
        splitted = pair.split('=', 1)
        if len(splitted) > 1:
            args.update({splitted[0]: splitted[1]})
        else:
            args.update({'ARG%d' % idx: splitted[0]})
    args.update({'COUNT': len(args)})
    return args


def execute(macro, args):

    _ = macro.request.getText

    if hasattr(macro.cfg, 'cardmacro_separator'):
        separator = macro.cfg.cardmacro_separator
    else:
        separator = ','

    params = getArgs(args, separator)
    pagename = params['PAGE']

    if macro.request.user.may.read(pagename):
        page = Page(macro.request, pagename)
        raw = Template(page.get_raw_body())
        # evaluate predefined parameters
        params['CALLER'] = macro.request.path.encode('utf-8')[1:]
                                # Used to be macro.request.getPathinfo()[1:] -
                                # see
                                # http://moinmo.in/MoinMoinBugs/OpenIDServerPreferencesActionUsesObsoleteRequestAPI
                                # and 
                                # http://hg.moinmo.in/moin/1.9/rev/f8e67522e80e
                                # for an example where a similar call haded to
                                # be fixed in the MoinMoin code base
        params['TODAY'] = macro.request.user.getFormattedDate(now())
        text = raw.safe_substitute(params)
    else:
        text = _("Page %s not exists.") % pagename
    
    page.set_raw_body(text, 1)
    return macro.request.redirectedOutput(page.send_page, content_only=1, count_hit=0, content_id="CalledPage_%s" % pagename)
