from MoinMoin import wikiacl

class AccessControlList(wikiacl.AccessControlList):

    special_users = ["All", "Known", "Trusted", 
                     "Member", "Owner"] # order is important
    
    def __init__(self, request, line, dialog):
        self.clean()
        self.addLine(request.cfg, line)
        self.dialog = dialog

    
    def _special_Owner(self, request, name, dowhat, rightsdict):
        if self.dialog.is_Owner(name):
            return rightsdict[dowhat]
        else:
            return None
    
    def _special_Member(self, request, name, dowhat, rightsdict):
        if self.dialog.is_Member(name):
            return rightsdict[dowhat]
        else:
            return None
        
