# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - Pagesize Statistics

    This macro creates a bar graph of page size classes.

    @copyright: 2002-2004 Juergen Hermann <jh@web.de>
    @license: GNU GPL, see COPYING for details.
"""

_debug = 0

from MoinMoin import wikiutil
from MoinMoin.Page import Page


def linkto(pagename, request, params=''):
    _ = request.getText

    if not request.cfg.chart_options:
        return (request.formatter.sysmsg(1) +
                request.formatter.text(_('Charts are not available!')) +
                request.formatter.sysmsg(0))

    if _debug:
        return draw(pagename, request)

    page = Page(request, pagename)

    # Create escaped query string from dict and params
    querystr = {'action': 'chart', 'type': 'pagesize'}
    querystr = wikiutil.makeQueryString(querystr)
    querystr = wikiutil.escape(querystr)
    if params:
        querystr += '&amp;' + params

    data = {'url': page.url(request, querystr)}
    data.update(request.cfg.chart_options)
    result = ('<img src="%(url)s" width="%(width)d" height="%(height)d"'
              ' alt="pagesize chart">') % data
    return result


def _slice(data, lo, hi):
    data = data[:]
    if lo: data[:lo] = [None] * lo
    if hi < len(data):
        data[hi:] = [None] * (len(data)-hi)
    return data


def draw(pagename, request):
    import bisect, shutil, cStringIO
    import gdchart
    from MoinMoin.util.web import Color

    _ = request.getText

    # get data
    pages = request.rootpage.getPageDict()
    sizes = []
    for name, page in pages.items():
        sizes.append((page.size(), name.encode('iso-8859-1', 'replace')) ) # gdchart does no utf-8
    sizes.sort()

    upper_bound = sizes[-1][0]
    bounds = [s*128 for s in range(1, 9)]
    if upper_bound >= 1024:
        bounds.extend([s*1024 for s in range(2, 9)])
    if upper_bound >= 8192:
        bounds.extend([s*8192 for s in range(2, 9)])
    if upper_bound >= 65536:
        bounds.extend([s*65536 for s in range(2, 9)])

    data = [0] * len(bounds)
    for size, name in sizes:
        idx = bisect.bisect(bounds, size)
        ##idx = int((size / upper_bound) * classes)
        data[idx] = data[idx] + 1

    labels = ["%d" % b for b in bounds]

    # give us a chance to develop this
    if _debug:
        return "<p>data = %s</p>" % \
            '<br>'.join([wikiutil.escape(repr(x)) for x in [labels, data]])

    # create image
    image = cStringIO.StringIO()
    c = gdchart.Bar3D()
    c.bg_color= 0xffffff
    c.line_color = 0x000000

    c.setData(data)
    c.ext_color= []
    for x in ['blue', 'green', 'red', 'magenta']:
        c.ext_color = c.ext_color + [ Color(x) ] * 8
    title = ''
    if request.cfg.sitename: title = "%s: " % request.cfg.sitename
    c.title = title.encode('iso-8859-1','replace') + _('Page Size Distribution').encode('iso-8859-1', 'replace')
    c.width=request.cfg.chart_options['width']
    c.height=request.cfg.chart_options['height']
    c.xtitle=_('page size upper bound [bytes]').encode('iso-8859-1', 'replace')
    c.ytitle=_('# of pages of this size').encode('iso-8859-1', 'replace')
    #c.annotate(point=bisect.bisect(bounds, upper_bound), color='black', note="%d %s" % sizes[-1])
    c.title_font_size="GIANT"
    c.stack_type="LAYER"
    c.threeD_depth=2.0
    c.requested_yinterval=1.0
    c.setLabels(labels)

    import tempfile
    f = tempfile.NamedTemporaryFile(suffix=".gif")
    c.draw(f.file)
    f.file.seek(0)
    image.write(f.file.read())
    f.close()


    headers = [
        "Content-Type: image/gif",
        "Content-Length: %d" % len(image.getvalue()),
    ]
    request.emit_http_headers(headers)

    # copy the image
    image.reset()
    shutil.copyfileobj(image, request, 8192)

