Imports System.IO
Imports System.Environment
Imports System.Text.RegularExpressions

'
' Copyright (c) 2007-2008, Alexander "Loki" Agibalov
'

Public Class Form1
    Private newDoc As Microsoft.Office.Interop.Word.Document
    Private newDocWin As Microsoft.Office.Interop.Word.Window
    Private docPath As String
    Dim IsTOC As Boolean
    Dim bracketingTypeOpen, bracketingTypeClose As String
    Dim tabPages(1000) As System.Windows.Forms.TabPage
    Dim txtBoxes(1000) As System.Windows.Forms.TextBox

    Private Sub Button_start_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_start.Click
        Dim filename As String
        Dim filenames As String()

        Dim result As DialogResult = OpenFileDialog1.ShowDialog()
        If (result = Windows.Forms.DialogResult.OK) Then
            filenames = OpenFileDialog1.FileNames
        Else
            Exit Sub
        End If

        For Each filename In filenames
            Transform(filename, AddTabPage(filename))
        Next
    End Sub

    Private Function AddTabPage(ByVal sFilename As String) As Integer
        Dim newTabNumber As Integer
        newTabNumber = Me.TabControl1.TabCount

        sFilename = sFilename.Substring(sFilename.LastIndexOf("\") + 1)

        tabPages(newTabNumber) = New System.Windows.Forms.TabPage
        txtBoxes(newTabNumber) = New System.Windows.Forms.TextBox

        TabControl1.SuspendLayout()
        tabPages(newTabNumber).SuspendLayout()
        SuspendLayout()

        With (txtBoxes(newTabNumber))
            .Anchor = CType((((System.Windows.Forms.AnchorStyles.Top Or System.Windows.Forms.AnchorStyles.Bottom) _
                        Or System.Windows.Forms.AnchorStyles.Left) _
                        Or System.Windows.Forms.AnchorStyles.Right), System.Windows.Forms.AnchorStyles)
            .Enabled = False
            .Location = New System.Drawing.Point(6, 7)
            .Multiline = True
            .Name = sFilename
            .ScrollBars = System.Windows.Forms.ScrollBars.Both
            .Size = New System.Drawing.Size(671, 284)
            .TabIndex = 1
        End With

        With (tabPages(newTabNumber))
            .BackColor = System.Drawing.Color.Transparent
            .Controls.Add(txtBoxes(newTabNumber))
            .Location = New System.Drawing.Point(4, 22)
            .Name = sFilename
            .Text = sFilename
            .Padding = New System.Windows.Forms.Padding(3)
            .Size = New System.Drawing.Size(683, 298)
            .TabIndex = 0
            .UseVisualStyleBackColor = True
        End With

        TabControl1.Controls.Add(tabPages(newTabNumber))

        TabControl1.ResumeLayout(False)
        tabPages(newTabNumber).ResumeLayout(False)
        tabPages(newTabNumber).PerformLayout()
        ResumeLayout(False)
        PerformLayout()

        TabControl1.SelectedIndex = newTabNumber

        Application.DoEvents()

        AddTabPage = newTabNumber
    End Function

    Private Sub Transform(ByRef sFilename As String, ByVal tabNumber As Integer)
        Dim sPrefix As String
        Dim Doc As Microsoft.Office.Interop.Word.Document
        Dim wrd As Microsoft.Office.Interop.Word.Application

        sPrefix = DeterminePrefix(sFilename)

        SetStatus("Starting MS Word")
        Try
            wrd = CreateObject("Word.Application")
        Catch exWrd As Exception
            Console.WriteLine("couldn't initialize word activex")
            Console.WriteLine(exWrd.Message)
            MsgBox("Failed to start MS Word")
            Exit Sub
        End Try

        ProgressBar1.Minimum = 0
        ProgressBar1.Maximum = 28
        ProgressBar1.Value = 0

        If RadioButton1.Checked Then
            bracketingTypeOpen = "[["
            bracketingTypeClose = "]]"
        Else
            bracketingTypeOpen = "<<"
            bracketingTypeClose = ">>"
        End If

        SetStatus("Opening file")
        wrd.Documents.Open(sFilename)
        ProgressBar1.Value += 1

        Doc = wrd.ActiveDocument
        newDocWin = Doc.ActiveWindow
        ProgressBar1.Value += 1

        SetStatus("Copying document to clipboard")
        newDocWin.Selection.WholeStory()
        newDocWin.Selection.Copy()
        docPath = Doc.Path & "\"
        ProgressBar1.Value += 1

        SetStatus("Closing document")
        Doc.Close(Microsoft.Office.Interop.Word.WdSaveOptions.wdDoNotSaveChanges)
        ProgressBar1.Value += 1

        SetStatus("Creating new document")
        wrd.Documents.Add()
        ProgressBar1.Value += 1

        newDoc = wrd.ActiveDocument
        newDoc.ShowSpellingErrors = False
        newDoc.ShowGrammaticalErrors = False
        newDoc.FormattingShowClear = False
        newDoc.FormattingShowFilter = False
        newDoc.FormattingShowFont = False
        newDoc.FormattingShowNumbering = False
        newDoc.FormattingShowParagraph = False
        newDoc.ShowRevisions = False
        newDoc.ShowSummary = False
        ProgressBar1.Value += 1

        SetStatus("Pasting in old document")
        newDocWin = newDoc.ActiveWindow
        newDocWin.Selection.Paste()
        ProgressBar1.Value += 1

        SetStatus("Processing links")
        MakeWikiLists()
        ProgressBar1.Value += 1

        SetStatus("Making table of contents")
        MakeWikiTOC()
        ProgressBar1.Value += 1

        SetStatus("Parsing headers")
        ConvertHeading(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleHeading1, "= ", " =")
        ConvertHeading(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleHeading2, "== ", " ==")
        ConvertHeading(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleHeading3, "=== ", " ===")
        ConvertHeading(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleHeading4, "==== ", " ====")
        ConvertHeading(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleHeading5, "===== ", " =====")
        ProgressBar1.Value += 1

        SetStatus("Converting images")
        MakeWikiConvertShapes()
        ProgressBar1.Value += 1

        SetStatus("Saving image files to disk")
        SaveImages(sPrefix)
        ProgressBar1.Value += 1

        SetStatus("Replacing images with links")
        MakeWikiDelImages(sPrefix)
        ProgressBar1.Value += 1

        SetStatus("Removing empty headers")
        newDoc.Select()
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiDelEmptyHeaders()
        ProgressBar1.Value += 1

        SetStatus("Replacing bold and italic text")
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiItalicBold()
        ProgressBar1.Value += 1
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiItalic()
        ProgressBar1.Value += 1
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiBold()
        ProgressBar1.Value += 1
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)

        SetStatus("Formatting cells")
        MakeCellFormatting()
        ProgressBar1.Value += 1

        SetStatus("Removing page breaks")
        MakeWikiDelPagebreaks()
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        newDocWin.Selection.WholeStory()
        ProgressBar1.Value += 1

        SetStatus("Parsing links")
        MakeWikiBookmarks()
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        newDocWin.Selection.WholeStory()
        ProgressBar1.Value += 1

        SetStatus("Converting tables")
        MakeWikiTableALL()
        ProgressBar1.Value += 1

        SetStatus("Removing empty headers")
        newDocWin.Selection.HomeKey(Unit:=Microsoft.Office.Interop.Word.WdUnits.wdStory)
        MakeWikiDelEmptyHeaders()
        ProgressBar1.Value += 1

        SetStatus("Expanding line breaks")
        ExpandLineBreaks()
        ProgressBar1.Value += 1

        SetStatus("Making real CRs")
        MakePsuedoCRsIntoRealCRs()
        ProgressBar1.Value += 1

        SetStatus("Copying new document to clipboard")
        newDocWin.Selection.WholeStory()
        newDocWin.Selection.Style = Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStylePlainText
        newDocWin.View.ShowAll = False
        newDocWin.Selection.Copy()
        ProgressBar1.Value += 1

        SetStatus("Closing document")
        newDoc.Close(Microsoft.Office.Interop.Word.WdSaveOptions.wdDoNotSaveChanges)
        ProgressBar1.Value += 1

        txtBoxes(tabNumber).Enabled = True
        txtBoxes(tabNumber).Text = Clipboard.GetData(System.Windows.Forms.DataFormats.Text)
        ProgressBar1.Value += 1

        SetStatus("Zipping images")
        ZipImages(sPrefix)
        ProgressBar1.Value += 1

        Button_copy.Enabled = True
    End Sub

    Private Function DeterminePrefix(ByRef sFilename As String) As String
        Dim sDequalifiedFilename As String
        Dim array(1) As Char
        array(0) = "."

        sDequalifiedFilename = sFilename
        sDequalifiedFilename = sDequalifiedFilename.Substring(sDequalifiedFilename.LastIndexOf("\") + 1)
        sDequalifiedFilename = sDequalifiedFilename.Split(array)(0)

        DeterminePrefix = sDequalifiedFilename.Replace(" ", "_")
    End Function

    Private Sub SetStatus(ByVal stat As String)
        Label_status.Text = stat
        Label_status.Refresh()
    End Sub

    Structure TOC_Entry
        Dim Number As String
        Dim Name As String
        Dim Found As Boolean
    End Structure
    Dim TOC_Entries() As TOC_Entry
    Private Sub MakeWikiTOC()
        With newDoc
            If .Fields.Count >= 1 Then
                Dim C As Integer
                Dim fieldsCount As Integer

                fieldsCount = .Fields.Count
                'Search Fields for a Table Of Contents
                For C = 1 To fieldsCount
                    'If we find a Table of Contents, process it
                    If InStr(LTrim(.Fields.Item(C).Code.Text), "TOC") = 1 Then
                        .Fields.Item(C).Update()

                        Dim TOC As String
                        Dim Entry As String
                        Dim LastPos As Integer
                        Dim Pos As Long
                        Dim FirstTime As Boolean

                        TOC = .Fields.Item(C).Result.Text

                        'Get each entry in the table, insert into array
                        LastPos = 1
                        Pos = InStr(TOC, vbCr)
                        FirstTime = True
                        Do While (Pos > 0)
                            Dim F1 As Integer
                            Dim F2 As Integer
                            Dim EntryNum As Long

                            Entry = Trim(Mid(TOC, LastPos, Pos - LastPos))
                            Entry = Replace(Entry, "^l", "")

                            If (Len(Entry) > 0) Then
                                If (FirstTime) Then
                                    EntryNum = 1
                                    ReDim TOC_Entries(1)
                                    FirstTime = False
                                Else
                                    EntryNum = UBound(TOC_Entries) + 1
                                    ReDim Preserve TOC_Entries(EntryNum)
                                End If

                                F1 = InStr(Entry, vbTab)

                                If (F1 > 0) Then
                                    F2 = InStr(F1 + 1, Entry, vbTab)
                                    If (F2 = 0) Then
                                        'Handle Appendix sections'
                                        F1 = InStr(Entry, "-")
                                        F2 = InStr(F1 + 1, Entry, vbTab)
                                        If (F2 = 0) Then
                                            F1 = InStr(Entry, "  ")
                                            F2 = InStr(F1 + 1, Entry, vbTab)
                                        End If

                                        If (F1 = 0) Then
                                            'Give up on finding a number
                                            F1 = InStr(1, Entry, vbTab)
                                            TOC_Entries(EntryNum).Number = ""
                                            TOC_Entries(EntryNum).Name = Microsoft.VisualBasic.Left(Entry, F1)
                                        Else
                                            TOC_Entries(EntryNum).Number = Replace(Mid(Entry, 1, F1 - 1), " ", "")
                                            TOC_Entries(EntryNum).Name = Mid(Entry, F1 + 1, F2 - F1 - 1)
                                        End If
                                    Else
                                        TOC_Entries(EntryNum).Number = Trim(Mid(Entry, 1, F1 - 1))
                                        TOC_Entries(EntryNum).Name = Mid(Entry, F1 + 1, F2 - F1 - 1)
                                    End If
                                End If

                                'Check for null entries
                                If (Len(TOC_Entries(EntryNum).Number) = 0 And _
                                   (Len(TOC_Entries(EntryNum).Name) = 0)) Then
                                    ReDim Preserve TOC_Entries(EntryNum - 1)
                                Else
                                    TOC_Entries(EntryNum).Found = False
                                End If

                            End If
                            LastPos = Pos + 1
                            Pos = InStr(LastPos, TOC, vbCr)
                        Loop

                        .Fields.Item(C).Select()

                        'Delete Word version, insert MoinMoin version
                        With newDocWin.Selection
                            .Delete()
                            .InsertAfter("'''Table Of Contents'''" & vbCr & vbCr)

                            For Pos = 1 To UBound(TOC_Entries)
                                'Create a table, with a slight indent for entries that are not top-level
                                .InsertAfter("||")
                                If (Len(TOC_Entries(Pos).Number) = 1) Then
                                    .InsertAfter("||<(>")
                                Else
                                    .InsertAfter(" ||")
                                End If
                                If bracketingTypeOpen = "[[" Then
                                    .InsertAfter("'''" & TOC_Entries(Pos).Number & "'''||" & _
                                        "[#s" & TOC_Entries(Pos).Number & " " & TOC_Entries(Pos).Name & "]||~?!CR!?~")
                                Else
                                    .InsertAfter("'''" & TOC_Entries(Pos).Number & "'''||" & _
                                        "[[#s" & TOC_Entries(Pos).Number & "|" & TOC_Entries(Pos).Name & "]]||~?!CR!?~")
                                End If
                            Next
                        End With

                        'Stop looking for Table Of Contents
                        IsTOC = True
                        Exit For
                    End If
                Next
            End If
        End With
    End Sub

    Private Sub MakeWikiConvertShapes()
        Dim sShp As Microsoft.Office.Interop.Word.Shape
        Dim iShp As Microsoft.Office.Interop.Word.InlineShape
        For Each sShp In newDoc.Shapes
            Try
                sShp.Select()
                iShp = sShp.ConvertToInlineShape
            Catch ex As Exception
                Console.WriteLine("couldn't convert inline image to shape")
                Console.WriteLine(ex.Message)
            End Try
        Next
    End Sub

    Private Sub SaveImages(ByRef sPrefix As String)
        Dim lPicNumber, cnt As Integer
        Dim totalimg = newDoc.InlineShapes.Count
        Dim s As Microsoft.Office.Interop.Word.InlineShape
        Dim tempDir As String = My.Computer.FileSystem.SpecialDirectories.Temp & "\word2wiki"
        If Directory.Exists(tempDir) Then
            Dim fls(), st As String
            fls = Directory.GetFiles(tempDir)
            For Each st In fls
                If File.Exists(st) Then File.Delete(st)
            Next
        Else : Directory.CreateDirectory(tempDir)
        End If
        lPicNumber = 1

        cnt = newDoc.InlineShapes.Count
        For Each s In newDoc.InlineShapes
            SetStatus("Saving image " & lPicNumber & " of " & cnt)
            Try
                '     s.Reset() ## causes aspect ratio issues!
            Catch ex As Exception
                Console.WriteLine("couldn't reset the image number " & lPicNumber)
                Console.WriteLine(ex.Message)
            End Try
            s.Select()
            newDocWin.Selection.Copy()
            PictureBox1.Image = Clipboard.GetData(System.Windows.Forms.DataFormats.Bitmap)
            PictureBox1.Height = s.Height
            PictureBox1.Width = s.Width
            PictureBox1.Image.Save(tempDir & "\" & sPrefix & "_fig" & Format$(lPicNumber, "0#") & ".png", System.Drawing.Imaging.ImageFormat.Png)
            lPicNumber = lPicNumber + 1
        Next
    End Sub

    Private Function canZip() As Boolean
        Dim osInfo As OperatingSystem
        osInfo = OSVersion
        Dim ret = False
        If osInfo.Platform = PlatformID.Win32NT Then
            If osInfo.Version.Major > 4 Then
                If osInfo.Version.Minor > 0 Then ret = True
            End If
        End If
        Return ret
    End Function

    Private Sub ZipImages(ByRef sPrefix As String)
        Dim tempDir As String = My.Computer.FileSystem.SpecialDirectories.Temp & "\word2wiki"

        If Not canZip() Then
            SetStatus("Images saved to " & tempDir)
            Exit Sub
        End If

        SetStatus("Zipping images")
        Dim emptyzip() As Byte = {80, 75, 5, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
        Dim zipFile As String = docPath & sPrefix & "_img.zip"
        Try
            If File.Exists(zipFile) Then File.Delete(zipFile)
            Dim fs As FileStream = New FileStream(zipFile, FileMode.CreateNew, FileAccess.Write, FileShare.None)
            fs.Write(emptyzip, 0, emptyzip.Length)
            fs.Close()
        Catch exf As Exception
            Console.WriteLine("couldn't create zip in a doc dir")
            Console.WriteLine(exf.Message)
            zipFile = tempDir & "\" & sPrefix & "_img.zip"
            If File.Exists(zipFile) Then File.Delete(zipFile)
            Dim fs As FileStream = New FileStream(zipFile, FileMode.CreateNew, FileAccess.Write, FileShare.None)
            fs.Write(emptyzip, 0, emptyzip.Length)
            fs.Close()
        End Try

        Dim objShell As Shell32.Shell
        Dim objFolder As Shell32.Folder

        objShell = New Shell32.Shell
        objFolder = objShell.NameSpace(zipFile)

        If (Not objFolder Is Nothing) Then
            Dim fls(), st As String
            fls = Directory.GetFiles(tempDir)
            For Each st In fls
                If InStr(st, sPrefix & "_img.zip") = 0 Then objFolder.CopyHere(st)
            Next
        End If

        objFolder = Nothing
        objShell = Nothing

        System.Threading.Thread.Sleep(1000)
        SetStatus("Images saved to " & zipFile)
    End Sub

    Private Sub MakeWikiDelImages(ByRef sPrefix As String)
        Dim im As Microsoft.Office.Interop.Word.InlineShape
        Dim ShapesCnt, cnt As Integer
        ShapesCnt = 1
        cnt = newDoc.InlineShapes.Count
        For Each im In newDoc.InlineShapes
            SetStatus("Replacing image " & ShapesCnt & " of " & cnt)
            im.Select()
            newDocWin.Selection.Text = "attachment:" & sPrefix & "_fig" & Format$(ShapesCnt, "0#") & ".png"
            ShapesCnt = ShapesCnt + 1
        Next im
    End Sub

    Private Sub MakeWikiDelEmptyHeaders()

        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^p=  =^p"
            .Replacement.Text = "^p ^p"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = False
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^p==  ==^p"
            .Replacement.Text = "^p ^p"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = False
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^p===  ===^p"
            .Replacement.Text = "^p ^p"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = False
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^p====  ====^p"
            .Replacement.Text = "^p ^p"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = False
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "^p=====  =====^p"
            .Replacement.Text = "^p ^p"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = False
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Sub MakeWikiItalic()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Font.Italic = True
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = ""
            .Replacement.Text = "^39^39^&^39^39"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = True
            .MatchCase = False
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Sub MakeWikiBold()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Font.Bold = True
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = ""
            .Replacement.Text = "^39^39^39^&^39^39^39"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = True
            .MatchCase = False
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Sub MakeWikiItalicBold()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Font.Italic = True
        newDocWin.Selection.Find.Font.Bold = True
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = ""
            .Replacement.Text = "^39^39^39^39^39^&^39^39^39^39^39"
            .Replacement.Font.Italic = False
            .Replacement.Font.Bold = False
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = True
            .MatchCase = False
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Sub MakeWikiDelPagebreaks()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "[^b^m]"
            .Replacement.Text = "----~?!CR!?~"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = True
            .MatchCase = True
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

    End Sub

    Private Sub MakeWikiBookmarks()
        '    Wiki    .
        '     ,        
        Dim allrng As Microsoft.Office.Interop.Word.Range
        Dim thisDoc As Microsoft.Office.Interop.Word.Document
        Dim skip, i, hyperLinksCount As Integer
        Dim linkName, linkText As String
        thisDoc = newDoc
        allrng = newDocWin.Selection.Range
        skip = 0
        hyperLinksCount = allrng.Hyperlinks.Count()

        For i = 1 To hyperLinksCount
            With allrng.Hyperlinks.Item(1 + skip)
                linkName = .Name
                linkText = .Range.Text
                If LCase(Microsoft.VisualBasic.Left(linkName, 4)) = "www." Or LCase(Microsoft.VisualBasic.Left(linkName, 7)) = "http://" Then
                    If LCase(Microsoft.VisualBasic.Left(linkName, 4)) = "www." Then linkName = "http://" & linkName
                    .Range.Text = "[[" & linkName & " " & linkText & "]]" & vbCr
                Else
                    If thisDoc.Bookmarks.Exists(linkName) Then
                        ' replace "_" symbols as they do not work in 1.7.2
                        '.Range.Text = "[[#" & linkName.Replace("_", "") & "|" & linkText & "]]"
                        .Range.Text = "[[#" & linkName.Replace("_", "") & " " & linkText & "]]"
                        thisDoc.Bookmarks.Item(linkName).Select()
                        ' replace "_" symbols as they do not work in 1.7.2
                        newDocWin.Selection.InsertBefore(bracketingTypeOpen + "Anchor(" & linkName.Replace("_", "") & ")" & bracketingTypeClose + vbCr)
                    Else
                        skip = skip + 1
                    End If
                End If
            End With
        Next i
    End Sub


    Private Sub MakeWikiTableALL()
        '
        '         ( )  Wiki
        '        |   ;
        '     
        '

        Dim rngTemp As Microsoft.Office.Interop.Word.Range
        Dim allrng As Microsoft.Office.Interop.Word.Range
        Dim tableTemp As Microsoft.Office.Interop.Word.Table
        Dim cellLoop As Microsoft.Office.Interop.Word.Cell
        Dim paraTmp As Microsoft.Office.Interop.Word.Paragraph
        Dim i As Integer
        Dim cnt, curCnt As Integer
        curCnt = 1
        allrng = newDocWin.Selection.Range
        cnt = allrng.Tables.Count + 1
        For Each tableTemp In allrng.Tables
            SetStatus("Generating table " & curCnt & " of " & cnt)
            curCnt += 1
            ' replace | symbols (if there are any) with !, otherwise the table will be broken
            tableTemp.Select()
            newDocWin.Selection.Find.ClearFormatting()
            newDocWin.Selection.Find.Replacement.ClearFormatting()
            With newDocWin.Selection.Find
                .Text = "|"
                .Replacement.Text = "!"
                .Forward = True
                .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindStop
                .Format = False
                .MatchCase = True
                .MatchWholeWord = False
                .MatchWildcards = False
                .MatchSoundsLike = False
                .MatchAllWordForms = False
            End With
            newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

            tableTemp.Range.ListFormat.RemoveNumbers()

            For Each cellLoop In tableTemp.Range.Cells

                i = 1
                Dim wordCount As Integer
                wordCount = cellLoop.Range.Words.Count

                If wordCount = 1 Then cellLoop.Range.InsertAfter(" ")

                SetStatus("Generating table " & curCnt & " of " & cnt & " " & AsteriskIfEven(wordCount))
                While i <= wordCount
                    With cellLoop.Range.Words.Item(i)

                        If .Text = vbCr Then
                            .Text = bracketingTypeOpen + "BR" + bracketingTypeClose
                        ElseIf .Text = "|" Then
                            .Text = ";"
                        End If

                        i = i + 1
                    End With
                End While

            Next cellLoop

            rngTemp = tableTemp.ConvertToText(Separator:="|")

            rngTemp.Find.Execute(FindText:="|", ReplaceWith:="||", Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
            'rngTemp.Find.Execute(FindText:="|<", ReplaceWith:="| <", Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)

            For Each paraTmp In rngTemp.Paragraphs
                With paraTmp.Range
                    .InsertBefore("||")
                    With .Words
                        SetStatus("Generating table " & curCnt & " of " & cnt & " " & AsteriskIfEven(.Count))
                        .Item(.Count).InsertBefore("||")
                    End With
                End With
            Next paraTmp
            'End If
        Next tableTemp
    End Sub

    Private Function AsteriskIfEven(ByVal eval As Integer) As String
        If eval Mod 2 = 0 Then AsteriskIfEven = "*" Else AsteriskIfEven = ""
    End Function


    Private Sub MakeWikiLists()
        Dim para As Microsoft.Office.Interop.Word.Paragraph
        Dim st As String
        Dim cnt, curCnt As Integer
        curCnt = 1
        cnt = newDoc.Paragraphs.Count
        For Each para In newDoc.Paragraphs
            SetStatus("Looking for lists in paragraph " & curCnt & " of " & cnt)
            curCnt += 1

            With para.Range.ListFormat

                If .ListType = Microsoft.Office.Interop.Word.WdListType.wdListBullet Or _
                    .ListType = Microsoft.Office.Interop.Word.WdListType.wdListPictureBullet _
                Then
                    st = Microsoft.VisualBasic.StrDup(.ListLevelNumber, " ")
                    st = st + "* "
                    para.Range.InsertBefore(st)
                ElseIf .ListType = Microsoft.Office.Interop.Word.WdListType.wdListListNumOnly Or _
                        .ListType = Microsoft.Office.Interop.Word.WdListType.wdListSimpleNumbering Or _
                        .ListType = Microsoft.Office.Interop.Word.WdListType.wdListMixedNumbering Or _
                        .ListType = Microsoft.Office.Interop.Word.WdListType.wdListOutlineNumbering _
                Then
                    st = Microsoft.VisualBasic.StrDup(.ListLevelNumber, " ")
                    st = st + "1. "
                    para.Range.InsertBefore(st)
                End If
                .RemoveNumbers()

            End With

        Next para
    End Sub

    Private Sub ConvertHeading(ByVal headingStyle As Long, Optional ByVal preString As String = "", Optional ByVal postString As String = "")
        Dim normalStyle As Microsoft.Office.Interop.Word.Style
        normalStyle = newDoc.Styles.Item(Microsoft.Office.Interop.Word.WdBuiltinStyle.wdStyleNormal)

        newDoc.Select()

        With newDocWin.Selection.Find

            .ClearFormatting()
            .Style = newDoc.Styles.Item(headingStyle)
            .Text = ""

            .Format = True
            .MatchCase = False
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False

            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue

            Do While .Execute
                With newDocWin.Selection
                    Dim Heading As String
                    Dim HeadingMinusNumber As String

                    Heading = .Text
                    .Style = normalStyle
                    .Collapse()
                    .MoveEndUntil(vbCr)
                    .Delete()

                    'Eliminate any manual form feeds
                    Heading = Replace(Heading, vbFormFeed, "")

                    'Replace any newlines with spaces
                    Heading = Replace(Heading, vbCr, "")

                    'Removed leading / training spaces
                    Heading = Trim(Heading)

                    Dim F1 = InStr(1, Heading, " ")
                    If F1 > 0 Then HeadingMinusNumber = Microsoft.VisualBasic.Mid(Heading, F1 + 1)

                    'Search the TOC entries for this section, insert bookmark etc.
                    If (IsTOC) Then
                        Dim E As Long
                        For E = 1 To UBound(TOC_Entries)
                            If (Not TOC_Entries(E).Found) Then
                                If (StrComp(Heading, TOC_Entries(E).Name) = 0) Then
                                    .InsertBefore(bracketingTypeOpen + "Anchor(s" & TOC_Entries(E).Number & ")" & bracketingTypeClose + vbCr)
                                    Heading = TOC_Entries(E).Number & " " & Heading
                                    TOC_Entries(E).Found = True
                                    Exit For
                                ElseIf (HeadingMinusNumber <> Nothing And StrComp(HeadingMinusNumber, TOC_Entries(E).Name) = 0) Then
                                    .InsertBefore(bracketingTypeOpen + "Anchor(s" & TOC_Entries(E).Number & ")" & bracketingTypeClose + vbCr)
                                    Heading = TOC_Entries(E).Number & " " & HeadingMinusNumber
                                    TOC_Entries(E).Found = True
                                    Exit For
                                End If
                            End If
                        Next E
                    End If

                    'Print the Heading
                    .InsertAfter(vbCr & preString & Heading & postString)
                End With
            Loop
        End With
    End Sub ' ConvertHeading

    Private Sub MakePsuedoCRsIntoRealCRs()
        newDocWin.Selection.Find.ClearFormatting()
        newDocWin.Selection.Find.Replacement.ClearFormatting()
        With newDocWin.Selection.Find
            .Text = "~?!CR!?~"
            .Replacement.Text = "^10"
            .Forward = True
            .Wrap = Microsoft.Office.Interop.Word.WdFindWrap.wdFindContinue
            .Format = True
            .MatchCase = False
            .MatchWholeWord = False
            .MatchWildcards = False
            .MatchSoundsLike = False
            .MatchAllWordForms = False
        End With
        newDocWin.Selection.Find.Execute(Replace:=Microsoft.Office.Interop.Word.WdReplace.wdReplaceAll)
    End Sub

    Private Function ColorToWiki(ByVal Color As Long) As String
        Dim raw As String
        raw = Hex(Color)

        If (raw = "FF000000") Then
            'Plain White
            ColorToWiki = "FFFFFF"
            Exit Function
        End If

        'Trim down long ones
        If (Len(raw) > 6) Then raw = Microsoft.VisualBasic.Right(raw, 6)

        'Lengthen short ones
        Do While (Len(raw) < 6)
            raw = "0" & raw
        Loop

        'Swap Order
        Dim C2W As String
        C2W = Mid(raw, 5, 2) & Mid(raw, 3, 2) & Mid(raw, 1, 2)

        ColorToWiki = C2W
    End Function ' ColorToWiki

    Structure TableCellFormat
        Dim Color As String         'Cell's background color
        Dim HorizAlign As String    'L, C, R
        Dim VertAlign As String     'T, C, B
    End Structure
    Private Sub MakeCellFormatting()
        Dim thisTable As Microsoft.Office.Interop.Word.Table
        Dim curCnt, totalCnt As Integer
        Dim curcntCell, totalCntCell As Integer
        curCnt = 1
        totalCnt = newDoc.Tables.Count + 1

        For Each thisTable In newDoc.Tables
            SetStatus("Formatting cells in table " & curCnt & " of " & totalCnt)
            curCnt += 1

            'Determine how many rows and columns there are
            Dim tableMaxRow, tableMaxCol As Long
            thisTable.Select()
            tableMaxRow = newDocWin.Selection.Information(Microsoft.Office.Interop.Word.WdInformation.wdMaximumNumberOfRows)
            tableMaxCol = newDocWin.Selection.Information(Microsoft.Office.Interop.Word.WdInformation.wdMaximumNumberOfColumns)

            'Create format arrays for mapping
            Dim tableFormats(tableMaxRow, tableMaxCol) As TableCellFormat
            Dim R, C As Long
            For R = 1 To tableMaxRow
                For C = 1 To tableMaxCol
                    With tableFormats(R, C)
                        'tableFormats(R, C).FirstCell = False
                        'tableFormats(R, C).LastCell = False
                        .Color = "FFFFFF"
                        .HorizAlign = "C"
                        .VertAlign = "C"
                    End With
                Next C
            Next R

            ''Check format of each cell
            thisTable.Select()
            totalCntCell = thisTable.Range.Cells.Count
            curcntCell = 1

            Dim thisCell As Microsoft.Office.Interop.Word.Cell
            For Each thisCell In thisTable.Range.Cells
                SetStatus("Formatting cells in table " & curCnt & " of " & totalCnt & " ( " & curcntCell & " / " & totalCntCell & " )")
                curcntCell += 1

                With thisCell
                    C = .ColumnIndex
                    R = .RowIndex
                    'If (C = 1) Then tableFormats(R, C).FirstCell = True
                    With .Range
                        If .Shading.BackgroundPatternColor <> Microsoft.Office.Interop.Word.WdColor.wdColorAutomatic Then tableFormats(R, C).Color = ColorToWiki(.Shading.BackgroundPatternColor)
                        If .Paragraphs.Item(1).Alignment = Microsoft.Office.Interop.Word.WdParagraphAlignment.wdAlignParagraphLeft Then tableFormats(R, C).HorizAlign = "L"
                        If .Paragraphs.Item(1).Alignment = Microsoft.Office.Interop.Word.WdParagraphAlignment.wdAlignParagraphRight Then tableFormats(R, C).HorizAlign = "R"
                    End With

                    If .VerticalAlignment = Microsoft.Office.Interop.Word.WdCellVerticalAlignment.wdCellAlignVerticalTop Then tableFormats(R, C).VertAlign = "T"
                    If .VerticalAlignment = Microsoft.Office.Interop.Word.WdCellVerticalAlignment.wdCellAlignVerticalBottom Then tableFormats(R, C).VertAlign = "B"
                End With
            Next thisCell

            'You may be asking why this is a seperate step.  It's a good question.
            'It's mostly because determining the RowSpan and ColSpan might require a seperate step
            For Each thisCell In thisTable.Range.Cells
                If (Len(thisCell.Range.Text) > 2) Then
                    With thisCell.Range
                        'Convert cell contents
                        Dim rawText As String
                        Dim endText As String
                        'Toss out the carriage return
                        rawText = Microsoft.VisualBasic.Left(.Text, Len(.Text) - 2)
                        endText = Microsoft.VisualBasic.Right(.Text, 1)
                        Dim newText As String
                        newText = ""
                        newText = Replace(rawText, vbCr, bracketingTypeOpen + "BR" + bracketingTypeClose)
                        newText = newText & endText

                        C = thisCell.ColumnIndex
                        R = thisCell.RowIndex
                        Dim format As String
                        Dim formatStarted As Boolean
                        format = ""
                        formatStarted = False

                        With tableFormats(R, C)

                            'If tableFormats(R, C).ColSpan = 1 Then
                            If .HorizAlign <> "L" Then
                                If (Not formatStarted) Then
                                    formatStarted = True
                                    format = format & "<"
                                End If
                                If .HorizAlign = "C" Then
                                    format = format & ":"
                                Else
                                    format = format & ")"
                                End If
                            End If
                            'End If

                            If .VertAlign <> "C" Then
                                If (Not formatStarted) Then
                                    formatStarted = True
                                    format = format & "<"
                                End If
                                If .VertAlign = "T" Then
                                    format = format & "^"
                                Else
                                    format = format & "v"
                                End If
                            End If

                            'Color must be last
                            If .Color <> "FFFFFF" Then
                                If (Not formatStarted) Then
                                    formatStarted = True
                                    format = format & "<"
                                End If
                                format = format & "#" & .Color
                            End If
                        End With

                        If (formatStarted) Then format = format & ">"

                        .Text = format & newText

                    End With
                End If
            Next thisCell
        Next thisTable
    End Sub

    ' /////////////////////////////////////////////////////////////////////////////
    'yoda2
    Private Sub ExpandLineBreaks()
        Dim nextPara As Microsoft.Office.Interop.Word.Paragraph
        Dim iLoopPara As Integer
        Dim paraCount As Integer

        paraCount = newDoc.Paragraphs.Count

        For iLoopPara = paraCount To 1 Step -1
            SetStatus("Expanding line breaks in paragraph " & ((paraCount - iLoopPara) + 1) & " of " & paraCount)

            nextPara = newDoc.Paragraphs.Item(iLoopPara)

            With nextPara.Range

                If (Microsoft.VisualBasic.Left(.Text, 7)) = "[list/]" Then
                    If (Microsoft.VisualBasic.Left(.Text, 15)) = "[list/][first/]" Then
                        .Text = bracketingTypeOpen + "BR" + bracketingTypeClose & vbCr & Microsoft.VisualBasic.Right(.Text, Len(.Text) - 15)
                    Else
                        .Text = Microsoft.VisualBasic.Right(.Text, Len(.Text) - 7)
                    End If
                Else
                    If _
                       Not (Len(.Text) = 1) And _
                       (InStr(.Text, "||") = 0) And _
                       (Not (Microsoft.VisualBasic.Left(.Text, 1)) = "=") And _
                       (Not (Microsoft.VisualBasic.Left(.Text, 2)) = "[[") And _
                       (Not (Microsoft.VisualBasic.Left(.Text, 63)) = "## ############################################################") And _
                       (Not (Microsoft.VisualBasic.Left(.Text, 4)) = "----") And _
                       True Then
                        Call .InsertAfter(vbCr)
                    End If
                End If
                'Next nextPara

            End With

        Next iLoopPara
    End Sub

    Private Sub Button_copy_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_copy.Click
        Clipboard.SetText(txtBoxes(TabControl1.SelectedIndex).Text)
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button_about.Click
        'change version number in: Word2Wiki\My Project\AssemblyInfo.vb
        Dim version As String = Application.ProductVersion
        Dim s_version() As String = version.Split(".")
        version = String.Format("{0}.{1}", s_version(0), s_version(1))
        MsgBox("Version: " & version)
    End Sub

End Class
