    
    # a starting point for defining custom panels for fixedleft, fixedleftcms, and fixedleftmanager
    # add this to the end of wikiconfig.py or farmconfig.py

    # these are defaults in fixed left theme, each item will generate a pre-defined panel
    fixedleftViewPanels = (
        #~ 'Icon Bar',  # if this is used, you probably want to remove Page Actions and More Actions
        'Search', 
        'Current Page', 
        'Navigation', 
        'Page Actions', 
        'More Actions', 
        'User', 
        'Page Trail', 
        'Page Contents',
        )
    fixedleftEditPanels = (
        'Current Page', 
        'Editor Controls', 
        'Editor Help', 
        'Editor Hints', 
        'Page Contents',
        )
        
    # There are 3 ways to define a panel:   1.  Use one of the predefined panels above

    # 2. Define a custom panel 
    myCustomPanel = ('Custom Help', # panel heading
        'HelpOnNavigation', # include a link to HelpOnNavigation page
        '[[HelpOnImages|Help On Images]]', # include a link to HelpOnImages page
        '^[[http://www.google.com|Google]]',) # leading ^ will open a new window to display google page
        
    # 3. Redefine a panel by changing the heading; this uses standard search panel contents, but heading changed to "Search My Wiki"
    myCustomSearchPanel = ('Search My Wiki','Search')


    # define a page viewing sidebar for fixedleftcms theme by listing the desired panels
    fixedleftCMSViewPanels = (
        myCustomPanel, 
        'User', # login is not really needed for CMS theme
        myCustomSearchPanel, 
        'Navigation', 
        'Page Contents')
    # editing is not expected in CMS theme, so there is no need for a fixedleftCMSEditPanels
    # if user does edit (by double-clicking?), the fixedleftEditPanels will be used by default



    # define a viewing sidebar for fixedleftmanager that has an icon bar plus the CMS panels
    # fixedleftManagerViewPanels = ('Icon Bar',) + fixedleftCMSViewPanels
    # OR use the default viewing panels for fixedleftmanager
    fixedleftManagerViewPanels = (
        'Icon Bar', 
        'Search', 
        'Current Page', 
        'Navigation', 
        # 'Page Actions', 
        # 'More Actions', 
        'User', 
        'Page Trail', 
        'Page Contents',
        )
    
    # if manager edits a page, the edit sidebar will use fixedleftEditPanels;  Or create a unique sidebar:
    # fixedleftManagerEditPanels = (????, ???)

    # possible choices for Icon Bar, use as many or as few as is desired
    # this overrides entry in /config/multiconfig.py
    page_iconbar = [
        # "diff",
        "edit", 
        "info", 
        # "subscribe",  # makes subscribe/unsubscribe
        "quicklink",  # makes quicklink/quickunlink
        "attachments", 
        "raw", 
        "refresh", 
        "spellcheck", 
        # "slideshow", 
        "createpdf", # see /ActionMarket/PdfAction or CreatePdfDocument
        # "xml",
        # "print",
        # "up",
        "pageactions", # enables access to all actions
        ## show/hide comments icon will be included per page contents
        ## discussion icon will be included per page contents
        ]
        
    # This is a way to mark some text for the gettext tools so that they don't
    # get orphaned. See http://www.python.org/doc/current/lib/node278.html.
    def _(text): 
        return text

    # list of icons that may appear in Icon Bar,  the icon-keys must be defined in the #icons" dict - see top of fixedleft.py
    # this overrides entry in MoinMoin/config/multiconfig.py - used only by Classic theme
    page_icons_table = {
        # key           pagekey, querystr dict, title, icon-key
        'diff': ('page', {'action': 'diff'}, _("Diffs"), "diff"),
        'info': ('page', {'action': 'info'}, _("Info"), "info"),
        'edit': ('page', {'action': 'edit'}, _("Edit"), "edit"),
        'unsubscribe': ('page', {'action': 'unsubscribe'}, _("UnSubscribe"), "unsubscribe"),
        'subscribe': ('page', {'action': 'subscribe'}, _("Subscribe"), "subscribe"),
        #~ 'quicklink': ('page', {'action': 'quicklink'}, _("Add Quick Link"), "quicklink"), # same as below, different icon
        'quicklink': ('page', {'action': 'quicklink'}, _("Add Quick Link"), "favorite"),
        #~ 'quickunlink': ('page', {'action': 'quickunlink'}, _("Remove Quick Link"), "quickunlink"), # same as below, different icon
        'quickunlink': ('page', {'action': 'quickunlink'}, _("Remove Quick Link"), "unfavorite"),
        'spellcheck': ('page', {'action': 'SpellCheck'}, _("Spell Check"), "spellcheck"),
        'slideshow': ('page', {'action': 'SlideShow'}, _("Slide Show"), "projection"),
        'createpdf': ('page', {'action': 'CreatePdfDocument'}, _("Create PDF"), "pdf"),
        'attachments': ('page', {'action': 'AttachFile'}, _("Manage Attachments"), "attach"),
        'raw': ('page', {'action': 'raw'}, _("Raw Text"), "raw"),
        'xml': ('page', {'action': 'show', 'mimetype': 'text/xml'}, _("XML"), "xml"),
        'print': ('page', {'action': 'print'}, _("Print"), "print"),
        #~ 'view': ('page', {}, _("View"), "view"), # refresh uses same icon and produces similar and more useful result
        'refresh': ('page', {'action': 'refresh'}, _("Refresh Cache"), "view"),
        'pageactions': ('page', {'action': 'PageActions'}, _("More Actions"), "more"),
        'up': ('page_parent_page', {}, _("Up"), "up"),
        'discussion': ('page', {}, _("Discussion"), "discussion"),
        'comment': ('page', {}, _("Show Comments"), "comment"),
        'commentoff': ('page', {}, _("Hide Comments"), "commentoff"),
        }
        
    del _
        