
// override function of same name in common.js
function show_switch2gui() {
    // Show switch to gui editor link if the browser is compatible
    if (can_use_gui_editor() === false) {return;}
    // instead of switch2gui, get xswitch2gui
    var switch2gui = document.getElementById('xswitch2gui');
    if (switch2gui) {
        switch2gui.style.display = 'block';
    }
}


// get corresponding element without leading x in its name and click it
function tickle(x){
    var yName;
    if (x.name) {
        yName = x.name.slice(1);
    } else {
        yName = x.parentNode.name.slice(1);
    }
    var y = document.getElementsByName(yName);
    y = y[0];
    y.click();
    return false;
}

// if no change comment was entered, remind user
function checkComment(x) {
    var editcomment = document.getElementById('editor-comment');
    if (editcomment.value === "") {
        editcomment.value = prompt("Enter optional comment for change log:","");
    }
    tickle(x);
}



function check_loaddraft() {
    var el = document.getElementsByName('button_load_draft');
    if (el[0]) {
        el = document.getElementsByName('xbutton_load_draft');
        if (el[0]) {
            el[0].parentNode.style.display = '';
        }
    }
}
// add load event to check for presence of Load Draft button; if so make it visible
addLoadEvent(check_loaddraft);

// toggle Comments button to show number of comments and show/hide status
// in 1.8 the position of the name tag moved to the LI element
function show_Hide_Comments(showHide) {
    var count = comments.length;
    for (i = 0; i < buttons.length; i++) {
        el = buttons[i];
        if (showHide == 'none') {
            if (el.tagName == 'LI') {
                // is moin 1.8
                el.firstChild.innerHTML = hideButtonLabel;
            } else {
                // is moin 1.7
                el.innerHTML = hideButtonLabel;
            }
        } else {
            if (el.tagName == 'LI') {
                // is moin 1.8
                el.firstChild.innerHTML = showButtonLabel;
            } else {
                // is moin 1.7
                el.innerHTML = showButtonLabel;
            }
        }
    }
}


// find all links pointing to this page and add classname 'thispage' -- executed during load after sidebar is defined
// css will make links to thispage bold
function linksToThisPage() {
    if (document.getElementsByTagName("a") !== null) {
        var thispage = document.location.href ? document.location.href : document.location;
        atags = document.getElementsByTagName("a");
        for (var i=0;  i<atags.length;  i++) {
            if(atags[i].href == thispage) {
                atags[i].className = "thispage " + atags[i].className;
            }
        }
    }
}

// IE6 does not understand css sibling selector, delete the chktrivialtop checkbox element and label
// other themes have an extra trivial change check box on top of edit textarea
function delChkTrivialTop() {
    if (document.getElementById("chktrivialtop")) {
        var n = document.getElementById("chktrivialtop");
        var p = n.parentNode;
        var nxt = n.nextSibling;
        p.removeChild(n);
        p.removeChild(nxt);
    }
}

// more actions will not fit in sidebar, alternative is to create a popup 
function showMoreActions() {
    var ul = document.getElementById("moreActions");
    ul.style.display = 'block';
    return false;
}
function hideMoreActions() {
    var ul = document.getElementById("moreActions");
    ul.style.display = 'none';
    return false;
}



// the 2 following functions were copied from Moin 1.8RC1  and modified to show numbers of comments

// for long documents with many comments this is expensive to calculate,
// thus we keep it here:
comments = null;
// also save the list of buttons and the formated show and hide button labels 
buttons = null;
showButtonLabel = null;
hideButtonLabel = null;

// this is executed when the user clicks the comments button
// modified 1.8 to change button label by calling show_Hide_comments
function toggleComments() {
    // Toggle visibility of every tag with class "comment"
    show_Hide_Comments(comments[0].style.display);
    for (i = 0; i < comments.length; i++){
        el = comments[i];
        if ( el.style.display != 'none' ) {
            el.style.display = 'none';
        } else {
            el.style.display = '';
        }
    }
}

// this is executed once on page load
// modified 1.8 to change comment button to "+2 Comments" or "-2 Comments"
function show_toggleComments() {
    // Show edit bar item for toggling inline comments only if inline comments exist on the page
    comments = getElementsByClassName('comment', null, document);
    if (comments.length > 0) {
        var count = comments.length;
        buttons = getElementsByClassName('toggleCommentsButton', null, document);
        for (i = 0; i < buttons.length; i++) {
            el = buttons[i];
            el.style.display = '';
            if (el.tagName == 'LI') {
                // is moin 1.8
                showButtonLabel = '+' + count + ' ' + el.firstChild.innerHTML;
                hideButtonLabel = '-' + count + ' ' + el.firstChild.innerHTML;
                // user preferences may set comments on or off; change button label to match
                if (comments[0].style.display == 'none') {
                    el.firstChild.innerHTML = showButtonLabel;
                } else {
                    el.firstChild.innerHTML = hideButtonLabel;
                }
            } else {
                // is moin 1.7
                showButtonLabel = '+' + count + ' ' + el.innerHTML;
                hideButtonLabel = '-' + count + ' ' + el.innerHTML;
                if (comments[0].style.display == 'none') {
                    el.innerHTML = showButtonLabel;
                } else {
                    el.innerHTML = hideButtonLabel;
                }
            }
        }
    }
}


// code for hiding sidebar start here

//  save javascript variables in cookie
function fixedleft_set_cookie (value){
    var cookie_string = "FixedLeftTheme=" + escape ( value );
    var d = new Date();
    var curr_year = d.getFullYear() + 5;
    var expires = new Date ( curr_year, 1, 1 );
    cookie_string += "; expires=" + expires.toGMTString() + "; path=/";
    document.cookie = cookie_string;
}
function fixedleft_delete_cookie (){
    var cookie_date = new Date ( );  // current date & time
    cookie_date.setTime ( cookie_date.getTime() - 1 );
    document.cookie = "FixedLeftTheme=; expires=" + cookie_date.toGMTString() + "; path=/";
}
function fixedleft_get_cookie (){
    var results = document.cookie.match ( '(^|;) ?' + 'FixedLeftTheme=([^;]*)(;|$)' );
    if ( results ) {
        return ( unescape ( results[2] ) );
    } else {
        return null;
    }
}

// function to hide sidebar, save left margin value in a cookie, and copy wiki navigation under menu icon
function hideSidebar() {
    // hide the entire sidebar
    var o = document.getElementById('sidebar');
    o.style.display = 'none';
    // change the margin for page content
    var w = document.getElementById('wikipagecontent');
        // can only use these if function is executed after load - saves css values
        //~ var oldMargin = w.style.marginLeft;
        //~ w.style.marginLeft = w.style.marginRight;
    // must do this way because function is executed during load - must agree with css values
    var oldMargin = '14em';
    w.style.marginLeft = '10px';
    // show the plus icon, show the menu icon
    o = document.getElementById('altWikiNavMenu');
    o.style.display = 'inline';
    // save an indication of current state in a cookie
    fixedleft_set_cookie(oldMargin);
    // move the sidebar navigation menu into the main right page
    var el = document.getElementById('wikiNavMenu');
    var wikiMenu = el.parentNode.removeChild(el);
    var nn = document.getElementById('contentWikiMenu');
    nn.parentNode.appendChild(wikiMenu);
    hideSearchForm();
}

// function to show sidebar
function showSidebar() {
    // in case user left searchform open
    hideSearchForm();
    // show sidebar
    var o = document.getElementById('sidebar');
    o.style.display = 'inline';
    // change margin of wiki page content
    var w = document.getElementById('wikipagecontent');
    var marg = fixedleft_get_cookie();
    w.style.marginLeft = marg;
    // hide the plus icon, hide the menu icon
    o = document.getElementById('altWikiNavMenu');
    o.style.display = 'none';
    // save state by removing cookie
    fixedleft_delete_cookie();
    // copy the sidebar navigation menu back to sidebar
    var el = document.getElementById('wikiNavMenu');
    var wikiMenu = el.parentNode.removeChild(el);
    var nn = document.getElementById('sidebarWikiMenu');
    nn.appendChild(wikiMenu);
    showSearchForm();
}

// function executed during page load -- if sidebar was hidden, hide it again
function repeatHide() {
    var c = fixedleft_get_cookie();
    if (c) {
        hideSidebar();
    }
}

// executed when user clicks on search
function showSearchForm() {
    var el = document.getElementById('sidebarSearch');
    el.style.display = 'block';
    el.parentNode.style.display = 'block';
}
// executed when user clicks on searchform X
function hideSearchForm() {
    var el = document.getElementById('sidebarSearch');
    if (el) {
        el.style.display = 'none';
        el.parentNode.style.display = '';
    }
}

// with more work, this function may make IE6 simulate li:hover
// css must have:  li:hover ul, li.over ul { display: block; }
//~ startList = function() {
    //~ if (document.all&&document.getElementById) {
        //~ navRoot = document.getElementById("nav");
        //~ for (i=0; i<navRoot.childNodes.length; i++) {
            //~ node = navRoot.childNodes;
            //~ if (node.nodeName=="LI") {
                //~ node.onmouseover=function() {
                    //~ this.className+=" over";
                //~ }
                //~ node.onmouseout=function() {
                    //~ this.className=this.className.replace(" over", "");
                //~ }
            //~ }
        //~ }
    //~ }
//~ }
//~ addLoadEvent(startList);

