# -*- coding: iso-8859-1 -*-
"""
    This is a theme suitable for a casual site visitor who knows nothing about wiki navigation.
    The usual wiki navigation links are suppressed, only a sidebar with a login link and 
    links to selected pages are shown.

    To use this theme, you must:
        Modify this progam to customize the sidebar links.
        Toggle the lines marked with @@@ to change from test to production.
        Make fixedleftcms the default theme for your wiki.  
        
    Users who are not logged in will receive pages formatted with this theme.
        
    Logged in users will received pages formatted with their selected theme.  If no 
    theme has been selected (or fixedleftcms is the user's selected theme), 
    wiki pages will be formatted with the fixedleft theme.
"""

from MoinMoin import wikiutil
import fixedleft

class Theme(fixedleft.Theme):
    """
        A CMS-like theme with a fixed left margin.
    """

    #~ name = "fixedleft"     # just a reminder that css will be loaded from htdocs/fixedleft/css
    
    def valid_user(self):
        """
        Return true if this is a valid logged in user.  If true is returned, the fixedleft
        theme will be used, not fixedleftcms!
        
        @@@ toggle the tests below for testing/production.
        """
        #~ isValid = 0                                                        # @@@ use this for testing
        isValid = self.request.user.valid and self.request.user.name # @@@ use this for production
        return isValid
    
    def html_head(self, d):
        """ 
        If user is not logged in, add a tiny bit of css to whatever fixedleft creates.
        
        Hides page info from casual visitors.
        """
        head = fixedleft.Theme.html_head(self, d)
        if not self.valid_user():  # user is not logged in, add a bit of optional CSS; more of a demo than useful
            head = u'\n'.join((head,
                    u"""<style type="text/css">
                    <!--
                    p#pageinfo {display: none;}
                    -->
                    </style>
                    """,
                    ))
        return head

    def header(self, d):
        """
        This assembles the sidebar menu.
        
        +++ Modify this method to introduce your wiki topic. +++
            
        @param d: parameter dictionary
        @rtype: string
        @return: page header html
        """
        if self.valid_user():
            return fixedleft.Theme.header(self, d)  # user is logged in, give him the fixedleft theme

        _ = self.request.getText
        html = [
            # Sidebar 
            u'<div id="sidebar">',
            u'<h1 id="wikinavigationheader">%s</h1>' % _(u'Wiki Navigation'), # hidden by common.css
            # you may find these 2 panels acceptable as is
            self.sitename_panel(d), # creates logo and wiki name at top of panel
            u'<ul id="wikiNavMenu">',
            self.userpanel(d), # creates login link
            #
            # add, change, or delete the panels below to organize your selected wiki pages into topics
            #
            self.first_panel(d),
            self.second_panel(d),
            #~ self.editpanel(d), # allows anonymous user to edit WikiSandBox, else returns null string
            u'</ul>', # end of wikiNavMenu
            u'</div>', # end of sidebar 
            # make all links to current page bold
            u'<script type="text/javascript" language="javascript">linksToThisPage()</script>',
            # wiki page content
            u'<div id="wikipagecontent">', # div end is created in footer
            u'<a name="MainWikiPageContent"></a>', # accessibility anchor for screen readers
            # on this theme there is nothing to separate header1 from header2
            self.emit_custom_html(self.cfg.page_header1),
            self.emit_custom_html(self.cfg.page_header2),
            self.msg(d),
            self.startPage(),
            ]
        return u'\n'.join(html)

    def first_panel(self, d):
        """ 
        Create first example panel.  Modify or delete this example.
        """
        _ = self.request.getText
        html = [
            u'<li class="sidepanel">%s' %  _("Tutorial"),
            u'<ul>',
            self.make_page_link('HelpOnEditing'),
            self.make_page_link('[[HelpOnLinking|Help on Linking]]'),
            self.make_page_link('[[HelpOnSmileys|Help on Smileys]]'),
            self.popup_link('[[http://www.google.com|Help from google]]'),
            u'</ul>',
            u'</li>'
            ]
        return u'\n'.join(html)
        
    def second_panel(self, d):
        """ 
        Create second example panel.  Modify or delete this example.
        
        Allow any user to edit sand box.
        """
        _ = self.request.getText
        # make edit link if this is sand box page and user is not logged in
        editLink = u''
        if _('WikiSandBox') == d['page'].page_name and not self.valid_user():
            editLink = u'<li>%s</li>' % self.editorLink(d['page'])
            
        html = [
            u'<li class="sidepanel">%s' %  _("Practice Editing"),
            u'<ul>',
            self.make_page_link('[[WikiSandBox|Play in Sand Box]]'),
            editLink,
            u'</ul>',
            u'</li>'
            ]
        return u'\n'.join(html)

    def sitename_panel(self,d):
        """
        Create logo and sitename header for left panel. 

        Changes from fixedleft:
            - eliminate page name backlink in UL corner to avoid confusing newbies.
        """
        request = self.request
        html = [
            u'<div class="sidepanel" id="sitenamelogo">',
            self.logo().replace("</a></div>", " %s</a></div>" % self.cfg.sitename),
            u'</div>'
            ]
        return u'\n'.join(html)

    def popup_link(self,url,windowName='example'):
        """
        Return a hyperlink that will open a popup window.  Precede link with new window icon.
        """
        pageName, linkName = self.splitNavilink(url)
        return '%s\n' % self.editpopup(linkName)

    def make_page_link(self,pageName):
        """
        Return a list item containing a link to a wiki page.
        """
        linkFormat = '<li>%s</li>'
        return linkFormat % self.splitNavilink(pageName)[1]
        

        