# -*- coding: iso-8859-1 -*-
"""
    
    copyright: 2003-2006 MoinMoin:ThomasWaldmann
    copyright: 2007-2008 by Roger Haase
    License: GNU GPL

"""

from MoinMoin import wikiutil
from MoinMoin.Page import Page
from MoinMoin.theme import ThemeBase
import re


class Theme(ThemeBase): 
    """ here are the functions generating the html responsible for
        the look and feel of your wiki site
    """

    name = "fixedleft"
    

    def html_head(self, d):
        """ Add favicon and javascript functions to whatever ThemeBase creates. """
        head = ThemeBase.html_head(self, d)
        head += u'\n<script type="text/javascript" src="%s/fixedleft/js/fixedleft.js"></script>' % self.cfg.url_prefix_static
        favicon = self.request.getPragma('favicon')
        if favicon:
            t = favicon.rindex(".")
            head += u'\n<link rel="icon" href="%s" type="%s">' % (favicon,"image/%s" % favicon[t + 1:])
        return head

    def editbuttons(self,d):
        """Place the input buttons for the text editor. These are outside the form element. 
        
        The tickle function will click the corresponding form element button.  
        Buttons can not tell the difference between a tickle and a click :-)."""
        _ = self.request.getText
        mouseOver = '''onmouseover="this.style.cursor='pointer'; hover(this,'xbutton buttonHover')" onmouseout="this.style.cursor='auto'; hover(this,'xbutton')"'''
        # put out GUI button if user preferences allow it
        if self.cfg.editor_default == 'text' and self.cfg.editor_force:
            guiButton = ''
        else:
            guiButton = '''<input id="xswitch2gui" class="xbutton" type="submit" name="xbutton_switch" value="GUI/Text Mode" onClick="tickle(this);" %s >''' % mouseOver
        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' % _("Editor Controls"),
            u'''<input class="xbutton" type="submit" name="xbutton_save" value="Save Changes" onClick="tickle(this);" %s >
<input class="xbutton" type="submit" name="xbutton_preview" value="Preview" onClick="tickle(this);" %s >
%s
<input class="xbutton" type="submit" name="xbutton_load_draft" value="Load Draft" onClick="tickle(this);" style="display: none;" %s >
<input class="xbutton" type="submit" name="xbutton_spellcheck" value="Check Spelling" onClick="tickle(this);" %s >
<input class="xbutton" type="submit" name="xbutton_cancel" value="Cancel" onClick="tickle(this);" %s >
''' % (mouseOver, mouseOver, guiButton, mouseOver, mouseOver, mouseOver),
            u'</div>',
            ]
        return u'\n'.join(html)
        
    def editpopup(self,anchor,windowName='popup'):
        """Return a hyperlink that will open a popup window.  precede link with popup icon.
        
        The anchor will look something like:
           <a href="/mywiki/HelpOnEditing">HelpOnEditing</a>
        Add an info icon and additional parameters  inside the "a" tag so a new window is opened.
        """
        newParms =  u''' onclick="window.open(this.href,'%s','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,copyhistory=no,resizable=yes,left=0,top=0').focus(); event.returnValue=false; return false;" 
            onkeypress="window.open(this.href,'%s','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,copyhistory=no,resizable=yes,left=0,top=0').focus(); event.returnValue=false; return false;" >
            <img src="%s/fixedleft/img/newwindow.png" 
            border="0" width="16" height="13" alt="New window" title="New window">''' % (windowName,windowName,self.cfg.url_prefix_static)
        return anchor.replace('>',newParms,1)
           
    def edithelp(self,d):
        """Add a panel for help links.   To avoid losing edits, open links in a new window."""
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' % _("Editor Help"),
            self.editpopup(_("HelpOnEditing", wiki=True),windowName='hoe'),'<br>',
            #~ self.editpopup(_("SyntaxReference", wiki=True),windowName='sr'),'<br>',
            self.editpopup(_("HelpOnMoinWikiSyntax", wiki=True),windowName='sr'),'<br>', # this name is 1 character too long
            u'</div>',
            ]
        return u'\n'.join(html)
        
    def hintline(self,s,divclass='hint'):
        """Return a formatted hint example."""
        return u'<div class="%s">%s</div>' % (divclass,s)

    def edit_hints(self,d):
        """Add a panel of syntax quick references for new users.
        
        We can not use the editor_quickhelp defined in wikiconfig.py or multiconfig.py without 
        effecting other themes, so define a new version here that will fit in a narrow column."""
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' % _("Editor Hints"),
            self.hintline(_("Emphasis"),divclass='hintheader'),
            self.hintline("''<span class='hintital'>%s</span>''" % _('italics')),
            self.hintline("'''<span class='hintbold'>%s</span>'''" % _('bold')),
            self.hintline("'''''<span class='hintboit'>%s</span>'''''" % _('bold italics')),
            self.hintline("`<tt class='backtick'>%s</tt>`" % _('monospace')),
            self.hintline("---- %s" % _('horizontal rule')),
            
            self.hintline(_("Headings"),divclass='hintheader'),
            self.hintline("= %s 1 =" % _("Title")),
            self.hintline("===== %s 5 =====" % _("Title")),
            
            self.hintline(_("Lists"),divclass='hintheader'),
            self.hintline( _("Start with space(s):")),
            self.hintline("&nbsp;* %s" % _("round bullet")),
            self.hintline("&nbsp;1 %s" % _("numbered bullet")),
            self.hintline("&nbsp;I %s" % _("Roman bullet")),
            self.hintline("&nbsp;i %s" % _("roman bullet")),
            self.hintline("&nbsp;A %s" % _("Alpha bullet")),
            self.hintline("&nbsp;a %s" % _("alpha bullet")),
            
            self.hintline(_("Hyperlinks"),divclass='hintheader'),
            self.hintline(_("JoinCapitalizedWords")),
            self.hintline("http://www.myorg.org"),
            self.hintline("[[http://www.myorg.org]]"),
            self.hintline("[[http://myorg.org|%s]]" % _("my site")),
            self.hintline("user@example.com"),
            
            self.hintline(_("Not a Hyperlink"),divclass='hintheader'),
            self.hintline(_("!JoinCapitalizedWords")),

            self.hintline(_("Embedding"),divclass='hintheader'),
            self.hintline(_("{{attachment:animage.jpg}}")),
            self.hintline(_("{{http://myorg.org/pix.png}}")),
            
            self.hintline(_("Tables"),divclass='hintheader'),
            self.hintline("||%s 1||%s 2||" % (_("cell"),_("cell"))),
            self.hintline("||||%s||" % _("2-column cell")),
            
            self.hintline(_("Macros"),divclass='hintheader'),
            self.hintline("&lt;&lt;FootNote(%s)&gt;&gt;" % _("some text")),
            self.hintline("&lt;&lt;Include(%s)&gt;&gt;" % _("SomePage")),
            self.hintline("&lt;&lt;BR&gt;&gt; - %s" % _("hard line break")),
            
            self.hintline(_("Variables"),divclass='hintheader'),
            self.hintline("@SIG@ - %s" % _("signature with time")),
            self.hintline("@USER@ - %s" % _("signature")),

            u'</div>',
            ]
        return u'\n'.join(html)

    def navipanel(self, d):
        """ Create a navigation panel."""
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' % _("Navigation Links"),
            self.navibar(d),
            u'</div>',
            ]
        return u'\n'.join(html)

    def pagepanel(self, d):
        """ Create page actions panel . 
        
        TODO -- eliminate more actions drop down box by making all choices into a drop down box showing 5 choices."""
        _ = self.request.getText
        if self.shouldShowEditbar(d['page']):
            html = [
                u'<div class="sidepanel">',
                u'<h1>%s</h1>' % _("Page Actions"),
                self.editbar(d),
                u'</div>',
                ]
            return u'\n'.join(html)
        return ''   
        
    def userpanel(self, d):
        """ Create user panel. """
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' %  _("User Actions"),
            self.username(d),
            u'</div>'
            ]
        return u'\n'.join(html)
        
    def trailpanel(self, d):
        """ Create page trail panel """
        _ = self.request.getText

        trail = self.trail(d)
        if not trail:
            return ''

        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' %  _("Page Trail"),
            trail,
            u'</div>'
            ]
        return u'\n'.join(html)

    def trail(self, d):
        """ Assemble page trail - modified to put the most recent on top.
        
        Delete the entire method if you prefer the most recent on bottom.

        @param d: parameter dictionary
        @rtype: unicode
        @return: trail html
        """
        request = self.request
        user = request.user
        html = ''
        if not user.valid or user.show_page_trail:
            trail = user.getTrail()
            if trail:
                trail.reverse() # pages will drop off the bottom, not the top
                items = []
                for pagename in trail:
                    try:
                        interwiki, page = wikiutil.split_interwiki(pagename)
                        if interwiki != request.cfg.interwikiname and interwiki != 'Self':
                            link = (self.request.formatter.interwikilink(True, interwiki, page) +
                                    self.shortenPagename(page) +
                                    self.request.formatter.interwikilink(False, interwiki, page))
                            items.append('<li>%s</li>' % link)
                            continue
                        else:
                            pagename = page

                    except ValueError:
                        pass
                    page = Page(request, pagename)
                    title = page.split_title()
                    title = self.shortenPagename(title)
                    link = page.link_to(request, title)
                    items.append('<li>%s</li>' % link)
                html = '''
<ul id="pagetrail">
%s
</ul>''' % ''.join(items)
        return html
        
    def searchpanel(self,d):
        """Create search panel."""
        _ = self.request.getText
        html = [
            u'<div class="sidepanel">',
            u'<h1>%s</h1>' %  _("Search Wiki"),
            self.searchform(d),
            u'</div>'
            ]
        return u'\n'.join(html)
        
    def searchform(self, d):
        """
        assemble HTML code for the search forms
        
        Only change from ThemeBase is to add mouseOver functionality to buttons.

        @param d: parameter dictionary
        @rtype: unicode
        @return: search form html
        """
        _ = self.request.getText
        form = self.request.form
        updates = {
            'search_label': _('Search:'),
            'search_value': wikiutil.escape(form.get('value', [''])[0], 1),
            'search_full_label': _('Text'),
            'search_title_label': _('Titles'),
            'baseurl': self.request.getScriptname(),
            'pagename_quoted': wikiutil.quoteWikinameURL(d['page'].page_name),
            'mouseOver': '''onmouseover="this.style.cursor='pointer'; this.style.color='#0000FF';" onmouseout="this.style.cursor='auto';  this.style.color='#4080ff'"''',
            }
        d.update(updates)

        html = u'''
<form id="searchform" method="get" action="%(baseurl)s/%(pagename_quoted)s">
<div>
<input type="hidden" name="action" value="fullsearch">
<input type="hidden" name="context" value="180">
<label for="searchinput">%(search_label)s</label>
<input id="searchinput" type="text" name="value" value="%(search_value)s" size="20"
    onfocus="searchFocus(this)" onblur="searchBlur(this)"
    onkeyup="searchChange(this)" onchange="searchChange(this)" alt="Search">
<input id="titlesearch" name="titlesearch" type="submit"
    value="%(search_title_label)s" alt="Search Titles" %(mouseOver)s>
<input id="fullsearch" name="fullsearch" type="submit"
    value="%(search_full_label)s" alt="Search Full Text" %(mouseOver)s>
</div>
</form>
<script type="text/javascript">
<!--// Initialize search form
var f = document.getElementById('searchform');
f.getElementsByTagName('label')[0].style.display = 'none';
var e = document.getElementById('searchinput');
searchChange(e);
searchBlur(e);
//-->
</script>
''' % d
        return html
        
    def sitenameheader(self,d):
        """Create logo and sitename header for left panel."""
        html = [
            u'<div class="sidepanel" id="sitenamelogo">',
            self.logo().replace("</a></div>", " %s</a></div>" % self.cfg.sitename),
            u'<div class="sidebarpagename">%s</div>' % self.title(d), # was d["page_name"],
            u'</div>'
            ]
        return u'\n'.join(html)
        
    def title(self, d):
        """ Assemble the title (now using breadcrumbs).  
        
        Only change from ThemeBase is to make shorter titles for narrow sidebar.
        
        @param d: parameter dictionary
        @rtype: string
        @return: title html
        """
        _ = self.request.getText
        content = []
        if d['title_text'] == d['page'].split_title(): 
            curpage = ''
            segments = d['page_name'].split('/') # was: title_text
            for s in segments[:-1]:
                ss = self.shortenPagename(s) # @@@ create a short name for sidebar
                curpage += s
                #~ content.append("<li>%s</li>" % Page(self.request, curpage).link_to(self.request, s))
                content.append("<li>%s</li>" % Page(self.request, curpage).link_to(self.request, ss)) # @@@ use short name
                curpage += '/'
            #~ link_text = segments[-1]
            link_text = self.shortenPagename(segments[-1]) 
            #~ link_title = _('Click to do a full-text search for this title', formatted=False)
            link_title = _('Click to do a full-text search for ', formatted=False) + d['page_name'] # @@@ alt text includes name
            link_query = {
                'action': 'fullsearch',
                'value': 'linkto:"%s"' % d['page_name'],
                'context': '180',
            }
            # we dont use d['title_link'] any more, but make it ourselves:
            link = d['page'].link_to(self.request, link_text, querystr=link_query, title=link_title, css_class='backlink', rel='nofollow')
            content.append(('<li>%s</li>') % link)
        else:
            content.append('<li>%s</li>' % wikiutil.escape(d['title_text']))

        html = '''<ul id="pagelocation">%s</ul>''' % "".join(content)
        return html

    def header(self, d):
        """
        Assemble page header - this is the left sidebar
        
        @param d: parameter dictionary
        @rtype: string
        @return: page header html
        """
        _ = self.request.getText

        html = [
            # Sidebar
            u'<div id="sidebar">',
            self.sitenameheader(d),
            self.searchpanel(d),
            self.navipanel(d),
            self.pagepanel(d),
            self.userpanel(d),
            self.trailpanel(d),
            u'<div>',
            self.credits(d),
            u'</div>',
            u'</div>', # sidebar
            self.msg(d),
            
            # Page
            self.startPage(),
            ]
        # because of sidebar, there is nothing to separate header1 from 2 -- so enclose both in a pageheader div
        prehtml = []
        if self.cfg.page_header1 or self.cfg.page_header2:
            prehtml = [
                # css should specify the same left margin for pagefooter as is used for page
                u'<div id="pageheader">',
                self.emit_custom_html(self.cfg.page_header1),
                self.emit_custom_html(self.cfg.page_header2),
                u'</div>', # pageheader
                ]

                
        html = [u'<div id="wholebody">',] + prehtml + html 
        return u'\n'.join(html)
        
    def editorheader(self, d):
        """
        Assemble editor header as a left sidebar.
        
        @param d: parameter dictionary
        @rtype: string
        @return: page header html
        """
        _ = self.request.getText

        html = [
            # Custom html above header
            self.emit_custom_html(self.cfg.page_header1),

            u'<div id="wholebody">', # add a relatively positioned div 
            # Custom html below header (not recomended!)
            self.emit_custom_html(self.cfg.page_header2),

            # Sidebar
            u'<div id="sidebar">',
            self.sitenameheader(d),
            self.editbuttons(d),
            self.edithelp(d),
            self.edit_hints(d),
            self.credits(d),
            u'</div>', # sidebar
            #~ u'</div>', # wholebody end is added by footer
            self.msg(d),
            self.startPage(),
            ]
        return u'\n'.join(html)

    def footer(self, d, **keywords):
        """ Assemble page footer  - on this theme there is nothing to separate footer 2 and footer 1
        
        @param d: parameter dictionary
        @keyword ...:...
        @rtype: string
        @return: page footer html
        """
        page = d['page']
        html = [
            self.pageinfo(page),
            self.emit_custom_html(self.cfg.page_footer2),
            self.emit_custom_html(self.cfg.page_footer1),
            self.endPage(),
            u'</div>',  # wholebody
            ]
        return u'\n'.join(html)
        
    def maxPagenameLength(self):
        """ Return maximum length for shortened page names. 
        
        Override ThemeBase value of 25."""
        return 20
        
    def navibar(self, d):
        """ Copied from from ThemeBase in __init__.py.

        Only change is to omit current page from the navibar, because...
        The fixedleft sidebar should be as stable as possible.  Adding the current page causes it to
        expand if the current page is a defined navibar page.

        Assemble the navibar

        @param d: parameter dictionary
        @rtype: unicode
        @return: navibar html
        """
        request = self.request
        found = {} # pages we found. prevent duplicates
        items = [] # navibar items
        item = u'<li class="%s">%s</li>'
        current = d['page_name']

        # Process config navi_bar
        if request.cfg.navi_bar:
            for text in request.cfg.navi_bar:
                pagename, link = self.splitNavilink(text)
                if pagename == current:
                    cls = 'wikilink current'
                else:
                    cls = 'wikilink'
                items.append(item % (cls, link))
                found[pagename] = 1

        # Add user links to wiki links, eliminating duplicates.
        userlinks = request.user.getQuickLinks()
        for text in userlinks:
            # Split text without localization, user knows what he wants
            pagename, link = self.splitNavilink(text, localize=0)
            if not pagename in found:
                if pagename == current:
                    cls = 'userlink current'
                else:
                    cls = 'userlink'
                items.append(item % (cls, link))
                found[pagename] = 1

        #~ # Add current page at end
        #~ if not current in found:
            #~ title = d['page'].split_title(request)
            #~ title = self.shortenPagename(title)
            #~ link = d['page'].link_to(request, title)
            #~ cls = 'current'
            #~ items.append(item % (cls, link))

        # Assemble html
        items = u''.join(items)
        html = u'''<ul id="navibar">%s</ul>''' % items
        return html


def execute(request):
    """
    Generate and return a theme object
        
    @param request: the request object
    @rtype: MoinTheme
    @return: Theme object
    """
    return Theme(request)

