# -*- coding: iso-8859-1 -*-
"""
	MentalWealth is a MoinMoin theme
	by robin.escalation@ACM.org.
	
	Licensed under GPL.
	Do not remove credit or claim it as your own.

	For more info see the readme.html.
"""
from MoinMoin.theme import ThemeBase
from MoinMoin.wikiutil import link_tag as link
from MoinMoin.wikiutil import quoteWikinameURL as quoteURL
from MoinMoin.Page import Page

MOREACTIONS = True

class BuildLinks(object):
	"""
		Accumulates a list of links.
	"""
	def __init__(self, request, page):
		self.request = request
		self.url = quoteURL(page.page_name)
		
		self.links = []
			
	def addplain(self, text):
		self.links += [text]
		
	def add(self, action, label):
		url = '%s?action=%s' % (self.url, action)
		txt = self.request.getText(label, formatted=False)
		
		self.links += [link(self.request, url, txt)]

	def __call__(self):
		html = u'<ul class="editbar">\n%s\n</ul>\n' %\
			   '\n'.join(['<li>%s</li>' % item for item in self.links if item != ''])

		return html

class Theme(ThemeBase):
        # fake _ function to get gettext recognize those texts:
        _ = lambda x: x

        # TODO: remove icons that are not used any more.
        icons = {
                # key         alt                        icon filename      w   h
                # ------------------------------------------------------------------
                # navibar
                'help':       ("%(page_help_contents)s", "moin-help.png",   12, 11),
                'find':       ("%(page_find_page)s",     "moin-search.png", 12, 12),
                'diff':       (_("Diffs"),               "moin-diff.png",   15, 11),
                'info':       (_("Info"),                "moin-info.png",   12, 11),
                'edit':       (_("Edit"),                "moin-edit.png",   12, 12),
                'unsubscribe':(_("Unsubscribe"),         "moin-unsubscribe.png",  14, 10),
                'subscribe':  (_("Subscribe"),           "moin-subscribe.png",14, 10),
                'raw':        (_("Raw"),                 "moin-raw.png",    12, 13),
                'xml':        (_("XML"),                 "moin-xml.png",    20, 13),
                'print':      (_("Print"),               "moin-print.png",  16, 14),
                'view':       (_("View"),                "moin-show.png",   12, 13),
                'home':       (_("Home"),                "moin-home.png",   13, 12),
                'up':         (_("Up"),                  "moin-parent.png", 15, 13),
                # FileAttach
                'attach':     ("%(attach_count)s",       "moin-attach.png",  7, 15),
                # RecentChanges
                'rss':        (_("[RSS]"),               "moin-rss.png",    36, 14),
                'deleted':    (_("[DELETED]"),           "moin-deleted.png",60, 12),
                'updated':    (_("[UPDATED]"),           "moin-updated.png",60, 12),
                'new':        (_("[NEW]"),               "moin-new.png",    31, 12),
                'diffrc':     (_("[DIFF]"),              "moin-diff.png",   15, 11),
                # General
                'bottom':     (_("[BOTTOM]"),            "moin-bottom.png", 14, 10),
                'top':        (_("[TOP]"),               "moin-top.png",    14, 10),
                'www':        ("[WWW]",                  "moin-www.png",    11, 11),
                'mailto':     ("[MAILTO]",               "moin-email.png",  14, 10),
                'news':       ("[NEWS]",                 "moin-news.png",   10, 11),
                'telnet':     ("[TELNET]",               "moin-telnet.png", 10, 11),
                'ftp':        ("[FTP]",                  "moin-ftp.png",    11, 11),
                'file':       ("[FILE]",                 "moin-ftp.png",    11, 11),
                # search forms
                'searchbutton': ("[?]",                  "moin-search.png", 12, 12),
                'interwiki':  ("[%(wikitag)s]",          "moin-inter.png",  16, 16),
                # -- from TaskPlanner __init__.diff (modified) --
                # AttachTable and TaskTable toggle controls
                'table-null':               ("",                            "taskplanner/table-null.png", 16, 16),
                'table-close':              (_("Click to collapse table"),  "taskplanner/table-close.png", 16, 16),
                'table-open':               (_("Click to expand table"),    "taskplanner/table-open.png", 16, 16),
                # TaskTable icons
                'task--todo':               (_("To Do"),                    "taskplanner/task-no-todo.png", 48, 48),
                'task--inprogress':         (_("In Progress"),              "taskplanner/task-no-inprogress.png", 48, 48),
                'task--pending':            (_("Pending"),                  "taskplanner/task-no-pending.png", 48, 48),
                'task--done':               (_("Done"),                     "taskplanner/task-no-done.png", 48, 48),
                'task--failed':             (_("Failed"),                   "taskplanner/task-no-failed.png", 48, 48),
                'task-low-todo':            (_("Low - To Do"),              "taskplanner/task-low-todo.png", 48, 48),
                'task-low-inprogress':      (_("Low - In Progress"),        "taskplanner/task-low-inprogress.png", 48, 48),
                'task-low-pending':         (_("Low - Pending"),            "taskplanner/task-low-pending.png", 48, 48),
                'task-low-done':            (_("Low - Done"),               "taskplanner/task-low-done.png", 48, 48),
                'task-low-failed':          (_("Low - Failed"),             "taskplanner/task-low-failed.png", 48, 48),
                'task-medium-todo':         (_("Medium - To Do"),           "taskplanner/task-medium-todo.png", 48, 48),
                'task-medium-inprogress':   (_("Medium - In Progress"),     "taskplanner/task-medium-inprogress.png", 48, 48),
                'task-medium-pending':      (_("Medium - Pending"),         "taskplanner/task-medium-pending.png", 48, 48),
                'task-medium-done':         (_("Medium - Done"),            "taskplanner/task-medium-done.png", 48, 48),
                'task-medium-failed':       (_("Medium - Failed"),          "taskplanner/task-medium-failed.png", 48, 48),
                'task-high-todo':           (_("High - To Do"),             "taskplanner/task-high-todo.png", 48, 48),
                'task-high-inprogress':     (_("High - In Progress"),       "taskplanner/task-high-inprogress.png", 48, 48),
                'task-high-pending':        (_("High - Pending"),           "taskplanner/task-high-pending.png", 48, 48),
                'task-high-done':           (_("High - Done"),              "taskplanner/task-high-done.png", 48, 48),
                'task-high-failed':         (_("High - Failed"),            "taskplanner/task-high-failed.png", 48, 48),
                'task-critical-todo':       (_("Critical - To Do"),         "taskplanner/task-critical-todo.png", 48, 48),
                'task-critical-inprogress': (_("Critical - In Progress"),   "taskplanner/task-critical-inprogress.png", 48, 48),
                'task-critical-pending':    (_("Critical - Pending"),       "taskplanner/task-critical-pending.png", 48, 48),
                'task-critical-done':       (_("Critical - Done"),          "taskplanner/task-critical-done.png", 48, 48),
                'task-critical-failed':     (_("Critical - Failed"),        "taskplanner/task-critical-failed.png", 48, 48),
                'task-closed':              (_("Closed"),                   "taskplanner/task-closed.png", 48, 48),
                'task-removeme':            (_("Remove Me"),                "taskplanner/task-removeme.png", 48, 48),
                # AttachTable mimetypes
                'unknown':                  (_("Unknown filetype"),         "taskplanner/filetype-unknown.png", 48, 48),
                'generic-x-archive':        (_("Archive file"),             "taskplanner/generic-x-archive.png", 48, 48),
                'generic-x-audio':          (_("Audio file"),               "taskplanner/generic-x-audio.png", 48, 48),
                'generic-x-image':          (_("Image file"),               "taskplanner/generic-x-image.png", 48, 48),
                'generic-text-x-source':    (_("Source code file"),         "taskplanner/generic-text-x-source.png", 48, 48),
                'generic-x-video':          (_("Video file"),               "taskplanner/generic-x-video.png", 48, 48),
                '.doc':                     (_("MS Word file"),             "taskplanner/mime-msword.png", 48, 48),
                '.html':                    (_("HTML file"),                "taskplanner/mime-text-html.png", 48, 48),
                '.mdb':                     (_("MS Access file"),           "taskplanner/mime-msaccess.png", 48, 48),
                '.pdf':                     (_("PDF file"),                 "taskplanner/mime-pdf.png", 48, 48),  
                '.ppt':                     (_("MS PowerPoint file"),       "taskplanner/mime-mspowerpoint.png", 48, 48),
                '.txt':                     (_("Text file"),                "taskplanner/generic-x-text.png", 48, 48),
                '.xls':                     (_("MS Excel file"),            "taskplanner/mime-msexcel.png", 48, 48),
                # -- from Dropline's __init__.py (modified) --
                # smileys
                'X-(':        ("X-(",                    'dropline/angry.png',       18, 18),
                ':D':         (":D",                     'dropline/biggrin.png',     18, 18),
                '<:(':        ("<:(",                    'dropline/frown.png',       18, 18),
                ':o':         (":o",                     'dropline/redface.png',     18, 18),
                ':(':         (":(",                     'dropline/sad.png',         18, 18),
                ':)':         (":)",                     'dropline/smile.png',       18, 18),
                'B)':         ("B)",                     'dropline/smile2.png',      18, 18),
                ':))':        (":))",                    'dropline/smile3.png',      18, 18),
                ';)':         (";)",                     'dropline/smile4.png',      18, 18),
                '/!\\':       ("/!\\",                   'dropline/alert.png',       16, 16),
                '<!>':        ("<!>",                    'dropline/attention.png',   16, 16),
                '(!)':        ("(!)",                    'dropline/idea.png',        16, 16),
                ':-?':        (":-?",                    'dropline/tongue.png',      18, 18),
                ':\\':        (":\\",                    'dropline/ohwell.png',      18, 18),
                '>:>':        (">:>",                    'dropline/devil.png',       18, 18),
                '|)':         ("|)",                     'dropline/tired.png',       18, 18),

                # some folks use noses in their emoticons
                ':-(':        (":-(",                    'dropline/sad.png',         18, 18),
                ':-)':        (":-)",                    'dropline/smile.png',       18, 18),
                'B-)':        ("B-)",                    'dropline/smile2.png',      18, 18),
                ':-))':       (":-))",                   'dropline/smile3.png',      18, 18),
                ';-)':        (";-)",                    'dropline/smile4.png',      18, 18),
                '|-)':        ("|-)",                    'dropline/tired.png',       18, 18),

                # version 1.0
                '(./)':       ("(./)",                   'dropline/checkmark.png',   16, 16),
                '{OK}':       ("{OK}",                   'dropline/thumbs-up.png',   16, 16),
                '{X}':        ("{X}",                    'dropline/icon-error.png',  16, 16),
                '{i}':        ("{i}",                    'dropline/icon-info.png',   16, 16),
                '{1}':        ("{1}",                    'dropline/prio1.png',       16, 16),
                '{2}':        ("{2}",                    'dropline/prio2.png',       16, 16),
                '{3}':        ("{3}",                    'dropline/prio3.png',       16, 16),

                # version 1.3.4 (stars)
                # try {*}{*}{o}
                '{*}':        ("{*}",                    'dropline/star_on.png',     16, 16),
                '{o}':        ("{o}",                    'dropline/star_off.png',    16, 16),

                # new question mark smiley
                '<?>':        ("<?>",                    'dropline/question.png',     16, 16),

                # new big icons for classic theme
                'diff-big':       (_("Diffs"),           "dropline/moin-diff-big.png",   31, 25),
                'info-big':       (_("Info"),            "dropline/moin-info-big.png",   25, 25),
                'edit-big':       (_("Edit"),            "dropline/moin-edit-big.png",   25, 25),
                'unsubscribe-big':(_("Unsubscribe"),     "dropline/moin-unsubscribe-big.png",  25, 25),
                'subscribe-big':  (_("Subscribe"),       "dropline/moin-subscribe-big.png", 25, 25),
                'raw-big':        (_("Raw"),             "dropline/moin-raw-big.png",    25, 25),
                'print-big':      (_("Print"),           "dropline/moin-print-big.png",  25, 25),
                'view-big':       (_("View"),            "dropline/moin-show-big.png",   25, 25),
                
        }
        del _

	name = 'mentalwealth'

	def editbarmore(self, d):
		"""
			Assemble panel for additional actions from the parameter dictionary.
		"""
		# short circuit
		if not self.shouldShowEditbar(d['page']):
			return ''

		# use cached copy if possible
		cacheKey = 'editbarmore'
		cached = self._cache.get(cacheKey)
		if cached:
			return cached
		
		# optimisations
		_get = self.request.getText
		page = d['page']

		# we can do these actions
		available = self.request.getAvailableActions(page)

		# start building list of links
		builder = BuildLinks(self.request, page)

		# even more actions
		choices = [key for key, value in self.choices]
		for action in available:
			if action not in choices:
				# split label text
				label = Page(self.request, action).split_title(self.request, force=1)
				builder.add(action, label.lower())

		# cache for next call
		html = builder()
		self._cache[cacheKey] = html
		return html

	def editbar(self, d):
		"""
			Assemble the page edit bar from the parameter dictionary.
			This is rewritten here to get rid of fugly drop-down menu.
		"""
		# short circuit
		if not self.shouldShowEditbar(d['page']):
			return ''

		# use cached copy if possible
		cacheKey = 'editbar'
		cached = self._cache.get(cacheKey)
		if cached:
			return cached

		# optimisations
		_get = self.request.getText
		page = d['page']
		
		# start building list of links
		builder = BuildLinks(self.request, page)
		
		# parent page
		parent = page.getParentPage()
		if parent:
			builder.addplain(parent.link_to(self.request, _get('Show Parent', formatted=False)))

		# determine which actions we can use
		available = self.request.getAvailableActions(page)
		for action, label in self.choices:
			if action == 'refresh' and not page.canUseCache():
				continue
			if action == 'edit' and not (page.isWritable() and self.request.user.may.write(page.page_name)):
				continue
			if action[0].isupper() and not action in available:
				continue
			builder.add(action, label)

		# delegate this next part so I can stop rewriting code ;-)
		builder.addplain(self.subscribeLink(page))

		# cache for next call
		html = builder()
		self._cache[cacheKey] = html
		return html

	def header(self, d, **kw):
		"""
			Assemble page header, which includes our sidebar.
			
			@param d: parameter dictionary
			@rtype: string
			@return: page header html
		"""
		_ = self.request.getText

		# there are 6 main panels: each one follows this markup
		html = u'<div class="sidepanel"><h1>%s</h1>%s</div>'
		
		# "search" panel hack so I don't have to rewrite searchform()
		searchpanel = self.searchform(d).replace('<input id="titlesearch"',
												 '<br><input id="titlesearch"')

		# explicit list of possible actions and their text labels
		self.choices = [['edit',			'edit'],
						['diff',			'show changes'],
						['info',			'get info'],
						['raw',				'show raw text'],
						['print',			'show print view'],
						['refresh',			'delete cache'],
						['AttachFile',		'attach file'],
						['SpellCheck',		'check spelling'],
						['LikePages',		'show like pages'],
						['LocalSiteMap',	'show local site map'],
						['RenamePage',		'rename page'],
						['DeletePage',		'delete page']
						]
		
		# bundle up all our parts
		parts = [	self.emit_custom_html(self.cfg.page_header1),
					'<div id="header">%s</div>' % self.logo(),
					self.emit_custom_html(self.cfg.page_header2),
					u'<div id="sidebar">',
					html % (_('Search'),     	searchpanel),
					html % (_('Navigation'), 	self.navibar(d)),
					html % (_('Recent'),     	self.trail(d)),
					html % (_('This Page'),  	self.editbar(d))
				]

		if MOREACTIONS:
			parts += [html % (_('More Actions'), self.editbarmore(d))]

		parts += [	html % (_('User'), self.username(d)),
					self.credits(d),
					u'</div>',
					self.msg(d),		
					self.startPage()
				]
		return u'\n'.join(parts)
	
	def footer(self, d, **kw):
		"""
			Assemble page footer
			
			@param d: parameter dictionary
			@keyword ...:...
			@rtype: string
			@return: page footer html
		"""
		parts = [	u'<div id="pagebottom"></div>',
					self.pageinfo(d['page']),
					self.endPage(),
					self.emit_custom_html(self.cfg.page_footer1),
					self.emit_custom_html(self.cfg.page_footer2),
					]
		return u'\n'.join(parts)

def execute(request):
	"""
		Generate and return a theme object.
	"""
	return Theme(request)
