#!/usr/bin/env python

from ImprovedTableParser import parse

table = """<tablestyle="border: 2px solid red; border-collapse: collapse;" rowstyle="background-color: #f77;">
Test||Outcome||Comments
==
Colspan
||<colspan="2"> Test a column with attributes
==
Normal || <style="
text-align: center" colspan=1> Three columns || Adjacent column
==
Split
|| Three columns
|| Separate lines
==
 * Item #1
 * Item #2
||
 * Item #A
|| Not a list
==
{{{
Some preformatted text.
==
Not another row.
}}}
||<colspan="2"> Preformatted text in a separate section
==
== Heading 2 ==
This is in the first column.
|| And this is in the second.
== This, despite the == is in a new row.
||
And this is the second column.
==
Some {{{{preformatted text}}}} || Some `preformatted text` || Observe the region notation inline.
==
<rowspan=2> 1 || 2 || 3
==
<rowstyle="background-color: #f33"> 2 || 3
==
The first column || The second
                 .. with the continuation of
                 .. the text without indentation occurring.
==
A test || Of...
          ...non-continuation
==
<<Macro>>
"""

attrs, rows = parse(table)
expected = 14

print table
print attrs
print rows
print len(rows) == expected, ": length is", len(rows), "==", expected
print
for (row_attrs, columns), expected in zip(rows, [3, 2, 3, 3, 3, 2, 2, 2, 3, 3, 2, 2, 2, 1]):
    print row_attrs
    print columns
    non_continuation_columns = [
        (column_attrs, content)
        for (column_attrs, content) in columns
        if not column_attrs.has_key("colcontinuation")
        and not column_attrs.has_key("rowcontinuation")
        and not content is None
        ]
    print len(non_continuation_columns) == expected, ": length is", len(non_continuation_columns), "==", expected
    print

expected_text = "The second\nwith the continuation of\nthe text without indentation occurring.\n"
text = rows[11][1][1][1]
print text == expected_text, ": text is", repr(text)

expected_text = "Of...\n          ...non-continuation\n"
text = rows[12][1][1][1]
print text == expected_text, ": text is", repr(text)

expected_text = "\n<<Macro>>\n"
text = rows[13][1][0][1]
print text == expected_text, ": text is", repr(text)

# vim: tabstop=4 expandtab shiftwidth=4
