# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - table (ImprovedTableParser)

    @copyright: 2012 by Paul Boddie <paul@boddie.org.uk>
    @license: GNU GPL (v2 or later), see COPYING.txt for details.
"""

from ImprovedTableParser import *

Dependencies = ["pages"]

# Parser support.

class Parser:

    "Support a more flexible table syntax."

    Dependencies = Dependencies
    extensions = []

    # Output content types preferred by this parser.

    output_mimetypes = ["text/html"]

    def __init__(self, raw, request, **kw):

        """
        Initialise the parser with the given 'raw' data, 'request' and any
        keyword arguments that may have been supplied.
        """

        self.raw = raw
        self.request = request
        self.attrs = parseAttributes(kw.get("format_args", ""), False)

    def format(self, fmt, write=None):

        """
        Format a table using the given formatter 'fmt'. If the 'write' parameter
        is specified, use it to write output; otherwise, write output using the
        request.
        """

        formatTable(self.raw, self.request, fmt, self.attrs, write=write)

    # Extra API methods.

    def formatForOutputType(self, mimetype, write=None):

        """
        Format a table for the given 'mimetype'. If the 'write' parameter is
        specified, use it to write output; otherwise, write output using the
        request.
        """

        formatTableForOutputType(self.raw, self.request, mimetype, self.attrs, write=write)

    # Class methods.

    def getOutputTypes(self):
        return self.output_mimetypes

    getOutputTypes = classmethod(getOutputTypes)

# vim: tabstop=4 expandtab shiftwidth=4
