# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - table (ImprovedTableParser)

    @copyright: 2012 by Paul Boddie <paul@boddie.org.uk>
    @license: GNU GPL (v2 or later), see COPYING.txt for details.
"""

from ImprovedTableParser import *

Dependencies = ["pages"]

# Parser support.

class Parser:

    "Support a more flexible table syntax."

    Dependencies = Dependencies
    extensions = []

    def __init__(self, raw, request, **kw):

        """
        Initialise the parser with the given 'raw' data, 'request' and any
        keyword arguments that may have been supplied.
        """

        self.raw = raw
        self.request = request
        self.attrs = parseAttributes(kw.get("format_args", ""), False)

    def format(self, fmt):

        "Format a table using the given formatter 'fmt'."

        request = self.request
        page = request.page
        _ = request.getText

        formatTable(self.raw, request, fmt, self.attrs)

# vim: tabstop=4 expandtab shiftwidth=4
