# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - ImageBrowser Macro
    Version 0.1

    [[ImageBrowser(index, file1, file2, ...)]]

    @copyright: 2007 by Kenneth Bull
    @license: GNU GPL, see COPYING for details.

"""

from MoinMoin import wikiutil

def parseArgs(args):
    params = [""]
    quote = ""
    i = 0
    while i < len(args):
        c = args[i]
        if quote == "":
            if ((c == '"') or (c == "'")) and (params[-1] == ""):
                quote = c
                params[-1] = ""
            elif c == ',':
                params.append("")
            elif (c != ' ') or (params[-1] != ""):
                params[-1] += c
        else:
            if c == quote:
                quote = ""
            else:
                params[-1] += c
        i += 1
    return params

imgbrswrscript = """
<script type="text/javascript">
	function imgbrwsr_goto(id, imgno)	{
		var root = document.getElementById(id);
		var maximg = parseInt(root.getAttribute("imgcount")) - 1;
	 	var old_imgno = parseInt(root.getAttribute("imgnumber"));
		if (imgno < 0)		imgno = 0;
		if (imgno > maximg)	imgno = maximg;
		root.setAttribute("imgnumber", String(imgno));
		document.getElementById(id+"_"+String(old_imgno)).style.display = "none";
		document.getElementById(id+"_"+String(imgno)).style.display = "block";
		if (imgno == 0)	{
			document.getElementById(id+"_frst").style.display = "none";
			document.getElementById(id+"_back").style.display = "none";
		} else {
			document.getElementById(id+"_frst").style.display = "block";
			document.getElementById(id+"_back").style.display = "block";
		}
		if (imgno == maximg)	{
			document.getElementById(id+"_next").style.display = "none";
			document.getElementById(id+"_last").style.display = "none";
		} else {
			document.getElementById(id+"_next").style.display = "block";
			document.getElementById(id+"_last").style.display = "block";
		}
	}
	function imgbrwsr_offset(id, off)	{
		var root = document.getElementById(id);
		var maximg = parseInt(root.getAttribute("imgcount")) - 1;
	 	var old_imgno = parseInt(root.getAttribute("imgnumber"));
	 	var imgno = old_imgno + off;
		if (imgno < 0)		imgno = 0;
		if (imgno > maximg)	imgno = maximg;
		root.setAttribute("imgnumber", String(imgno));
		document.getElementById(id+"_"+String(old_imgno)).style.display = "none";
		document.getElementById(id+"_"+String(imgno)).style.display = "block";
		if (imgno == 0)	{
			document.getElementById(id+"_frst").style.display = "none";
			document.getElementById(id+"_back").style.display = "none";
		} else {
			document.getElementById(id+"_frst").style.display = "block";
			document.getElementById(id+"_back").style.display = "block";
		}
		if (imgno == maximg)	{
			document.getElementById(id+"_next").style.display = "none";
			document.getElementById(id+"_last").style.display = "none";
		} else {
			document.getElementById(id+"_next").style.display = "block";
			document.getElementById(id+"_last").style.display = "block";
		}
	}
</script>
"""

def execute(macro, args):
    import random
    from MoinMoin.action import AttachFile
    p = parseArgs(args)
    ndx = int(p.pop(0))
    Id = "imgbrwsr"+str(random.randint(0, 65535))
    i = 0
    try:
        macro.formatter._imgbrwsr_js
        output = ""
    except:
        output = imgbrswrscript
        macro.formatter._imgbrwsr_js = 1
    output += "<div id='%(id)s' style='width:358px; height:312px; position:relative; background:url(/wiki/common/imgbrwsr/frame.png);' imgnumber='%(ndx)d' imgcount='%(cnt)d'>\n" % {'id': Id, 'ndx': ndx, 'cnt': len(p)}
    for f in p:
        pagename, filename = AttachFile.absoluteName(f, macro.formatter.page.page_name)
        output += "\t<a id='%(id)s_%(i)d' href='%(page)s?action=AttachFile&do=get&target=%(file)s' style='position:absolute; left:19px; top:20px; display:%(disp)s;' />" % {'id': Id, 'i': i, 'page': pagename, 'file': filename, 'disp': (i == ndx) and "block" or "none"}
        output += "<img src='%(page)s?action=Thumbnail&target=%(file)s&w=320&h=240' style='width:320px; height:240px; border:none;' /></a>\n" % {'page': pagename, 'file': filename};
        #output += "<img src='%(page)s?action=AttachFile&do=get&target=%(file)s' style='width:320px; height:240px; border:none;' /></a>\n" % {'page': pagename, 'file': filename};
        i += 1
    output += """
	<a id='%(id)s_frst' href="javascript:imgbrwsr_goto('%(id)s', 0);" style='position:absolute; left:11px; top:266px; display:%(disp1)s;'><img src='/wiki/common/imgbrwsr/first.png' style='border:none;' alt='first' /></a>
	<a id='%(id)s_back' href="javascript:imgbrwsr_offset('%(id)s', -1);" style="position:absolute; left:55px; top:266px; display:%(disp1)s;"><img src="/wiki/common/imgbrwsr/back.png" style="border:none;" alt="back" /></a>
	<a id='%(id)s_next' href="javascript:imgbrwsr_offset('%(id)s', 1);" style="position:absolute; left:271px; top:266px; display:%(disp2)s;"><img src="/wiki/common/imgbrwsr/next.png" style="border:none;" alt="next" /></a>
	<a id='%(id)s_last' href="javascript:imgbrwsr_goto('%(id)s', %(cnt)d);" style="position:absolute; left:303px; top:266px; display:%(disp2)s;"><img src="/wiki/common/imgbrwsr/last.png" style="border:none;" alt="last" /></a>
</div>
""" % {'id': Id, 'cnt': len(p)-1, 'disp1': ((ndx > 0) and 'block' or 'none'), 'disp2': ((ndx < len(p) - 1) and 'block' or 'none')}
    return output
