# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - imgbrwsrgen Action
    Version 0.1

    Generates the various components of a PHP or HTML image browser.

    @copyright: 2007 by Kenneth Bull
    @license: GNU GPL, see COPYING for details.
"""
from ..macro import ImageBrowserContent
from MoinMoin.action import AttachFile
from MoinMoin.Page import Page
from MoinMoin import wikiutil

try:
    from MoinMoin.util import MoinMoinNoFooter
except:
    MoinMoinNoFooter = None

try:
    from . import Thumbnail
except:
    Thumbnail = None

try:
    from ..macro import ImageBrowserContent
except:
    ImageBrowserContent = None

action_name = __name__.split('.')[-1]

PHPWrapper = '''<?php

%(includes)s

$content = %(content)s;

if (!$intemplate)   {
    ?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>%(title)s</title>
		<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" /></head>
	<body><?php echo $content ?></body></html>
<?php } ?>
'''

HTMLWrapper = '''<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>%(title)s</title>
		<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" /></head>
	<body>%(content)s</body></html>
'''

def zip_files(zipname, filelist):
    import zipfile
    z = zipfile.ZipFile(zipname, 'w', zipfile.ZIP_DEFLATED, True)
    for f in filelist:
        if isinstance(f, tuple) or isinstance(f, list):
            if isinstance(f[0], str):
                z.write(f[0].encode('cp437'), f[1].encode('cp437'))
            else:
                f[0].seek(0)
                z.writestr(f[1].encode('cp437'), f[0].read())
        else:
            z.write(f.encode('cp437'))
    z.close()
    return

def send_openfile(request, f, name, mimetype, disposition='inline'):
    import os, shutil, time
    from MoinMoin.util import timefuncs
    f.flush()
    f.seek(0, os.SEEK_END)
    request.http_headers([
        'Content-Type: %s' % mimetype,
        'Last-Modified: %s' % timefuncs.formathttpdate(time.time()),
        'Content-Length: %d' % (f.tell()+1),
        'Content-Disposition: %s; filename="%s"' % (disposition, name),
    ])
    f.seek(0, os.SEEK_SET)
    shutil.copyfileobj(f, request, 8192)
    f.close()
    return

def getContent(request, page_name, filename, ftype):
    content = ImageBrowserContent.getPageContent(request, request.formatter, "%s/%s" % (page_name, filename))
    if ftype == "php":
        content = PHPWrapper % \
                  {'includes': '',
                   'content': '"'+content.replace('"', '\\"')+'"',
                   'title': "%s/%s" % (page_name, filename)}
    elif ftype == "html":
        content = HTMLWrapper % \
                  {'content': content,
                   'title': "%s/%s" % (page_name, filename)}
    # TODO: translate url(...) css, img src='...', a href='...' values to something meaningful (use a custom formatter?)
    return content.encode('iso-8859-1')

def execute(pagename, request):
    _ = request.getText
    page = Page(request, pagename)

    if ImageBrowserContent is None:
        page.send_page(request, msg = _("This action requires the ImageBrowserContent macro."))
        return

    files = request.form.get('files')
    if files is None:
        files = ImageBrowserContent.getImageList(request, pagename)
    else:
        files = files[0].split(',')
    
    do = request.form.get('do', ['help'])[0]
    if do == 'help':
        request.disableHttpCaching(level=2)
        request.http_headers()
        wikiutil.send_title(request, _("%(pagename)s: Image Browser Generator") % {'pagename': pagename}, page=page, pagename=pagename, html_head='', editor_mode=1)
        request.write(request.formatter.startContent("content"))

        request.write(request.formatter.heading(1, 1)+\
                      _("Image browser components")+\
                      request.formatter.heading(0, 1))

        request.write(request.formatter.heading(1, 2)+\
                      _("Code")+\
                      request.formatter.heading(0, 2))
        
        url = '%s/%s?action=%s&do=' % (request.getScriptname(),
                                       wikiutil.quoteWikinameURL(pagename),
                                       action_name)
        for cmd in [['inc',     _("PHP include file (include this from 'inc/pagelist.inc')")],
                    ['php',     _("PHP code (the page containing the image browser)")],
                    ['js',      _("Java``Script code")],
                    ['html',    _("HTML code")]]:
            request.write(''.join([\
                request.formatter.url(1,
                    url = ''.join([\
                        url,
                        cmd[0],
                        request.form.get('prefix') and ('&prefix=%s' % request.form.get('prefix')[0]) or '',
                        request.form.get('index') and ('&index=%s' % request.form.get('index')[0]) or '',
                        request.form.get('files') and ('&files=%s' % request.form.get('files')[0]) or ''])),
                cmd[1],
                request.formatter.url(0),
                request.formatter.linebreak(preformatted=0)]))

        request.write(request.formatter.heading(1, 2)+\
                      _("Images")+\
                      request.formatter.heading(0, 2))

        request.write(''.join([\
            request.formatter.url(1,
                url = ''.join([\
                    url,
                    'imgzip',
                    request.form.get('files') and ('&files=%s' % request.form.get('files')[0]) or ''])),
            _("Image zip file"),
            request.formatter.url(0),
            request.formatter.linebreak(preformatted=0),
            request.formatter.linebreak(preformatted=0)]))

        for f in files:
            page_name, filename = AttachFile.absoluteName(f, pagename)
            request.write(''.join([\
                request.formatter.url(1, url = AttachFile.getAttachUrl(page_name, filename, request)),
                "%s/%s" % (page_name, filename),
                request.formatter.url(0),
                request.formatter.linebreak(preformatted=0)]))

        if Thumbnail is not None:
            request.write(request.formatter.heading(1, 2)+\
                          _("Thumbnails")+\
                          request.formatter.heading(0, 2))
            request.write(''.join([\
                request.formatter.url(1,
                    url = ''.join([\
                        url,
                        'thmbzip',
                        request.form.get('files') and ('&files=%s' % request.form.get('files')[0]) or ''])),
                _("Thumbnail zip file"),
                request.formatter.url(0),
                request.formatter.linebreak(preformatted=0),
                request.formatter.linebreak(preformatted=0)]))

            for f in files:
                page_name, filename = AttachFile.absoluteName(f, pagename)
                request.write(''.join([\
                    request.formatter.url(1, url = Thumbnail.getThumbnailUrl(request, page_name, filename, 320, 240)),
                    "%s/%s" % (page_name, filename),
                    request.formatter.url(0),
                    request.formatter.linebreak(preformatted=0)]))

        request.write(request.formatter.heading(1, 2)+\
                      _("Content")+\
                      request.formatter.heading(0, 2))

        request.write(request.formatter.heading(1, 3)+\
                      _("HTML")+\
                      request.formatter.heading(0, 3))
        request.write(''.join([\
            request.formatter.url(1,
                url = ''.join([\
                    url,
                    'contentzip&type=html',
                    request.form.get('files') and ('&files=%s' % request.form.get('files')[0]) or ''])),
            _("Content zip file"),
            request.formatter.url(0),
            request.formatter.linebreak(preformatted=0),
            request.formatter.linebreak(preformatted=0)]))
        for f in files:
            page_name, filename = AttachFile.absoluteName(f, pagename)
            request.write(''.join([\
                request.formatter.url(1, url = '%scontent&type=html&file=%s' % (url, f)),
                "%s/%s" % (page_name, filename),
                request.formatter.url(0),
                request.formatter.linebreak(preformatted=0)]))    

        request.write(request.formatter.heading(1, 3)+\
                      _("PHP")+\
                      request.formatter.heading(0, 3))
        request.write(''.join([\
            request.formatter.url(1,
                url = ''.join([\
                    url,
                    'contentzip&type=php',
                    request.form.get('files') and ('&files=%s' % request.form.get('files')[0]) or ''])),
            _("Content zip file"),
            request.formatter.url(0),
            request.formatter.linebreak(preformatted=0),
            request.formatter.linebreak(preformatted=0)]))
        for f in files:
            page_name, filename = AttachFile.absoluteName(f, pagename)
            request.write(''.join([\
                request.formatter.url(1, url = '%scontent&type=php&file=%s' % (url, f)),
                "%s/%s" % (page_name, filename),
                request.formatter.url(0),
                request.formatter.linebreak(preformatted=0)]))    

        request.write(request.formatter.endContent())
        wikiutil.send_footer(request, pagename, editor_mode=1)
        return
    elif do == 'inc':
        prefix = request.form.get("prefix", [''])[0]

        content = ''
        for f in files:
            page_name, filename = AttachFile.absoluteName(f, pagename)
            content += "$pages['%(key)s'] = '%(value)s';\n" % \
                       {'key': "%s%s_%s" % (prefix, wikiutil.quoteWikinameFS(page_name), wikiutil.quoteWikinameFS(filename)),
                        'value': "%s%s_%s.php" % (prefix, wikiutil.quoteWikinameFS(page_name), wikiutil.quoteWikinameFS(filename))}
        content += "\n$pages['%(key)s'] = '%(value)s';\n" % \
                   {'key': "%s" % pagename,
                    'value': "%s.php" % wikiutil.quoteWikinameFS(pagename)}
        content = "<?php\n%s?>" % content

        import cStringIO
        content = cStringIO.StringIO(content)
        send_openfile(request, content, "pagelist_%s.inc" % wikiutil.quoteWikinameFS(pagename), "text/plain", "attachment")
        content.close()
        if MoinMoinNoFooter is None:
            return
        raise MoinMoinNoFooter
    elif do == 'php':
        try:
            index = int(request.form.get("index", ['0'])[0])
        except:
            index = 0

        prefix = request.form.get("prefix", [''])[0]

        content = ''
        for f in files:
            page_name, filename = AttachFile.absoluteName(f, pagename)
            content += "\tarray('%(image)s', '%(alt)s', '%(page)s', '%(thumb)s'),\n" % \
                       {'image': "%simages/%s_%s" % (prefix, wikiutil.quoteWikinameFS(page_name), filename),
                        'alt': "%s/%s" % (page_name, filename),
                        'page': "%s%s_%s" % (prefix, wikiutil.quoteWikinameFS(page_name), wikiutil.quoteWikinameFS(filename)),
                        'thumb': "%sthumbnails/%s_%s" % (prefix, wikiutil.quoteWikinameFS(page_name), filename)}

        content = PHPWrapper % \
                  {'includes': 'include_once "inc/ImageBrowser.inc";',
                   'content': "imgbrwsr_content(%d, array(\n%s))" % (index, content),
                   'title': '%s: ImageBrowser' % pagename}

        import cStringIO
        content = cStringIO.StringIO(content)
        send_openfile(request, content, "%s.php" % wikiutil.quoteWikinameFS(pagename), "text/plain", "attachment")
        content.close()
        if MoinMoinNoFooter is None:
            return
        raise MoinMoinNoFooter
    elif do == 'js':
        # TODO: change this so it's actually usefull...
        import cStringIO
        content = cStringIO.StringIO(ImageBrowserContent.imgbrswrscript)
        send_openfile(request, content, "imagebrowser.js", "text/plain", "attachment")
        content.close()
        if MoinMoinNoFooter is None:
            return
        raise MoinMoinNoFooter
    elif do == 'html':
        # TODO: change this so it's actually usefull...
        index = request.form.get("index", [0])[0]

        request.formatter.page = page
        args="%d,%s" % (index, ','.join(files))
        from MoinMoin import wikimacro
        from MoinMoin.parser.wiki import Parser
        macro = wikimacro.Macro(Parser('', request))
        content = request.formatter.macro(macro, "ImageBrowserContent", args)

        import cStringIO
        content = cStringIO.StringIO(content)
        send_openfile(request, content, "imagebrowser_%s.html" % wikiutil.quoteWikinameFS(pagename), "text/plain", "attachment")
        content.close()
        if MoinMoinNoFooter is None:
            return
        raise MoinMoinNoFooter
    elif do == 'content':
        f = request.form.get("file", [None])[0]
        if f is None:
            index = request.form.get("index", [None])[0]
            if index is None:
                page.send_page(request, msg = _("'file' or 'index' parameter required for 'content' function."))
                return
            f = files[index]
        ftype = request.form.get("type", ["html"])[0]
        request.formatter.page = page
        page_name, filename = AttachFile.absoluteName(f, pagename)
        import cStringIO
        content = cStringIO.StringIO(getContent(request, page_name, filename, ftype))
        send_openfile(request, content, "%s_%s.%s" % (wikiutil.quoteWikinameFS(page_name), wikiutil.quoteWikinameFS(filename), ftype), "text/plain", "attachment")
        content.close()
        if MoinMoinNoFooter is None:
            return
        raise MoinMoinNoFooter
    elif do == 'contentzip':
        ftype = request.form.get("type", ["html"])[0]
        request.formatter.page = page

        import cStringIO
        filelist = []
        for f in files:
            page_name, filename = AttachFile.absoluteName(f, pagename)
            filelist.append([cStringIO.StringIO(getContent(request, page_name, filename, ftype)), "%s_%s.%s" % (wikiutil.quoteWikinameFS(page_name), wikiutil.quoteWikinameFS(filename), ftype)])
        
        import tempfile
        tmp = tempfile.TemporaryFile()
        zip_files(tmp, filelist)
        tmp.flush()

        send_openfile(request, tmp, "%s_imgbrwsr_content.zip" % wikiutil.quoteWikinameFS(pagename), "application/zip", "attachment")
        tmp.close()

        for f in filelist:
            f[0].close()

        if MoinMoinNoFooter is None:
            return
        raise MoinMoinNoFooter
    elif do == 'imgzip':
        filelist = []
        for f in files:
            page_name, filename = AttachFile.absoluteName(f, pagename)
            filelist.append([AttachFile.getFilename(request, page_name, filename), "images/%s_%s" % (wikiutil.quoteWikinameFS(page_name), filename)])

        import tempfile
        tmp = tempfile.TemporaryFile()
        zip_files(tmp, filelist)
        tmp.flush()

        send_openfile(request, tmp, "%s_imgbrwsr_images.zip" % wikiutil.quoteWikinameFS(pagename), "application/zip", "attachment")
        tmp.close()

        if MoinMoinNoFooter is None:
            return
        raise MoinMoinNoFooter
    elif do == 'thmbzip':
        if Thumbnail is None:
            page.send_page(request, msg = _("This function requires the Thumbnail action."))
            return

        filelist = []
        for f in files:
            page_name, filename = AttachFile.absoluteName(f, pagename)
            filelist.append([Thumbnail.getThumbnailPath(request, page_name, filename, 320, 240), "thumbnails/%s_%s" % (wikiutil.quoteWikinameFS(page_name), filename)])

        import tempfile
        tmp = tempfile.TemporaryFile()
        zip_files(tmp, filelist)
        tmp.flush()

        send_openfile(request, tmp, "%s_imgbrwsr_thumbnails.zip" % wikiutil.quoteWikinameFS(pagename), "application/zip", "attachment")
        tmp.close()

        if MoinMoinNoFooter is None:
            return
        raise MoinMoinNoFooter

    page.send_page(request, msg = _("Not implemented"))
    return
