# -*- coding: iso-8859-1 -*-
"""
    MoinMoin - ImageBrowser Macro
    Version 0.1

    An image browser.
    
    [[ImageBrowser(index, file0, file1, ...)]]
    [[ImageBrowser(file0, file1, ...)]]
    [[ImageBrowser(index)]]
    [[ImageBrowser]]

    Where index is the 0 based index of the image to show by default, and
          file0, file1, ... are the images to display

    If omitted, index defaults to 0 (the first image) and file0, file1, ...
    defaults to all image attachments on the current page.

    Comment line 99 and uncomment 100 if you don't want to use the Thumbnail
    action (Javascript comment, not Python).

    @copyright: 2007 by Kenneth Bull
    @license: GNU GPL, see COPYING for details.

"""

def parseArgs(args):
    if args == None:
        return []
    params = [""]
    quote = ""
    i = 0
    while i < len(args):
        c = args[i]
        if quote == "":
            if ((c == '"') or (c == "'")) and (params[-1] == ""):
                quote = c
                params[-1] = ""
            elif c == ',':
                params.append("")
            elif (c != ' ') or (params[-1] != ""):
                params[-1] += c
        else:
            if c == quote:
                quote = ""
            else:
                params[-1] += c
        i += 1
    return params

def getImageList(request, pagename):
    from MoinMoin.action.AttachFile import _get_files, getFilename
    import os, mimetypes
    files = _get_files(request, pagename)
    imgs = []
    for f in files:
        if os.path.isfile(getFilename(request, pagename, f)) and (str(mimetypes.guess_type(f)[0])[:5] == "image"):
            imgs.append(f)
    return imgs

imgbrswrscript = r"""
<script type="text/javascript">
	function imgbrwsr_update()  {
		this.updateimages();

		if (this.index == 0)	{
			document.getElementById("imgbrwsr"+this.id+"_frst").style.display = "none";
			document.getElementById("imgbrwsr"+this.id+"_back").style.display = "none";
		} else {
			document.getElementById("imgbrwsr"+this.id+"_frst").style.display = "block";
			document.getElementById("imgbrwsr"+this.id+"_back").style.display = "block";
		}
		if (this.index == this.images.length - 1)	{
			document.getElementById("imgbrwsr"+this.id+"_next").style.display = "none";
			document.getElementById("imgbrwsr"+this.id+"_last").style.display = "none";
		} else {
			document.getElementById("imgbrwsr"+this.id+"_next").style.display = "block";
			document.getElementById("imgbrwsr"+this.id+"_last").style.display = "block";
		}
	}
	function imgbrwsr_goto(imgno)	{
		while (imgno < 0)
			imgno += this.images.length;
		if (imgno >= this.images.length)
			imgno %= this.images.length;
		this.index = imgno;
		this.update();
	}
	function imgbrwsr_offset(off)	{
		this.go(this.index+off);
	}
	function imgbrwsr_updateimages()	{
		var r = document.getElementById("imgbrwsr"+this.id).getElementsByTagName('div')[0];
		while (n = r.firstChild)
			r.removeChild(n);

		for (i = 0; i < this.images.length; ++i)	{
   			var img = document.createElement("img");
   			img.src = this.images[i][0]+"?action=Thumbnail&w=320&h=240&target="+this.images[i][1];
//   			img.src = this.images[i][0]+"?action=AttachFile&do=get&target="+this.images[i][1];
   			img.alt = this.images[i][2];
   			img.style.width = "320px";
			img.style.height = "240px";
			img.style.border = "none";

			var a = document.createElement("a");
			a.href = this.images[i][0]+"?action=AttachFile&do=get&target="+this.images[i][1];
			a.title = this.images[i][2];
			a.style.display = (i == this.index)? "block": "none";

			r.appendChild(a);
			a.appendChild(img);
		}
	}
	function imgbrwsr_render()	{
		document.write("<div id='imgbrwsr"+this.id+"' style='width:358px; height:312px; position:relative; background:url(/wiki/common/imgbrwsr/frame.png);'>\n");
		document.write("\t<div style='position:absolute; left:19px; top:20px;'></div>\n");
		document.write("\t<a id='imgbrwsr"+this.id+"_frst' href='javascript:imgbrwsrs["+this.id+"].go(0);'      style='position:absolute; left: 11px; top:266px; display:none;'><img src='/wiki/common/imgbrwsr/first.png' style='border:none;' alt='first' /></a>\n");
		document.write("\t<a id='imgbrwsr"+this.id+"_back' href='javascript:imgbrwsrs["+this.id+"].offset(-1);' style='position:absolute; left: 55px; top:266px; display:none;'><img src='/wiki/common/imgbrwsr/back.png'  style='border:none;' alt='back'  /></a>\n");
		document.write("\t<a id='imgbrwsr"+this.id+"_next' href='javascript:imgbrwsrs["+this.id+"].offset( 1);' style='position:absolute; left:271px; top:266px; display:none;'><img src='/wiki/common/imgbrwsr/next.png'  style='border:none;' alt='next'  /></a>\n");
		document.write("\t<a id='imgbrwsr"+this.id+"_last' href='javascript:imgbrwsrs["+this.id+"].go(-1);'     style='position:absolute; left:303px; top:266px; display:none;'><img src='/wiki/common/imgbrwsr/last.png'  style='border:none;' alt='last'  /></a>\n");
		document.write("</div>");
		this.update();
	}
	var imgbrwsrs = new Array();
	function imgbrwsr(ndx, imgs)   {
		this.id		= imgbrwsrs.length;
		this.index	= ndx;
		this.images	= imgs;
		this.render	= imgbrwsr_render;
		this.updateimages = imgbrwsr_updateimages;
		this.go		= imgbrwsr_goto;
		this.offset	= imgbrwsr_offset;
		this.update	= imgbrwsr_update;
		imgbrwsrs[imgbrwsrs.length] = this;
	}
</script>
"""

def execute(macro, args):
    from MoinMoin.action import AttachFile

    try:
        macro.formatter._imgbrwsr_js
        output = ""
    except:
        output = imgbrswrscript
        macro.formatter._imgbrwsr_js = 1

    p = parseArgs(args)
    try:
        ndx = int(p[0])
        p.pop(0)
    except:
        ndx = 0

    if len(p) == 0:
        p = getImageList(macro.request, macro.formatter.page.page_name)

    i = 0
    output += "<script type='text/javascript'>\n\t(new imgbrwsr(%d, new Array(" % ndx
    for f in p:
        pagename, filename = AttachFile.absoluteName(f, macro.formatter.page.page_name)
        if i > 0:
            output += ", "
        output += "new Array('%s', '%s', '%s')" % (pagename, filename, f)
        i += 1
    output += "))).render();\n</script>"
    return macro.formatter.rawHTML(output)
