/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class JavaNumberFormatter
extends DefaultFormatter {
    private double scaleFactor = 1.0;
    private boolean allowsNullValue = false;
    private Comparable min;
    private Comparable max;
    private boolean appendsDotZero = true;

    public JavaNumberFormatter() {
    }

    public JavaNumberFormatter(double min, double max, double scaleFactor) {
        this(min, max, scaleFactor, false, true);
    }

    public JavaNumberFormatter(double min, double max, double scaleFactor, boolean allowsNullValue, boolean appendsDotZero) {
        this.setMinimum(Double.valueOf(min));
        this.setMaximum(Double.valueOf(max));
        this.setScaleFactor(scaleFactor);
        this.setAllowsNullValue(allowsNullValue);
        this.setAppendsDotZero(appendsDotZero);
        this.setOverwriteMode(false);
    }

    public void setMinimum(Comparable minimum) {
        if (this.getValueClass() == null && minimum != null) {
            this.setValueClass(minimum.getClass());
        }
        this.min = minimum;
    }

    public Comparable getMinimum() {
        return this.min;
    }

    public void setMaximum(Comparable max) {
        if (this.getValueClass() == null && max != null) {
            this.setValueClass(max.getClass());
        }
        this.max = max;
    }

    public Comparable getMaximum() {
        return this.max;
    }

    public void setScaleFactor(double newValue) {
        this.scaleFactor = newValue;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setAllowsNullValue(boolean newValue) {
        this.allowsNullValue = newValue;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    public void setAppendsDotZero(boolean newValue) {
        this.appendsDotZero = newValue;
    }

    public boolean getAppendsDotZero() {
        return this.appendsDotZero;
    }

    public String valueToString(Object value) throws ParseException {
        if (value == null && this.allowsNullValue) {
            return "";
        }
        if (value instanceof Double) {
            double v = (Double)value;
            String str = Double.toString(v *= this.scaleFactor);
            if (!this.appendsDotZero && str.endsWith(".0")) {
                str = str.substring(0, str.length() - 2);
            }
            return str;
        }
        if (value instanceof Float) {
            float v = ((Float)value).floatValue();
            v = (float)((double)v * this.scaleFactor);
            String str = Float.toString(v);
            if (this.appendsDotZero && str.endsWith(".0")) {
                str = str.substring(0, str.length() - 2);
            }
            return str;
        }
        if (value instanceof Long) {
            long v = (Long)value;
            v = (long)((double)v * this.scaleFactor);
            return Long.toString(v);
        }
        if (value instanceof Integer) {
            int v = (Integer)value;
            v = (int)((double)v * this.scaleFactor);
            return Integer.toString(v);
        }
        if (value instanceof Byte) {
            byte v = (Byte)value;
            v = (byte)((double)v * this.scaleFactor);
            return Byte.toString(v);
        }
        if (value instanceof Short) {
            short v = (Short)value;
            v = (short)((double)v * this.scaleFactor);
            return Short.toString(v);
        }
        throw new ParseException("Value is of unsupported class " + value, 0);
    }

    public Object stringToValue(String text) throws ParseException {
        Number value;
        if ((text == null || text.length() == 0) && this.getAllowsNullValue()) {
            return null;
        }
        Class<?> valueClass = this.getValueClass();
        if (valueClass != null) {
            try {
                if (valueClass == Integer.class) {
                    int v = Integer.parseInt(text);
                    v = (int)((double)v / this.scaleFactor);
                    value = new Integer(v);
                }
                if (valueClass == Long.class) {
                    long v = Long.parseLong(text);
                    v = (long)((double)v / this.scaleFactor);
                    value = new Long(v);
                }
                if (valueClass == Float.class) {
                    float v = Float.parseFloat(text);
                    v = (float)((double)v / this.scaleFactor);
                    value = new Float(v);
                }
                if (valueClass == Double.class) {
                    double v = Double.parseDouble(text);
                    value = new Double(v /= this.scaleFactor);
                }
                if (valueClass == Byte.class) {
                    byte v = Byte.parseByte(text);
                    v = (byte)((double)v / this.scaleFactor);
                    value = new Byte(v);
                }
                if (valueClass == Short.class) {
                    short v = Short.parseShort(text);
                    v = (short)((double)v / this.scaleFactor);
                    value = new Short(v);
                }
                throw new ParseException("Unsupported value class " + valueClass, 0);
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        } else {
            throw new ParseException("Unsupported value class " + valueClass, 0);
        }
        try {
            if (!this.isValidValue(value, true)) {
                throw new ParseException("Value not within min/max range", 0);
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Class cast exception comparing values: " + cce, 0);
        }
        return value;
    }

    boolean isValidValue(Object value, boolean wantsCCE) {
        Comparable min = this.getMinimum();
        try {
            if (min != null && min.compareTo(value) > 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        Comparable max = this.getMaximum();
        try {
            if (max != null && max.compareTo(value) < 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        return true;
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(double min, double max, double scaleFactor) {
        return JavaNumberFormatter.createFormatterFactory(min, max, scaleFactor, false, false);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(double min, double max, double scaleFactor, boolean allowsNullValue, boolean appendsDotZero) {
        return new DefaultFormatterFactory(new JavaNumberFormatter(min, max, scaleFactor, allowsNullValue, appendsDotZero));
    }
}

