/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.text;

import java.awt.Color;
import java.text.ParseException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class ColorFormatter
extends DefaultFormatter {
    private Format outputFormat = Format.RGB_INTEGER;
    private Format lastUsedInputFormat = null;
    private static final Pattern rgbHexPattern = Pattern.compile("^\\s*#\\s*([0-9a-fA-F]{3,6})\\s*$");
    private static final Pattern rgbIntegerPattern = Pattern.compile("^\\s*([0-9]{1,3})\\s*,\\s*([0-9]{1,3}),\\s*([0-9]{1,3})\\s*$");
    private boolean allowsNullValue = true;
    private boolean isAdaptive = true;
    private Preferences prefs;

    public ColorFormatter() {
        this(Format.RGB_INTEGER, true, true);
    }

    public ColorFormatter(Format outputFormat, boolean allowsNullValue, boolean isAdaptive) {
        this.outputFormat = outputFormat;
        this.allowsNullValue = allowsNullValue;
        this.isAdaptive = isAdaptive;
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        try {
            this.lastUsedInputFormat = Format.valueOf(this.prefs.get("ColorFormatter.lastUsedInputFormat", Format.RGB_HEX.name()));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (isAdaptive && this.lastUsedInputFormat != null) {
            this.outputFormat = this.lastUsedInputFormat;
        }
        this.setOverwriteMode(false);
    }

    public void setOutputFormat(Format newValue) {
        if (newValue == null) {
            throw new NullPointerException("outputFormat may not be null");
        }
        this.outputFormat = newValue;
    }

    public Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format getLastUsedInputFormat() {
        return this.lastUsedInputFormat;
    }

    public void setAllowsNullValue(boolean newValue) {
        this.allowsNullValue = newValue;
    }

    public boolean getAllowsNullValue() {
        return this.allowsNullValue;
    }

    public void setAdaptive(boolean newValue) {
        this.isAdaptive = newValue;
        if (newValue && this.lastUsedInputFormat != null) {
            this.outputFormat = this.lastUsedInputFormat;
        }
    }

    public boolean isAdaptive() {
        return this.isAdaptive;
    }

    private void setLastUsedInputFormat(Format newValue) {
        this.lastUsedInputFormat = newValue;
        if (this.isAdaptive) {
            this.outputFormat = this.lastUsedInputFormat;
        }
        this.prefs.put("ColorFormatter.lastUsedInputFormat", newValue.name());
    }

    public Object stringToValue(String str) throws ParseException {
        if (str == null || str.trim().length() == 0) {
            if (this.allowsNullValue) {
                return null;
            }
            throw new ParseException("Null value is not allowed.", 0);
        }
        Matcher matcher = rgbHexPattern.matcher(str);
        if (matcher.matches()) {
            this.setLastUsedInputFormat(Format.RGB_HEX);
            try {
                String group1 = matcher.group(1);
                if (group1.length() == 3) {
                    return new Color(Integer.parseInt("" + group1.charAt(0) + group1.charAt(0) + group1.charAt(1) + group1.charAt(1) + group1.charAt(2) + group1.charAt(2), 16));
                }
                if (group1.length() == 6) {
                    return new Color(Integer.parseInt(group1, 16));
                }
                throw new ParseException("Hex color must have 3 or 6 digits.", 1);
            }
            catch (NumberFormatException nfe) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(nfe);
                throw pe;
            }
        }
        matcher = rgbIntegerPattern.matcher(str);
        if (matcher.matches()) {
            this.setLastUsedInputFormat(Format.RGB_INTEGER);
            try {
                return new Color(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
            }
            catch (NumberFormatException nfe) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(nfe);
                throw pe;
            }
            catch (IllegalArgumentException iae) {
                ParseException pe = new ParseException(str, 0);
                pe.initCause(iae);
                throw pe;
            }
        }
        throw new ParseException(str, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String valueToString(Object value) throws ParseException {
        String str = null;
        if (value == null) {
            if (!this.allowsNullValue) throw new ParseException("Null value is not allowed.", 0);
            return "";
        }
        if (!(value instanceof Color)) {
            throw new ParseException("Value is not a color " + value, 0);
        }
        Color c = (Color)value;
        switch (this.outputFormat) {
            case RGB_HEX: {
                str = "000000" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
                return "#" + str.substring(str.length() - 6);
            }
            case RGB_INTEGER: {
                return c.getRed() + "," + c.getGreen() + "," + c.getBlue();
            }
        }
        return str;
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory() {
        return ColorFormatter.createFormatterFactory(Format.RGB_INTEGER, true, true);
    }

    public static JFormattedTextField.AbstractFormatterFactory createFormatterFactory(Format outputFormat, boolean allowsNullValue, boolean isAdaptive) {
        return new DefaultFormatterFactory(new ColorFormatter(outputFormat, allowsNullValue, isAdaptive));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        RGB_HEX,
        RGB_INTEGER;

    }
}

