/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.TextUI;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.gui.FigureAttributeEditorHandler;
import org.jhotdraw.gui.JAttributeTextArea;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteLabelUI;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.samples.svg.gui.SelectionComponentDisplayer;
import org.jhotdraw.util.ResourceBundleUtil;

public class LinkToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");

    public LinkToolBar() {
        this.setName(this.labels.getString(this.getID() + ".toolbar"));
        this.setDisclosureStateCount(3);
    }

    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(newValue);
        if (newValue != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
        }
    }

    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                p = new JPanel();
                p.setOpaque(false);
                p.setLayout(new GridBagLayout());
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                JLabel linkLabel = new JLabel();
                linkLabel.setUI((LabelUI)PaletteLabelUI.createUI(linkLabel));
                linkLabel.setToolTipText(this.labels.getString("attribute.figureLink.toolTipText"));
                linkLabel.setText(this.labels.getString("attribute.figureLink.text"));
                linkLabel.setFont(PaletteLookAndFeel.getInstance().getFont("SmallSystemFont"));
                JScrollPane scrollPane = new JScrollPane();
                JAttributeTextArea linkField = new JAttributeTextArea();
                linkLabel.setLabelFor(linkField);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.insets = new Insets(-2, 0, -2, 0);
                gbc.anchor = 16;
                gbc.gridwidth = 0;
                p.add((Component)linkLabel, gbc);
                scrollPane.setHorizontalScrollBarPolicy(31);
                scrollPane.setVerticalScrollBarPolicy(20);
                scrollPane.putClientProperty("JComponent.sizeVariant", "small");
                scrollPane.setBorder(PaletteLookAndFeel.getInstance().getBorder("ScrollPane.border"));
                linkField.setToolTipText(this.labels.getString("attribute.figureLink.toolTipText"));
                linkField.setColumns(8);
                linkField.setLineWrap(true);
                linkField.setRows(2);
                linkField.setWrapStyleWord(true);
                linkField.setFont(PaletteLookAndFeel.getInstance().getFont("SmallSystemFont"));
                linkField.setFormatterFactory(new DefaultFormatterFactory(new DefaultFormatter()));
                new FigureAttributeEditorHandler<String>(SVGAttributeKeys.LINK, linkField, this.editor, false);
                scrollPane.setViewportView(linkField);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.fill = 1;
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                p.add((Component)scrollPane, gbc);
                JLabel targetLabel = new JLabel();
                targetLabel.setUI((LabelUI)PaletteLabelUI.createUI(targetLabel));
                targetLabel.setToolTipText(this.labels.getString("attribute.figureLinkTarget.toolTipText"));
                targetLabel.setText(this.labels.getString("attribute.figureLinkTarget.text"));
                JAttributeTextField targetField = new JAttributeTextField();
                targetLabel.setLabelFor(targetField);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.fill = 1;
                gbc.anchor = 23;
                p.add((Component)targetLabel, gbc);
                targetField.setToolTipText(this.labels.getString("attribute.figureLinkTarget.toolTipText"));
                targetField.setColumns(4);
                targetField.setFormatterFactory(new DefaultFormatterFactory(new DefaultFormatter()));
                targetField.setUI((TextUI)PaletteFormattedTextFieldUI.createUI(targetField));
                new FigureAttributeEditorHandler<String>(SVGAttributeKeys.LINK_TARGET, targetField, this.editor, false);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 3, 0, 0);
                gbc.fill = 2;
                gbc.gridwidth = 0;
                gbc.anchor = 23;
                p.add(targetField, gbc);
                break;
            }
            case 2: {
                p = new JPanel();
                p.setOpaque(false);
                p.setLayout(new GridBagLayout());
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                JScrollPane scrollPane = new JScrollPane();
                JAttributeTextArea linkField = new JAttributeTextArea();
                scrollPane.setHorizontalScrollBarPolicy(31);
                scrollPane.setVerticalScrollBarPolicy(20);
                scrollPane.putClientProperty("JComponent.sizeVariant", "small");
                scrollPane.setBorder(PaletteLookAndFeel.getInstance().getBorder("ScrollPane.border"));
                linkField.setToolTipText(this.labels.getString("attribute.figureLink.toolTipText"));
                linkField.setColumns(12);
                linkField.setLineWrap(true);
                linkField.setRows(2);
                linkField.setWrapStyleWord(true);
                linkField.setFont(PaletteLookAndFeel.getInstance().getFont("SmallSystemFont"));
                linkField.setFormatterFactory(new DefaultFormatterFactory(new DefaultFormatter()));
                new FigureAttributeEditorHandler<String>(SVGAttributeKeys.LINK, linkField, this.editor, false);
                scrollPane.setViewportView(linkField);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(0, 0, 0, 0);
                gbc.fill = 1;
                gbc.gridwidth = 0;
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                p.add((Component)scrollPane, gbc);
                JLabel targetLabel = new JLabel();
                targetLabel.setUI((LabelUI)PaletteLabelUI.createUI(targetLabel));
                targetLabel.setToolTipText(this.labels.getString("attribute.figureLinkTarget.toolTipText"));
                targetLabel.setText(this.labels.getString("attribute.figureLinkTarget.text"));
                JAttributeTextField targetField = new JAttributeTextField();
                targetLabel.setLabelFor(targetField);
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                gbc.fill = 1;
                gbc.anchor = 23;
                p.add((Component)targetLabel, gbc);
                targetField.setToolTipText(this.labels.getString("attribute.figureLinkTarget.toolTipText"));
                targetField.setColumns(7);
                targetField.setFormatterFactory(new DefaultFormatterFactory(new DefaultFormatter()));
                targetField.setUI((TextUI)PaletteFormattedTextFieldUI.createUI(targetField));
                new FigureAttributeEditorHandler<String>(SVGAttributeKeys.LINK_TARGET, targetField, this.editor, true);
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 3, 0, 0);
                gbc.fill = 2;
                gbc.gridwidth = 0;
                gbc.anchor = 23;
                p.add(targetField, gbc);
            }
        }
        return p;
    }

    protected String getID() {
        return "link";
    }

    private void initComponents() {
    }
}

