/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.app.action.ClearSelectionAction;
import org.jhotdraw.app.action.CopyAction;
import org.jhotdraw.app.action.CutAction;
import org.jhotdraw.app.action.DuplicateAction;
import org.jhotdraw.app.action.PasteAction;
import org.jhotdraw.app.action.SelectAllAction;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.SelectSameAction;
import org.jhotdraw.draw.action.ToggleGridAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.undo.UndoRedoManager;
import org.jhotdraw.util.ResourceBundleUtil;

public class ActionsToolBar
extends AbstractToolBar {
    private ToggleGridAction toggleGridAction;
    private UndoRedoManager undoManager;

    public ActionsToolBar() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(labels.getString(this.getID() + ".toolbar"));
    }

    public void setEditor(DrawingEditor newValue) {
        if (this.editor != null && this.undoManager != null) {
            this.removePropertyChangeListener(this.getEventHandler());
        }
        this.editor = newValue;
        if (this.editor != null && this.undoManager != null) {
            this.init();
            this.setDisclosureState(this.prefs.getInt(this.getID() + ".disclosureState", 1));
            this.addPropertyChangeListener(this.getEventHandler());
        }
    }

    public void setUndoManager(UndoRedoManager newValue) {
        if (this.editor != null && newValue != null) {
            this.removePropertyChangeListener(this.getEventHandler());
        }
        this.undoManager = newValue;
        if (this.editor != null && newValue != null) {
            this.init();
            this.setDisclosureState(this.prefs.getInt(this.getID() + ".disclosureState", 1));
            this.addPropertyChangeListener(this.getEventHandler());
        }
    }

    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                p = new JPanel();
                p.setOpaque(false);
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                Preferences prefs = Preferences.userNodeForPackage(this.getClass());
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                JButton btn = new JButton(this.undoManager.getUndoAction());
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.setText(null);
                labels.configureToolBarButton(btn, "edit.undo");
                btn.putClientProperty("hideActionText", Boolean.TRUE);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.gridx = 0;
                p.add((Component)btn, gbc);
                btn = new JButton(this.undoManager.getRedoAction());
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.setText(null);
                labels.configureToolBarButton(btn, "edit.redo");
                btn.putClientProperty("hideActionText", Boolean.TRUE);
                gbc = new GridBagConstraints();
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 3, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createPickAttributesButton(this.editor);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                labels.configureToolBarButton(btn, "attributesPick");
                gbc = new GridBagConstraints();
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)btn, gbc);
                btn = ButtonFactory.createApplyAttributesButton(this.editor);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                labels.configureToolBarButton(btn, "attributesApply");
                gbc = new GridBagConstraints();
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add((Component)btn, gbc);
                JPopupButton pb = new JPopupButton();
                pb.setUI((PaletteButtonUI)PaletteButtonUI.createUI(pb));
                pb.setItemFont(UIManager.getFont("MenuItem.font"));
                labels.configureToolBarButton(pb, "actions");
                pb.add(new DuplicateAction());
                pb.addSeparator();
                pb.add(new GroupAction(this.editor, new SVGGroupFigure()));
                pb.add(new UngroupAction(this.editor, new SVGGroupFigure()));
                pb.addSeparator();
                pb.add(new CutAction());
                pb.add(new CopyAction());
                pb.add(new PasteAction());
                pb.add(new SelectAllAction());
                pb.add(new SelectSameAction(this.editor));
                pb.add(new ClearSelectionAction());
                gbc = new GridBagConstraints();
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)pb, gbc);
                break;
            }
        }
        return p;
    }

    public ToggleGridAction getToggleGridAction() {
        return this.toggleGridAction;
    }

    private void initComponents() {
    }

    protected String getID() {
        return "actions";
    }

    protected int getDefaultDisclosureState() {
        return 1;
    }
}

