/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.gui.JDisclosureToolBar;

public class AbstractToolBar
extends JDisclosureToolBar {
    protected DrawingEditor editor;
    private JComponent[] panels;
    protected Preferences prefs;
    protected PropertyChangeListener eventHandler;

    public AbstractToolBar() {
        this.initComponents();
        try {
            this.prefs = Preferences.userNodeForPackage(this.getClass());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected String getID() {
        return "";
    }

    protected void init() {
    }

    protected PropertyChangeListener getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String name = evt.getPropertyName();
                    if (name == "disclosureState") {
                        try {
                            AbstractToolBar.this.prefs.putInt(AbstractToolBar.this.getID() + ".disclosureState", (Integer)evt.getNewValue());
                        }
                        catch (IllegalStateException e) {
                            System.err.println("Warning AbstractToolBar caught IllegalStateException of Preferences class");
                            e.printStackTrace();
                        }
                    }
                }
            };
        }
        return this.eventHandler;
    }

    public void setEditor(DrawingEditor editor) {
        if (this.editor != null) {
            this.removePropertyChangeListener(this.getEventHandler());
        }
        this.editor = editor;
        if (editor != null) {
            this.init();
            this.setDisclosureState(Math.max(0, Math.min(this.getDisclosureStateCount(), this.prefs.getInt(this.getID() + ".disclosureState", this.getDefaultDisclosureState()))));
            this.addPropertyChangeListener(this.getEventHandler());
        }
    }

    public DrawingEditor getEditor() {
        return this.editor;
    }

    protected final JComponent getDisclosedComponent(int state) {
        if (this.panels == null) {
            this.panels = new JPanel[this.getDisclosureStateCount()];
            for (int i = 0; i < this.panels.length; ++i) {
                this.panels[i] = new ProxyPanel();
            }
        }
        return this.panels[state];
    }

    protected JComponent createDisclosedComponent(int state) {
        return null;
    }

    protected int getDefaultDisclosureState() {
        return 0;
    }

    private void initComponents() {
    }

    private class ProxyPanel
    extends JPanel {
        private Runnable runner;

        public ProxyPanel() {
            this.setOpaque(false);
            this.setBackground(Color.GREEN);
            this.setLayout(new FlowLayout(0, 1, 1));
        }

        public void paint(Graphics g) {
            super.paint(g);
            final int state = AbstractToolBar.this.getDisclosureState();
            if (this.runner == null) {
                this.runner = new Runnable(){

                    public void run() {
                        try {
                            ((AbstractToolBar)AbstractToolBar.this).panels[state] = AbstractToolBar.this.createDisclosedComponent(state);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            ((AbstractToolBar)AbstractToolBar.this).panels[state] = null;
                        }
                        JComponent parent = (JComponent)ProxyPanel.this.getParent();
                        if (parent != null) {
                            GridBagLayout layout = (GridBagLayout)parent.getLayout();
                            GridBagConstraints gbc = layout.getConstraints(ProxyPanel.this);
                            parent.remove(ProxyPanel.this);
                            if (AbstractToolBar.this.getDisclosureState() == state) {
                                if (AbstractToolBar.this.panels[state] != null) {
                                    parent.add((Component)AbstractToolBar.this.panels[state], gbc);
                                } else {
                                    JPanel empty = new JPanel(new BorderLayout());
                                    empty.setOpaque(false);
                                    parent.add((Component)empty, gbc);
                                }
                            }
                            parent.revalidate();
                            ((JComponent)parent.getRootPane().getContentPane()).revalidate();
                        }
                    }
                };
                SwingUtilities.invokeLater(this.runner);
            }
        }
    }
}

