/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.BoundsOutlineHandle;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Connector;
import org.jhotdraw.draw.FontSizeHandle;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.MoveHandle;
import org.jhotdraw.draw.RelativeLocator;
import org.jhotdraw.draw.TextEditingTool;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.TransformHandleKit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.samples.svg.Gradient;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.LinkHandle;
import org.jhotdraw.samples.svg.figures.SVGAttributedFigure;
import org.jhotdraw.samples.svg.figures.SVGFigure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGTextFigure
extends SVGAttributedFigure
implements TextHolderFigure,
SVGFigure {
    protected Point2D.Double[] coordinates = new Point2D.Double[]{new Point2D.Double()};
    protected double[] rotates = new double[]{0.0};
    private boolean editable = true;
    private transient Shape cachedTextShape;
    private transient Rectangle2D.Double cachedBounds;
    private transient Rectangle2D.Double cachedDrawingArea;

    public SVGTextFigure() {
        this("Text");
    }

    public SVGTextFigure(String text) {
        this.setText(text);
        SVGAttributeKeys.setDefaults(this);
    }

    @Override
    protected void drawText(Graphics2D g) {
    }

    @Override
    protected void drawFill(Graphics2D g) {
        g.fill(this.getTextShape());
    }

    @Override
    protected void drawStroke(Graphics2D g) {
        g.draw(this.getTextShape());
    }

    public void setCoordinates(Point2D.Double[] coordinates) {
        this.coordinates = coordinates;
        this.invalidate();
    }

    public Point2D.Double[] getCoordinates() {
        Point2D.Double[] c = new Point2D.Double[this.coordinates.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (Point2D.Double)this.coordinates[i].clone();
        }
        return c;
    }

    public void setRotates(double[] rotates) {
        this.rotates = rotates;
        this.invalidate();
    }

    public double[] getRotates() {
        return (double[])this.rotates.clone();
    }

    @Override
    public Rectangle2D.Double getBounds() {
        if (this.cachedBounds == null) {
            this.cachedBounds = new Rectangle2D.Double();
            this.cachedBounds.setRect(this.getTextShape().getBounds2D());
        }
        return (Rectangle2D.Double)this.cachedBounds.clone();
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D.Double rx = this.getBounds();
            Rectangle2D.Double r = rx instanceof Rectangle2D.Double ? rx : new Rectangle2D.Double(((RectangularShape)rx).getX(), ((RectangularShape)rx).getY(), ((RectangularShape)rx).getWidth(), ((RectangularShape)rx).getHeight());
            double g = SVGAttributeKeys.getPerpendicularHitGrowth(this);
            Geom.grow(r, g, g);
            if (AttributeKeys.TRANSFORM.get(this) == null) {
                this.cachedDrawingArea = r;
            } else {
                this.cachedDrawingArea = new Rectangle2D.Double();
                this.cachedDrawingArea.setRect(AttributeKeys.TRANSFORM.get(this).createTransformedShape(r).getBounds2D());
            }
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        if (AttributeKeys.TRANSFORM.get(this) != null) {
            try {
                p = (Point2D.Double)AttributeKeys.TRANSFORM.get(this).inverseTransform(p, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        return this.getTextShape().getBounds2D().contains(p);
    }

    private Shape getTextShape() {
        if (this.cachedTextShape == null) {
            String text = this.getText();
            if (text == null || text.length() == 0) {
                text = " ";
            }
            FontRenderContext frc = this.getFontRenderContext();
            HashMap<TextAttribute, Serializable> textAttributes = new HashMap<TextAttribute, Serializable>();
            textAttributes.put(TextAttribute.FONT, this.getFont());
            if (AttributeKeys.FONT_UNDERLINE.get(this).booleanValue()) {
                textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            TextLayout textLayout = new TextLayout(text, textAttributes, frc);
            AffineTransform tx = new AffineTransform();
            tx.translate(this.coordinates[0].x, this.coordinates[0].y);
            switch (SVGAttributeKeys.TEXT_ANCHOR.get(this)) {
                case END: {
                    tx.translate(-textLayout.getAdvance(), 0.0);
                    break;
                }
                case MIDDLE: {
                    tx.translate((double)(-textLayout.getAdvance()) / 2.0, 0.0);
                    break;
                }
            }
            tx.rotate(this.rotates[0]);
            this.cachedTextShape = tx.createTransformedShape(textLayout.getOutline(tx));
            this.cachedTextShape = textLayout.getOutline(tx);
        }
        return this.cachedTextShape;
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.coordinates = new Point2D.Double[]{new Point2D.Double(anchor.x, anchor.y)};
        this.rotates = new double[]{0.0};
    }

    @Override
    public void transform(AffineTransform tx) {
        if (AttributeKeys.TRANSFORM.get(this) != null || tx.getType() != (tx.getType() & 1)) {
            if (AttributeKeys.TRANSFORM.get(this) == null) {
                AttributeKeys.TRANSFORM.basicSet(this, (AffineTransform)tx.clone());
            } else {
                AffineTransform t = AttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                AttributeKeys.TRANSFORM.basicSet(this, t);
            }
        } else {
            for (int i = 0; i < this.coordinates.length; ++i) {
                tx.transform(this.coordinates[i], this.coordinates[i]);
            }
            if (SVGAttributeKeys.FILL_GRADIENT.get(this) != null && !SVGAttributeKeys.FILL_GRADIENT.get(this).isRelativeToFigureBounds()) {
                Gradient g = SVGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                SVGAttributeKeys.FILL_GRADIENT.basicSet(this, g);
            }
            if (SVGAttributeKeys.STROKE_GRADIENT.get(this) != null && !SVGAttributeKeys.STROKE_GRADIENT.get(this).isRelativeToFigureBounds()) {
                Gradient g = SVGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                SVGAttributeKeys.STROKE_GRADIENT.basicSet(this, g);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        Object[] restoreData = (Object[])geometry;
        AttributeKeys.TRANSFORM.basicSetClone(this, (AffineTransform)restoreData[0]);
        Point2D.Double[] restoredCoordinates = (Point2D.Double[])restoreData[1];
        for (int i = 0; i < this.coordinates.length; ++i) {
            this.coordinates[i] = (Point2D.Double)restoredCoordinates[i].clone();
        }
        SVGAttributeKeys.FILL_GRADIENT.basicSetClone(this, (Gradient)restoreData[2]);
        SVGAttributeKeys.STROKE_GRADIENT.basicSetClone(this, (Gradient)restoreData[3]);
        this.invalidate();
    }

    @Override
    public Object getTransformRestoreData() {
        Point2D.Double[] restoredCoordinates = (Point2D.Double[])this.coordinates.clone();
        for (int i = 0; i < this.coordinates.length; ++i) {
            restoredCoordinates[i] = (Point2D.Double)this.coordinates[i].clone();
        }
        return new Object[]{AttributeKeys.TRANSFORM.getClone(this), restoredCoordinates, SVGAttributeKeys.FILL_GRADIENT.getClone(this), SVGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public String getText() {
        return this.getAttribute(AttributeKeys.TEXT);
    }

    @Override
    public <T> void setAttribute(AttributeKey<T> key, T newValue) {
        if (key.equals(SVGAttributeKeys.TRANSFORM) || key.equals(SVGAttributeKeys.FONT_FACE) || key.equals(SVGAttributeKeys.FONT_BOLD) || key.equals(SVGAttributeKeys.FONT_ITALIC) || key.equals(SVGAttributeKeys.FONT_SIZE)) {
            this.invalidate();
        }
        super.setAttribute(key, newValue);
    }

    @Override
    public void setText(String newText) {
        AttributeKeys.TEXT.set(this, newText);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    @Override
    public int getTextColumns() {
        return 4;
    }

    @Override
    public Font getFont() {
        return SVGAttributeKeys.getFont(this);
    }

    @Override
    public Color getTextColor() {
        return AttributeKeys.FILL_COLOR.get(this);
    }

    @Override
    public Color getFillColor() {
        return AttributeKeys.FILL_COLOR.get(this) == null || AttributeKeys.FILL_COLOR.get(this).equals(Color.white) ? Color.black : Color.WHITE;
    }

    @Override
    public void setFontSize(float size) {
        Point2D.Double p = new Point2D.Double(0.0, size);
        AffineTransform tx = AttributeKeys.TRANSFORM.get(this);
        if (tx != null) {
            try {
                tx.inverseTransform(p, p);
                Point2D.Double p0 = new Point2D.Double(0.0, 0.0);
                tx.inverseTransform(p0, p0);
                p.y -= p0.y;
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        AttributeKeys.FONT_SIZE.set(this, (Double)Math.abs(p.y));
    }

    @Override
    public float getFontSize() {
        Point2D.Double p = new Point2D.Double(0.0, AttributeKeys.FONT_SIZE.get(this));
        AffineTransform tx = AttributeKeys.TRANSFORM.get(this);
        if (tx != null) {
            tx.transform(p, p);
            Point2D.Double p0 = new Point2D.Double(0.0, 0.0);
            tx.transform(p0, p0);
            p.y -= p0.y;
        }
        return (float)Math.abs(p.y);
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedTextShape = null;
        this.cachedBounds = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public Dimension2DDouble getPreferredSize() {
        Rectangle2D.Double b = this.getBounds();
        return new Dimension2DDouble(b.width, b.height);
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case -1: {
                handles.add(new BoundsOutlineHandle(this, false, true));
                break;
            }
            case 0: {
                handles.add(new BoundsOutlineHandle(this));
                handles.add(new MoveHandle(this, RelativeLocator.northWest()));
                handles.add(new MoveHandle(this, RelativeLocator.northEast()));
                handles.add(new MoveHandle(this, RelativeLocator.southWest()));
                handles.add(new MoveHandle(this, RelativeLocator.southEast()));
                handles.add(new FontSizeHandle(this));
                handles.add(new LinkHandle(this));
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
            }
        }
        return handles;
    }

    @Override
    public boolean canConnect() {
        return false;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return null;
    }

    @Override
    public Tool getTool(Point2D.Double p) {
        if (this.isEditable() && this.contains(p)) {
            TextEditingTool tool = new TextEditingTool(this);
            return tool;
        }
        return null;
    }

    @Override
    public double getBaseline() {
        return this.coordinates[0].y - this.getBounds().y;
    }

    @Override
    public int getTabSize() {
        return 8;
    }

    @Override
    public TextHolderFigure getLabelFor() {
        return this;
    }

    @Override
    public Insets2D.Double getInsets() {
        return new Insets2D.Double();
    }

    @Override
    public SVGTextFigure clone() {
        SVGTextFigure that = (SVGTextFigure)super.clone();
        that.coordinates = new Point2D.Double[this.coordinates.length];
        for (int i = 0; i < this.coordinates.length; ++i) {
            that.coordinates[i] = (Point2D.Double)this.coordinates[i].clone();
        }
        that.rotates = (double[])this.rotates.clone();
        that.cachedBounds = null;
        that.cachedDrawingArea = null;
        that.cachedTextShape = null;
        return that;
    }

    @Override
    public boolean isEmpty() {
        return this.getText() == null || this.getText().length() == 0;
    }

    @Override
    public boolean isTextOverflow() {
        return false;
    }
}

