/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.util.Locale;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGRectRadiusUndoableEdit
extends AbstractUndoableEdit {
    private SVGRectFigure owner;
    private Dimension2DDouble oldArc;
    private Dimension2DDouble newArc;

    public SVGRectRadiusUndoableEdit(SVGRectFigure owner, Dimension2DDouble oldArc, Dimension2DDouble newArc) {
        this.owner = owner;
        this.oldArc = oldArc;
        this.newArc = newArc;
    }

    public String getPresentationName() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels", Locale.getDefault());
        return labels.getString("attribute.roundRectRadius");
    }

    public void redo() throws CannotRedoException {
        this.owner.willChange();
        this.owner.setArc(this.newArc.width, this.newArc.height);
        this.owner.changed();
        super.redo();
    }

    public void undo() throws CannotUndoException {
        this.owner.willChange();
        this.owner.setArc(this.oldArc.width, this.oldArc.height);
        this.owner.changed();
        super.undo();
    }

    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof SVGRectRadiusUndoableEdit) {
            SVGRectRadiusUndoableEdit that = (SVGRectRadiusUndoableEdit)anEdit;
            if (that.owner == this.owner) {
                this.newArc = that.newArc;
                that.die();
                return true;
            }
        }
        return false;
    }

    public boolean replaceEdit(UndoableEdit anEdit) {
        if (anEdit instanceof SVGRectRadiusUndoableEdit) {
            SVGRectRadiusUndoableEdit that = (SVGRectRadiusUndoableEdit)anEdit;
            if (that.owner == this.owner) {
                that.oldArc = this.oldArc;
                this.die();
                return true;
            }
        }
        return false;
    }
}

