/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGRectRadiusUndoableEdit;
import org.jhotdraw.undo.CompositeEdit;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGRectRadiusHandle
extends AbstractHandle {
    private static final boolean DEBUG = false;
    private static final int OFFSET = 6;
    private Dimension2DDouble originalArc2D;
    CompositeEdit edit;

    public SVGRectRadiusHandle(Figure owner) {
        super(owner);
    }

    public void draw(Graphics2D g) {
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR));
        } else {
            this.drawDiamond(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR_DISABLED));
        }
    }

    protected Rectangle basicGetBounds() {
        Rectangle r = new Rectangle(this.locate());
        r.grow(this.getHandlesize() / 2 + 1, this.getHandlesize() / 2 + 1);
        return r;
    }

    private Point locate() {
        SVGRectFigure owner = (SVGRectFigure)this.getOwner();
        Rectangle2D.Double r = owner.getBounds();
        Point2D.Double p = new Point2D.Double(r.x + owner.getArcWidth(), r.y + owner.getArcHeight());
        if (AttributeKeys.TRANSFORM.get(owner) != null) {
            AttributeKeys.TRANSFORM.get(owner).transform(p, p);
        }
        return this.view.drawingToView(p);
    }

    public void trackStart(Point anchor, int modifiersEx) {
        SVGRectFigure svgRect = (SVGRectFigure)this.getOwner();
        this.originalArc2D = svgRect.getArc();
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        int dx = lead.x - anchor.x;
        int dy = lead.y - anchor.y;
        SVGRectFigure svgRect = (SVGRectFigure)this.getOwner();
        svgRect.willChange();
        Point2D.Double p = this.view.viewToDrawing(lead);
        if (AttributeKeys.TRANSFORM.get(svgRect) != null) {
            try {
                AttributeKeys.TRANSFORM.get(svgRect).inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException ex) {
                // empty catch block
            }
        }
        Rectangle2D.Double r = svgRect.getBounds();
        svgRect.setArc(p.x - r.x, p.y - r.y);
        svgRect.changed();
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        SVGRectFigure svgRect = (SVGRectFigure)this.getOwner();
        Dimension2DDouble oldValue = this.originalArc2D;
        Dimension2DDouble newValue = svgRect.getArc();
        this.fireUndoableEditHappened(new SVGRectRadiusUndoableEdit(svgRect, oldValue, newValue));
    }

    public void keyPressed(KeyEvent evt) {
        SVGRectFigure owner = (SVGRectFigure)this.getOwner();
        Dimension2DDouble oldArc = new Dimension2DDouble(owner.getArcWidth(), owner.getArcHeight());
        Dimension2DDouble newArc = new Dimension2DDouble(owner.getArcWidth(), owner.getArcHeight());
        switch (evt.getKeyCode()) {
            case 38: {
                if (newArc.height > 0.0) {
                    newArc.height = Math.max(0.0, newArc.height - 1.0);
                }
                evt.consume();
                break;
            }
            case 40: {
                newArc.height += 1.0;
                evt.consume();
                break;
            }
            case 37: {
                if (newArc.width > 0.0) {
                    newArc.width = Math.max(0.0, newArc.width - 1.0);
                }
                evt.consume();
                break;
            }
            case 39: {
                newArc.width += 1.0;
                evt.consume();
            }
        }
        if (!newArc.equals(oldArc)) {
            owner.willChange();
            owner.setArc(newArc.width, newArc.height);
            owner.changed();
            this.fireUndoableEditHappened(new SVGRectRadiusUndoableEdit(owner, oldArc, newArc));
        }
    }

    public String getToolTipText(Point p) {
        return ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.roundRectangleRadius.toolTipText");
    }
}

