/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;

public class PaletteTextComponentBorder
implements Border,
UIResource {
    private static final float[] enabledStops = new float[]{0.0f, 0.2f};
    private static final Color[] enabledStopColors = new Color[]{new Color(0xC8C8C8), new Color(0xFFFFFF)};

    public void paintBorder(Component c, Graphics gr, int x, int y, int width, int height) {
        Color[] stopColors;
        float[] stops;
        int borderColor;
        Graphics2D g = (Graphics2D)gr;
        JComponent jc = (JComponent)c;
        if (!c.isEnabled()) {
            borderColor = -2136627803;
            stops = enabledStops;
            stopColors = enabledStopColors;
        } else {
            borderColor = -5921371;
            stops = enabledStops;
            stopColors = enabledStopColors;
        }
        String segmentPosition = this.getSegmentPosition(c);
        if (segmentPosition == "first" || segmentPosition == "middle") {
            ++width;
        }
        g.setColor(new Color(borderColor, true));
        g.drawRect(x, y, width - 1, height - 1);
        LinearGradientPaint lgp = new LinearGradientPaint(new Point2D.Float(x, y), new Point2D.Float(x, y + height - 1), stops, stopColors, MultipleGradientPaint.REPEAT, MultipleGradientPaint.LINEAR_RGB);
        g.setPaint(lgp);
        g.fillRect(x + 1, y + 1, width - 2, height - 2);
    }

    private String getSegmentPosition(Component c) {
        String segmentPosition = null;
        if (c instanceof JComponent) {
            segmentPosition = (String)((JComponent)c).getClientProperty("Palette.Component.segmentPosition");
        }
        return segmentPosition == null ? "only" : segmentPosition;
    }

    public Insets getBorderInsets(Component c) {
        String segmentPosition = this.getSegmentPosition(c);
        Insets insets = segmentPosition == "first" || segmentPosition == "middle" ? new Insets(3, 3, 3, 2) : new Insets(3, 3, 3, 3);
        return insets;
    }

    public boolean isBorderOpaque() {
        return true;
    }
}

