/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.jhotdraw.gui.plaf.palette.BackdropBorder;
import org.jhotdraw.gui.plaf.palette.PaletteButtonBorder;
import org.jhotdraw.gui.plaf.palette.PaletteTextComponentBorder;

public class PaletteLookAndFeel
extends BasicLookAndFeel {
    private static PaletteLookAndFeel instance;
    private UIDefaults cachedDefaults;

    public static PaletteLookAndFeel getInstance() {
        if (instance == null) {
            instance = new PaletteLookAndFeel();
        }
        return instance;
    }

    public String getName() {
        return "Palette Look and Feel";
    }

    public String getID() {
        return "Palette";
    }

    public String getDescription() {
        return "A look and feel for palette components";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public UIDefaults getCachedDefaults() {
        if (this.cachedDefaults == null) {
            this.cachedDefaults = this.getDefaults();
        }
        return this.cachedDefaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        UIDefaults defaults = this.getCachedDefaults();
        Object value = defaults.get(key);
        if (!(value instanceof UIDefaults.ActiveValue) && !(value instanceof UIDefaults.LazyValue)) {
            return value;
        }
        if (value instanceof UIDefaults.LazyValue) {
            try {
                value = ((UIDefaults.LazyValue)value).createValue(defaults);
            }
            finally {
                if (value == null) {
                    defaults.remove(key);
                } else {
                    defaults.put(key, value);
                }
            }
        } else {
            value = ((UIDefaults.ActiveValue)value).createValue(defaults);
        }
        return value;
    }

    public Font getFont(String key) {
        return (Font)this.get(key);
    }

    public Border getBorder(String key) {
        return (Border)this.get(key);
    }

    public Color getColor(String key) {
        return (Color)this.get(key);
    }

    public Insets getInsets(String key) {
        return (Insets)this.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public static void installColorsAndFont(JComponent c, String defaultBgName, String defaultFgName, String defaultFontName) {
        Font f = c.getFont();
        if (f == null || f instanceof UIResource) {
            c.setFont(PaletteLookAndFeel.getInstance().getFont(defaultFontName));
        }
        PaletteLookAndFeel.installColors(c, defaultBgName, defaultFgName);
    }

    public static void installBorder(JComponent c, String defaultBorderName) {
        Border b = c.getBorder();
        c.setBorder(PaletteLookAndFeel.getInstance().getBorder(defaultBorderName));
    }

    public static void installColors(JComponent c, String defaultBgName, String defaultFgName) {
        Color fg;
        Color bg = c.getBackground();
        if (bg == null || bg instanceof UIResource) {
            c.setBackground(PaletteLookAndFeel.getInstance().getColor(defaultBgName));
        }
        if ((fg = c.getForeground()) == null || fg instanceof UIResource) {
            c.setForeground(PaletteLookAndFeel.getInstance().getColor(defaultFgName));
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        table.addResourceBundle("org.jhotdraw.gui.Labels");
        Integer eleven = new Integer(11);
        Integer twelve = new Integer(12);
        Integer fontPlain = new Integer(0);
        Integer fontBold = new Integer(1);
        UIDefaults.ProxyLazyValue dialogPlain11 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog Sans", fontPlain, eleven});
        UIDefaults.ProxyLazyValue dialogPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog Sans", fontPlain, twelve});
        UIDefaults.ProxyLazyValue fieldPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Verdana", fontPlain, twelve});
        UIDefaults.ProxyLazyValue serifPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Serif", fontPlain, twelve});
        UIDefaults.ProxyLazyValue sansSerifPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"SansSerif", fontPlain, twelve});
        UIDefaults.ProxyLazyValue monospacedPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"MonoSpaced", fontPlain, twelve});
        UIDefaults.ProxyLazyValue dialogBold12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog", fontBold, twelve});
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource control = new ColorUIResource(0xF0F0F0);
        ColorUIResource controlText = black;
        ColorUIResource selectionBackground = new ColorUIResource(11916799);
        ColorUIResource selectionForeground = black;
        InsetsUIResource zeroInsets = new InsetsUIResource(0, 0, 0, 0);
        InsetsUIResource twoInsets = new InsetsUIResource(2, 2, 2, 2);
        BackdropBorder.UIResource buttonBorder = new BackdropBorder.UIResource(new PaletteButtonBorder());
        BackdropBorder.UIResource textBorder = new BackdropBorder.UIResource(new PaletteTextComponentBorder());
        Object[] defaults = new Object[]{"SmallSystemFont", dialogPlain11, "Button.font", dialogPlain12, "Button.background", control, "Button.foreground", controlText, "Button.border", buttonBorder, "Button.margin", zeroInsets, "Button.background", control, "Button.foreground", controlText, "Button.border", buttonBorder, "Button.margin", zeroInsets, "FormattedTextField.font", fieldPlain12, "FormattedTextField.background", control, "FormattedTextField.foreground", controlText, "FormattedTextField.border", textBorder, "FormattedTextField.margin", zeroInsets, "FormattedTextField.opaque", Boolean.TRUE, "FormattedTextField.errorIndicatorForeground", new ColorUIResource(16665153), "FormattedTextField.selectionBackground", selectionBackground, "FormattedTextField.selectionForeground", selectionForeground, "Label.font", dialogPlain12, "Ribbon.border", new UIDefaults.ProxyLazyValue("javax.swing.border.MatteBorder", new Object[]{new Insets(1, 0, 0, 0), new Color(0xA5A5A5)}), "ScrollPane.border", new UIDefaults.ProxyLazyValue("javax.swing.border.MatteBorder", new Object[]{new Insets(1, 1, 1, 1), new Color(0xA5A5A5)}), "Slider.background", control, "Slider.foreground", controlText, "Slider.horizontalSize", new DimensionUIResource(100, 20), "Slider.verticalSize", new DimensionUIResource(20, 100), "TextArea.selectionBackground", selectionBackground, "TextArea.selectionForeground", selectionForeground, "TextField.font", fieldPlain12, "TextField.background", control, "TextField.foreground", controlText, "TextField.border", textBorder, "TextField.margin", zeroInsets, "TextField.opaque", Boolean.TRUE, "TextField.selectionBackground", selectionBackground, "TextField.selectionForeground", selectionForeground, "ToolBar.font", dialogPlain12, "ToolBar.background", control, "ToolBar.foreground", controlText, "ToolBar.dockingBackground", control, "ToolBar.floatingBackground", control, "ToolBar.border", new UIDefaults.ProxyLazyValue("org.jhotdraw.gui.plaf.palette.PaletteToolBarBorder$UIResource")};
        table.putDefaults(defaults);
    }

    static Object getUIOfType(ComponentUI ui, Class klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }
}

