/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.jhotdraw.gui.plaf.palette.BackdropBorder;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;

public class PaletteFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    private Color errorIndicatorForeground;

    public static ComponentUI createUI(JComponent c) {
        return new PaletteFormattedTextFieldUI();
    }

    public View create(Element elem) {
        return new FieldView(elem){

            protected Shape adjustAllocationXX(Shape a) {
                if (a != null) {
                    Container c;
                    Rectangle bounds = a.getBounds();
                    int vspan = (int)this.getPreferredSpan(1);
                    int hspan = (int)this.getPreferredSpan(0);
                    if (bounds.height != vspan) {
                        int slop = bounds.height - vspan;
                        bounds.y += slop / 2;
                        bounds.height -= slop;
                    }
                    if ((c = this.getContainer()) instanceof JTextField) {
                        int extent;
                        JTextField field = (JTextField)c;
                        BoundedRangeModel vis = field.getHorizontalVisibility();
                        int max = Math.max(hspan, bounds.width);
                        int value = vis.getValue();
                        if (value + (extent = Math.min(max, bounds.width - 1)) > max) {
                            value = max - extent;
                        }
                        vis.setRangeProperties(value, extent, vis.getMinimum(), max, false);
                        if (hspan < bounds.width) {
                            int slop = bounds.width - 1 - hspan;
                            int align = ((JTextField)c).getHorizontalAlignment();
                            if (align == 10) {
                                align = 2;
                            } else if (align == 11) {
                                align = 4;
                            }
                            switch (align) {
                                case 0: {
                                    bounds.x += slop / 2;
                                    bounds.width -= slop;
                                    break;
                                }
                                case 4: {
                                    bounds.x += slop;
                                    bounds.width -= slop;
                                }
                            }
                        } else {
                            bounds.width = hspan;
                            bounds.x -= vis.getValue();
                        }
                    }
                    return bounds;
                }
                return null;
            }

            public void paint(Graphics gr, Shape a) {
                Graphics2D g = (Graphics2D)gr;
                JFormattedTextField editor = (JFormattedTextField)PaletteFormattedTextFieldUI.this.getComponent();
                if (!editor.isEditValid()) {
                    Rectangle r = (Rectangle)a;
                    g.setColor(PaletteFormattedTextFieldUI.this.errorIndicatorForeground);
                    g.setStroke(new BasicStroke(2.5f, 0, 2, 0.0f, new float[]{3.0f, 3.0f}, 0.5f));
                    g.draw(new Line2D.Float(r.x, (float)(r.y + r.height) - 0.5f, r.x + r.width - 1, (float)(r.y + r.height) - 0.5f));
                }
                super.paint(g, a);
            }
        };
    }

    protected void installDefaults() {
        Insets margin;
        Border b;
        Color dfg;
        Color sfg;
        Color s;
        Color color;
        Color fg;
        Color bg;
        JTextComponent editor = this.getComponent();
        PaletteLookAndFeel plaf = PaletteLookAndFeel.getInstance();
        String prefix = this.getPropertyPrefix();
        Font f = editor.getFont();
        if (f == null || f instanceof UIResource) {
            editor.setFont(plaf.getFont(prefix + ".font"));
        }
        if ((bg = editor.getBackground()) == null || bg instanceof UIResource) {
            editor.setBackground(plaf.getColor(prefix + ".background"));
        }
        if ((fg = editor.getForeground()) == null || fg instanceof UIResource) {
            editor.setForeground(plaf.getColor(prefix + ".foreground"));
        }
        if ((color = editor.getCaretColor()) == null || color instanceof UIResource) {
            editor.setCaretColor(plaf.getColor(prefix + ".caretForeground"));
        }
        if ((s = editor.getSelectionColor()) == null || s instanceof UIResource) {
            editor.setSelectionColor(plaf.getColor(prefix + ".selectionBackground"));
        }
        if ((sfg = editor.getSelectedTextColor()) == null || sfg instanceof UIResource) {
            editor.setSelectedTextColor(plaf.getColor(prefix + ".selectionForeground"));
        }
        if ((dfg = editor.getDisabledTextColor()) == null || dfg instanceof UIResource) {
            editor.setDisabledTextColor(plaf.getColor(prefix + ".inactiveForeground"));
        }
        if ((b = editor.getBorder()) == null || b instanceof UIResource) {
            editor.setBorder(plaf.getBorder(prefix + ".border"));
        }
        if ((margin = editor.getMargin()) == null || margin instanceof UIResource) {
            editor.setMargin(plaf.getInsets(prefix + ".margin"));
        }
        this.errorIndicatorForeground = plaf.getColor(prefix + ".errorIndicatorForeground");
        editor.setOpaque(plaf.getBoolean(prefix + ".opaque"));
    }

    protected void paintSafely(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintSafely(g);
    }

    public void paintBackground(Graphics g) {
        JTextComponent c = this.getComponent();
        if (c.getBorder() instanceof BackdropBorder) {
            BackdropBorder bb = (BackdropBorder)c.getBorder();
            bb.getBackdropBorder().paintBorder(c, g, 0, 0, c.getWidth(), c.getHeight());
        } else {
            super.paintBackground(g);
        }
    }
}

