/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jhotdraw.gui.JFontChooser;
import org.jhotdraw.gui.fontchooser.FontChooserModel;
import org.jhotdraw.gui.fontchooser.FontCollectionNode;
import org.jhotdraw.gui.fontchooser.FontFaceNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;
import org.jhotdraw.gui.plaf.FontChooserUI;
import org.jhotdraw.gui.plaf.palette.PaletteFontChooserPreviewPanel;
import org.jhotdraw.gui.plaf.palette.PaletteFontChooserSelectionPanel;

public class PaletteFontChooserUI
extends FontChooserUI {
    private FontCollectionNode familyListParent;
    private FontFamilyNode faceListParent;
    private JFontChooser fontChooser;
    private PaletteFontChooserSelectionPanel selectionPanel;
    private PaletteFontChooserPreviewPanel previewPanel;
    private SelectionPanelHandler selectionPanelHandler;
    private FontChooserHandler chooserHandler;
    private int isUpdating;

    public PaletteFontChooserUI(JFontChooser fontChooser) {
        this.fontChooser = fontChooser;
    }

    public static ComponentUI createUI(JComponent c) {
        PaletteFontChooserUI ui = new PaletteFontChooserUI((JFontChooser)c);
        return ui;
    }

    public void installUI(JComponent c) {
        this.installComponents(this.fontChooser);
        this.installListeners(this.fontChooser);
    }

    protected void installComponents(JFontChooser fc) {
        fc.removeAll();
        fc.setLayout(new BorderLayout());
        this.selectionPanel = new PaletteFontChooserSelectionPanel();
        fc.add((Component)this.selectionPanel, "Center");
        this.previewPanel = new PaletteFontChooserPreviewPanel();
        fc.add((Component)this.previewPanel, "North");
        FontChooserModel model = this.fontChooser.getModel();
        this.updateCollectionList();
        this.updateFamilyList();
        this.updateFaceList();
        this.updatePreview();
    }

    protected void installListeners(JFontChooser fc) {
        this.selectionPanelHandler = new SelectionPanelHandler();
        this.selectionPanel.getCollectionList().addListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().addListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().addListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getCollectionList().addKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().addKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().addKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getCollectionList().addMouseListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().addMouseListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().addMouseListener(this.selectionPanelHandler);
        this.chooserHandler = new FontChooserHandler();
        this.fontChooser.addPropertyChangeListener(this.chooserHandler);
        if (this.fontChooser.getModel() != null) {
            this.fontChooser.getModel().addTreeModelListener(this.chooserHandler);
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners(this.fontChooser);
        this.uninstallComponents(this.fontChooser);
    }

    protected void uninstallComponents(JFontChooser fc) {
        this.fontChooser.removeAll();
    }

    protected void uninstallListeners(JFontChooser fc) {
        this.fontChooser.removePropertyChangeListener(this.chooserHandler);
        this.selectionPanel.getCollectionList().removeListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().removeListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().removeListSelectionListener(this.selectionPanelHandler);
        this.selectionPanel.getCollectionList().removeKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().removeKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().removeKeyListener(this.selectionPanelHandler);
        this.selectionPanel.getCollectionList().removeMouseListener(this.selectionPanelHandler);
        this.selectionPanel.getFamilyList().removeMouseListener(this.selectionPanelHandler);
        this.selectionPanel.getFaceList().removeMouseListener(this.selectionPanelHandler);
        if (this.fontChooser.getModel() != null) {
            this.fontChooser.getModel().removeTreeModelListener(this.chooserHandler);
        }
        this.chooserHandler = null;
        this.selectionPanelHandler = null;
    }

    private void updateCollectionList() {
        ++this.isUpdating;
        JList list = this.selectionPanel.getCollectionList();
        DefaultListModel lm = (DefaultListModel)list.getModel();
        lm.removeAllElements();
        FontChooserModel model = this.fontChooser.getModel();
        Object parent = model.getRoot();
        int n = model.getChildCount(parent);
        for (int i = 0; i < n; ++i) {
            lm.addElement(model.getChild(parent, i));
        }
        TreePath path = this.fontChooser.getSelectionPath();
        if (path == null || path.getPathCount() < 2) {
            list.clearSelection();
        } else {
            list.setSelectedIndex(((TreeNode)path.getPathComponent(0)).getIndex((TreeNode)path.getPathComponent(1)));
            list.scrollRectToVisible(list.getCellBounds(list.getSelectedIndex(), list.getSelectedIndex()));
        }
        --this.isUpdating;
    }

    private void updateFamilyList() {
        ++this.isUpdating;
        JList list = this.selectionPanel.getFamilyList();
        FontChooserModel model = this.fontChooser.getModel();
        FontCollectionNode newParent = null;
        TreePath path = this.fontChooser.getSelectionPath();
        if (path != null && path.getPathCount() > 1) {
            newParent = (FontCollectionNode)path.getPathComponent(1);
        }
        if (newParent != this.familyListParent) {
            DefaultListModel lm = (DefaultListModel)list.getModel();
            lm.removeAllElements();
            this.familyListParent = newParent;
            if (this.familyListParent != null) {
                int n = model.getChildCount(this.familyListParent);
                for (int i = 0; i < n; ++i) {
                    lm.addElement(model.getChild(this.familyListParent, i));
                }
            }
        }
        if (path == null || path.getPathCount() < 3) {
            list.clearSelection();
        } else {
            list.setSelectedIndex(((TreeNode)path.getPathComponent(1)).getIndex((TreeNode)path.getPathComponent(2)));
            list.scrollRectToVisible(list.getCellBounds(list.getSelectedIndex(), list.getSelectedIndex()));
        }
        --this.isUpdating;
    }

    private void updateFaceList() {
        ++this.isUpdating;
        JList list = this.selectionPanel.getFaceList();
        FontChooserModel model = this.fontChooser.getModel();
        FontFamilyNode newParent = null;
        TreePath path = this.fontChooser.getSelectionPath();
        if (path != null && path.getPathCount() > 2) {
            newParent = (FontFamilyNode)path.getPathComponent(2);
        }
        if (newParent != this.faceListParent) {
            DefaultListModel lm = (DefaultListModel)list.getModel();
            lm.removeAllElements();
            this.faceListParent = newParent;
            if (this.faceListParent != null) {
                int n = model.getChildCount(this.faceListParent);
                for (int i = 0; i < n; ++i) {
                    lm.addElement(model.getChild(this.faceListParent, i));
                }
            }
        }
        if (path == null || path.getPathCount() < 4) {
            list.clearSelection();
        } else {
            list.setSelectedIndex(((TreeNode)path.getPathComponent(2)).getIndex((TreeNode)path.getPathComponent(3)));
            list.scrollRectToVisible(list.getCellBounds(list.getSelectedIndex(), list.getSelectedIndex()));
        }
        --this.isUpdating;
    }

    private void updatePreview() {
        ++this.isUpdating;
        this.previewPanel.setSelectedFont(this.fontChooser.getSelectedFont());
        --this.isUpdating;
    }

    private void doCollectionChanged() {
        FontFaceNode newFace;
        FontFamilyNode newFamily;
        FontCollectionNode newCollection;
        block12: {
            JList list = this.selectionPanel.getCollectionList();
            TreePath path = this.fontChooser.getSelectionPath();
            FontCollectionNode oldCollection = path != null && path.getPathCount() > 1 ? (FontCollectionNode)path.getPathComponent(1) : null;
            FontFamilyNode oldFamily = path != null && path.getPathCount() > 2 ? (FontFamilyNode)path.getPathComponent(2) : null;
            FontFaceNode oldFace = path != null && path.getPathCount() > 3 ? (FontFaceNode)path.getPathComponent(3) : null;
            newCollection = (FontCollectionNode)list.getSelectedValue();
            newFamily = null;
            newFace = null;
            if ((oldFamily == null || oldFace == null) && this.fontChooser.getSelectedFont() != null) {
                oldFace = new FontFaceNode(this.fontChooser.getSelectedFont());
                oldFamily = new FontFamilyNode(this.fontChooser.getSelectedFont().getFamily());
            }
            if (newCollection != null && oldFamily != null) {
                int n = newCollection.getChildCount();
                for (int i = 0; i < n; ++i) {
                    FontFamilyNode aFamily = newCollection.getChildAt(i);
                    if (aFamily.compareTo(oldFamily) != 0) continue;
                    newFamily = aFamily;
                    break;
                }
            }
            if (newFamily != null && oldFace != null) {
                for (FontFaceNode aFace : newFamily.faces()) {
                    if (aFace.compareTo(oldFace) != 0) continue;
                    newFace = aFace;
                    break;
                }
            } else if (newFace == null && oldFamily != null && oldFace != null) {
                for (FontFamilyNode aFamily : newCollection.families()) {
                    for (FontFaceNode aFace : aFamily.faces()) {
                        if (aFace.compareTo(oldFace) != 0) continue;
                        newFace = aFace;
                        newFamily = (FontFamilyNode)aFace.getParent();
                        break block12;
                    }
                }
            }
        }
        if (newCollection != null) {
            if (newFamily == null && newCollection.getChildCount() > 0) {
                newFamily = newCollection.getChildAt(0);
            }
            if (newFamily != null && newFace == null && newFamily.getChildCount() > 0) {
                newFace = newFamily.getChildAt(0);
            }
        }
        this.setNewSelectionPath(newCollection, newFamily, newFace);
    }

    private void doFamilyChanged() {
        FontChooserModel model = this.fontChooser.getModel();
        JList list = this.selectionPanel.getFamilyList();
        TreePath path = this.fontChooser.getSelectionPath();
        FontCollectionNode oldCollection = path != null && path.getPathCount() > 1 ? (FontCollectionNode)path.getPathComponent(1) : null;
        FontFamilyNode oldFamily = path != null && path.getPathCount() > 2 ? (FontFamilyNode)path.getPathComponent(2) : null;
        FontFaceNode oldFace = path != null && path.getPathCount() > 3 ? (FontFaceNode)path.getPathComponent(3) : null;
        FontCollectionNode newCollection = oldCollection;
        FontFamilyNode newFamily = (FontFamilyNode)list.getSelectedValue();
        FontFaceNode newFace = null;
        if (newFamily != null && oldFace != null) {
            int n = newFamily.getChildCount();
            for (int i = 0; i < n; ++i) {
                FontFaceNode aFace = newFamily.getChildAt(i);
                if (aFace.compareTo(oldFace) != 0) continue;
                newFace = aFace;
                break;
            }
        }
        if (newCollection != null) {
            if (newFamily == null && newCollection.getChildCount() > 0) {
                newFamily = newCollection.getChildAt(0);
            }
            if (newFamily != null && newFace == null && newFamily.getChildCount() > 0) {
                newFace = newFamily.getChildAt(0);
            }
        }
        this.setNewSelectionPath(newCollection, newFamily, newFace);
    }

    private void doFaceChanged() {
        JList list = this.selectionPanel.getFaceList();
        TreePath path = this.fontChooser.getSelectionPath();
        FontCollectionNode oldCollection = path != null && path.getPathCount() > 1 ? (FontCollectionNode)path.getPathComponent(1) : null;
        FontFamilyNode oldFamily = path != null && path.getPathCount() > 2 ? (FontFamilyNode)path.getPathComponent(2) : null;
        FontFaceNode oldFace = path != null && path.getPathCount() > 3 ? (FontFaceNode)path.getPathComponent(3) : null;
        FontCollectionNode newCollection = oldCollection;
        FontFamilyNode newFamily = oldFamily;
        FontFaceNode newFace = (FontFaceNode)list.getSelectedValue();
        this.setNewSelectionPath(newCollection, newFamily, newFace);
    }

    private void setNewSelectionPath(FontCollectionNode newCollection, FontFamilyNode newFamily, FontFaceNode newFace) {
        FontChooserModel model = this.fontChooser.getModel();
        TreePath newPath = newFace != null ? new TreePath(new Object[]{model.getRoot(), newCollection, newFamily, newFace}) : (newFamily != null ? new TreePath(new Object[]{model.getRoot(), newCollection, newFamily}) : (newCollection != null ? new TreePath(new Object[]{model.getRoot(), newCollection}) : new TreePath(model.getRoot())));
        this.fontChooser.setSelectionPath(newPath);
    }

    private class FontChooserHandler
    implements PropertyChangeListener,
    TreeModelListener {
        private FontChooserHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == "selectionPath") {
                PaletteFontChooserUI.this.updateCollectionList();
                PaletteFontChooserUI.this.updateFamilyList();
                PaletteFontChooserUI.this.updateFaceList();
            } else if (name == "selectedFont") {
                PaletteFontChooserUI.this.updatePreview();
            } else if (name == "model") {
                FontChooserModel m = (FontChooserModel)evt.getOldValue();
                if (m != null) {
                    m.removeTreeModelListener(this);
                }
                if ((m = (FontChooserModel)evt.getNewValue()) != null) {
                    m.addTreeModelListener(this);
                }
                PaletteFontChooserUI.this.updateCollectionList();
                PaletteFontChooserUI.this.updateFamilyList();
                PaletteFontChooserUI.this.updateFaceList();
            }
        }

        public void treeNodesChanged(TreeModelEvent e) {
            PaletteFontChooserUI.this.updateCollectionList();
            PaletteFontChooserUI.this.updateFamilyList();
            PaletteFontChooserUI.this.updateFaceList();
        }

        public void treeNodesInserted(TreeModelEvent e) {
            PaletteFontChooserUI.this.updateCollectionList();
            PaletteFontChooserUI.this.updateFamilyList();
            PaletteFontChooserUI.this.updateFaceList();
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            PaletteFontChooserUI.this.updateCollectionList();
            PaletteFontChooserUI.this.updateFamilyList();
            PaletteFontChooserUI.this.updateFaceList();
        }

        public void treeStructureChanged(TreeModelEvent e) {
            PaletteFontChooserUI.this.updateCollectionList();
            PaletteFontChooserUI.this.updateFamilyList();
            PaletteFontChooserUI.this.updateFaceList();
        }
    }

    private class SelectionPanelHandler
    implements KeyListener,
    MouseListener,
    ListSelectionListener {
        private SelectionPanelHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            if (PaletteFontChooserUI.this.isUpdating == 0) {
                Object src = evt.getSource();
                if (src == PaletteFontChooserUI.this.selectionPanel.getCollectionList()) {
                    PaletteFontChooserUI.this.doCollectionChanged();
                } else if (src == PaletteFontChooserUI.this.selectionPanel.getFamilyList()) {
                    PaletteFontChooserUI.this.doFamilyChanged();
                } else if (src == PaletteFontChooserUI.this.selectionPanel.getFaceList()) {
                    PaletteFontChooserUI.this.doFaceChanged();
                }
            }
        }

        public void keyReleased(KeyEvent evt) {
            Object src = evt.getSource();
            switch (evt.getKeyCode()) {
                case 37: {
                    if (src != PaletteFontChooserUI.this.selectionPanel.getCollectionList()) {
                        if (src == PaletteFontChooserUI.this.selectionPanel.getFamilyList()) {
                            PaletteFontChooserUI.this.selectionPanel.getCollectionList().requestFocus();
                        } else if (src == PaletteFontChooserUI.this.selectionPanel.getFaceList()) {
                            PaletteFontChooserUI.this.selectionPanel.getFamilyList().requestFocus();
                        }
                    }
                    evt.consume();
                    break;
                }
                case 39: {
                    if (src == PaletteFontChooserUI.this.selectionPanel.getCollectionList()) {
                        PaletteFontChooserUI.this.selectionPanel.getFamilyList().requestFocus();
                    } else if (src == PaletteFontChooserUI.this.selectionPanel.getFamilyList()) {
                        PaletteFontChooserUI.this.selectionPanel.getFaceList().requestFocus();
                    } else if (src == PaletteFontChooserUI.this.selectionPanel.getFaceList()) {
                        // empty if block
                    }
                    evt.consume();
                    break;
                }
                case 27: {
                    PaletteFontChooserUI.this.fontChooser.cancelSelection();
                    evt.consume();
                    break;
                }
                case 10: {
                    PaletteFontChooserUI.this.fontChooser.approveSelection();
                    evt.consume();
                }
            }
        }

        public void keyPressed(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
            if (evt.getClickCount() == 2 && evt.getButton() == 1) {
                PaletteFontChooserUI.this.fontChooser.approveSelection();
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }
}

