/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.datatransfer;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.jhotdraw.util.Images;

public class ImageTransferable
implements Transferable {
    private Image image;
    public static final DataFlavor IMAGE_PNG_FLAVOR;

    public ImageTransferable(Image image) {
        this.image = image;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(DataFlavor.imageFlavor) || flavor.equals(IMAGE_PNG_FLAVOR);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.imageFlavor)) {
            return this.image;
        }
        if (flavor.equals(IMAGE_PNG_FLAVOR)) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)Images.toBufferedImage(this.image), "PNG", buf);
            return new ByteArrayInputStream(buf.toByteArray());
        }
        throw new UnsupportedFlavorException(flavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor, IMAGE_PNG_FLAVOR};
    }

    static {
        try {
            IMAGE_PNG_FLAVOR = new DataFlavor("image/png");
        }
        catch (Exception e) {
            InternalError error = new InternalError("Unable to crate image/png data flavor");
            error.initCause(e);
            throw error;
        }
    }
}

