/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.NumberFormatter;

public class JLifeFormattedTextField
extends JFormattedTextField {
    private Object value;
    private DocumentHandler documentHandler;
    private int updatingDepth;

    public void setDocument(Document newValue) {
        Document oldValue = this.getDocument();
        super.setDocument(newValue);
        if (this.documentHandler == null) {
            this.documentHandler = new DocumentHandler();
        }
        if (oldValue != null) {
            oldValue.removeDocumentListener(this.documentHandler);
        }
        if (newValue != null) {
            newValue.addDocumentListener(this.documentHandler);
        }
        this.updateValue();
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (newValue != null && this.getFormatterFactory() == null) {
            this.setFormatterFactory(this.getDefaultFormatterFactory(newValue));
        }
        this.value = newValue;
        this.firePropertyChange("value", oldValue, newValue);
        this.updateText();
    }

    public Object getValue() {
        return this.value;
    }

    protected void updateValue() {
        if (this.updatingDepth++ == 0 && this.getFormatter() != null) {
            try {
                Object newValue = this.getFormatter().stringToValue(this.getText());
                this.setValue(newValue);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        --this.updatingDepth;
    }

    protected void updateText() {
        if (this.updatingDepth++ == 0 && this.getFormatter() != null) {
            try {
                String newText = this.getFormatter().valueToString(this.getValue());
                this.setText(newText);
                if (!this.isFocusOwner()) {
                    this.setCaretPosition(this.getDocument().getLength());
                    this.moveCaretPosition(0);
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        --this.updatingDepth;
    }

    private JFormattedTextField.AbstractFormatterFactory getDefaultFormatterFactory(Object type) {
        if (type instanceof DateFormat) {
            return new DefaultFormatterFactory(new DateFormatter((DateFormat)type));
        }
        if (type instanceof NumberFormat) {
            return new DefaultFormatterFactory(new NumberFormatter((NumberFormat)type));
        }
        if (type instanceof Format) {
            return new DefaultFormatterFactory(new InternationalFormatter((Format)type));
        }
        if (type instanceof Date) {
            return new DefaultFormatterFactory(new DateFormatter());
        }
        if (type instanceof Number) {
            NumberFormatter displayFormatter = new NumberFormatter();
            displayFormatter.setValueClass(type.getClass());
            NumberFormatter editFormatter = new NumberFormatter(new DecimalFormat("#.#"));
            editFormatter.setValueClass(type.getClass());
            return new DefaultFormatterFactory(displayFormatter, displayFormatter, editFormatter);
        }
        return new DefaultFormatterFactory(new DefaultFormatter());
    }

    private void initComponents() {
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent e) {
            JLifeFormattedTextField.this.updateValue();
        }

        public void removeUpdate(DocumentEvent e) {
            JLifeFormattedTextField.this.updateValue();
        }

        public void changedUpdate(DocumentEvent e) {
            JLifeFormattedTextField.this.updateValue();
        }
    }
}

