/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jhotdraw.gui.fontchooser.DefaultFontChooserModel;
import org.jhotdraw.gui.fontchooser.FontChooserModel;
import org.jhotdraw.gui.fontchooser.FontCollectionNode;
import org.jhotdraw.gui.fontchooser.FontFaceNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;
import org.jhotdraw.gui.plaf.FontChooserUI;
import org.jhotdraw.gui.plaf.palette.PaletteFontChooserUI;

public class JFontChooser
extends JComponent {
    private static final String uiClassID = "FontChooserUI";
    public static final String SELECTED_FONT_PROPERTY = "selectedFont";
    public static final String SELECTION_PATH_PROPERTY = "selectionPath";
    public static final String CANCEL_SELECTION = "CancelSelection";
    public static final String APPROVE_SELECTION = "ApproveSelection";
    public static final String MODEL_PROPERTY = "model";
    private TreePath selectionPath;
    private Font selectedFont;
    private FontChooserModel model;
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    private int returnValue = -1;
    private JDialog dialog = null;
    private static FutureTask<Font[]> future;
    private TreeModelListener modelHandler = new TreeModelListener(){

        public void treeNodesChanged(TreeModelEvent e) {
            JFontChooser.this.updateSelectionPath(JFontChooser.this.getSelectedFont());
        }

        public void treeNodesInserted(TreeModelEvent e) {
            JFontChooser.this.updateSelectionPath(JFontChooser.this.getSelectedFont());
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            JFontChooser.this.updateSelectionPath(JFontChooser.this.getSelectedFont());
        }

        public void treeStructureChanged(TreeModelEvent e) {
            JFontChooser.this.updateSelectionPath(JFontChooser.this.getSelectedFont());
        }
    };

    public JFontChooser() {
        JFontChooser.loadAllFonts();
        this.model = new DefaultFontChooserModel.UIResource();
        this.model.addTreeModelListener(this.modelHandler);
        this.updateUI();
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "ancestor" && evt.getNewValue() != null) {
                    Component ancestor = (Component)evt.getNewValue();
                    try {
                        ((DefaultFontChooserModel)JFontChooser.this.model).setFonts(JFontChooser.getAllFonts());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    JFontChooser.this.removePropertyChangeListener(this);
                }
            }
        });
    }

    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((FontChooserUI)UIManager.getUI(this));
        } else {
            this.setUI(PaletteFontChooserUI.createUI(this));
        }
    }

    public FontChooserUI getUI() {
        return (FontChooserUI)this.ui;
    }

    public void setUI(FontChooserUI ui) {
        super.setUI(ui);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void approveSelection() {
        this.returnValue = 0;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed(APPROVE_SELECTION);
    }

    public void cancelSelection() {
        this.returnValue = 1;
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
        this.fireActionPerformed(CANCEL_SELECTION);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        long mostRecentEventTime = EventQueue.getMostRecentEventTime();
        int modifiers = 0;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, command, mostRecentEventTime, modifiers);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public TreePath getSelectionPath() {
        return this.selectionPath;
    }

    public void setSelectionPath(TreePath newValue) {
        TreePath oldValue = this.selectionPath;
        this.selectionPath = newValue;
        this.firePropertyChange(SELECTION_PATH_PROPERTY, oldValue, newValue);
        if (this.selectionPath != null && this.selectionPath.getPathCount() == 4) {
            this.setSelectedFont(((FontFaceNode)this.selectionPath.getLastPathComponent()).getFont());
        }
    }

    public static synchronized void loadAllFonts() {
        if (future == null) {
            future = new FutureTask<Font[]>(new Callable<Font[]>(){

                @Override
                public Font[] call() throws Exception {
                    long start = System.currentTimeMillis();
                    Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
                    long end = System.currentTimeMillis();
                    ArrayList<Font> goodFonts = new ArrayList<Font>(fonts.length);
                    for (Font f : fonts) {
                        Font decoded = Font.decode(f.getFontName());
                        if (!decoded.getFontName().equals(f.getFontName()) && !decoded.getFontName().endsWith("-Derived")) continue;
                        goodFonts.add(f);
                    }
                    return goodFonts.toArray(new Font[goodFonts.size()]);
                }
            });
            new Thread(future).start();
        }
    }

    public static synchronized Font[] getAllFonts() {
        JFontChooser.loadAllFonts();
        try {
            return (Font[])future.get().clone();
        }
        catch (InterruptedException ex) {
            return new Font[0];
        }
        catch (ExecutionException ex) {
            return new Font[0];
        }
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font newValue) {
        Font oldValue = this.selectedFont;
        this.selectedFont = newValue;
        this.firePropertyChange(SELECTED_FONT_PROPERTY, oldValue, newValue);
        this.updateSelectionPath(newValue);
    }

    protected void updateSelectionPath(Font newValue) {
        if (newValue == null || this.selectionPath == null || this.selectionPath.getPathCount() != 4 || !((FontFaceNode)this.selectionPath.getLastPathComponent()).getFont().getFontName().equals(newValue.getFontName())) {
            if (newValue == null) {
                this.setSelectionPath(null);
            } else {
                TreePath path = this.selectionPath;
                FontCollectionNode oldCollection = path != null && path.getPathCount() > 1 ? (FontCollectionNode)path.getPathComponent(1) : null;
                FontFamilyNode oldFamily = path != null && path.getPathCount() > 2 ? (FontFamilyNode)path.getPathComponent(2) : null;
                FontFaceNode oldFace = path != null && path.getPathCount() > 3 ? (FontFaceNode)path.getPathComponent(3) : null;
                FontCollectionNode newCollection = oldCollection;
                FontFamilyNode newFamily = oldFamily;
                FontFaceNode newFace = null;
                if (newFace == null && newFamily != null) {
                    for (FontFaceNode face : newFamily.faces()) {
                        if (!face.getFont().getFontName().equals(newValue.getFontName())) continue;
                        newFace = face;
                        break;
                    }
                }
                if (newFace == null && newCollection != null) {
                    block1: for (FontFamilyNode family : newCollection.families()) {
                        for (FontFaceNode face : family.faces()) {
                            if (!face.getFont().getFontName().equals(newValue.getFontName())) continue;
                            newFamily = family;
                            newFace = face;
                            continue block1;
                        }
                    }
                }
                if (newFace == null) {
                    TreeNode root = (TreeNode)this.getModel().getRoot();
                    int n = root.getChildCount();
                    block3: for (int i = 0; i < n; ++i) {
                        FontCollectionNode collection = (FontCollectionNode)root.getChildAt(i);
                        for (FontFamilyNode family : collection.families()) {
                            for (FontFaceNode face : family.faces()) {
                                if (!face.getFont().getFontName().equals(newValue.getFontName())) continue;
                                newCollection = collection;
                                newFamily = family;
                                newFace = face;
                                break block3;
                            }
                        }
                    }
                }
                if (newFace != null) {
                    this.setSelectionPath(new TreePath(new Object[]{this.getModel().getRoot(), newCollection, newFamily, newFace}));
                } else {
                    this.setSelectionPath(null);
                }
            }
        }
    }

    public FontChooserModel getModel() {
        return this.model;
    }

    public void setModel(FontChooserModel newValue) {
        FontChooserModel oldValue = this.model;
        if (oldValue != null) {
            oldValue.removeTreeModelListener(this.modelHandler);
        }
        this.model = newValue;
        if (newValue != null) {
            newValue.addTreeModelListener(this.modelHandler);
        }
        this.firePropertyChange(MODEL_PROPERTY, oldValue, newValue);
        this.updateSelectionPath(this.selectedFont);
    }
}

