/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import org.jhotdraw.gui.DisclosureIcon;
import org.jhotdraw.gui.EmptyIcon;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteToolBarUI;

public class JDisclosureToolBar
extends JToolBar {
    private JButton disclosureButton;
    public static final String DISCLOSURE_STATE_PROPERTY = "disclosureState";
    public static final String DISCLOSURE_STATE_COUNT_PROPERTY = "disclosureStateCount";

    public JDisclosureToolBar() {
        this.setUI(PaletteToolBarUI.createUI(this));
        this.initComponents();
    }

    private void initComponents() {
        JButton btn;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.disclosureButton == null) {
            btn = new JButton();
            btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
            btn.setBorderPainted(false);
            btn.setIcon(new DisclosureIcon());
            btn.setOpaque(false);
            this.disclosureButton = btn;
            this.disclosureButton.putClientProperty("DisclosureIcon.currentState", 1);
            this.disclosureButton.putClientProperty("DisclosureIcon.numberOfStates", 2);
            this.disclosureButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int newState = ((Integer)JDisclosureToolBar.this.disclosureButton.getClientProperty("DisclosureIcon.currentState") + 1) % (Integer)JDisclosureToolBar.this.disclosureButton.getClientProperty("DisclosureIcon.numberOfStates");
                    JDisclosureToolBar.this.setDisclosureState(newState);
                }
            });
        } else {
            btn = this.disclosureButton;
        }
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 1, 0, 1);
        gbc.anchor = 16;
        gbc.fill = 0;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add((Component)btn, gbc);
        this.putClientProperty("Palette.ToolBar.insetsOverride", new Insets(0, 0, 0, 0));
        this.putClientProperty("Palette.ToolBar.icon", new EmptyIcon(10, 8));
    }

    public void setDisclosureStateCount(int newValue) {
        int oldValue = this.getDisclosureStateCount();
        this.disclosureButton.putClientProperty("DisclosureIcon.numberOfStates", newValue);
        this.firePropertyChange(DISCLOSURE_STATE_COUNT_PROPERTY, oldValue, newValue);
    }

    public void setDisclosureState(int newValue) {
        int oldValue = this.getDisclosureState();
        this.disclosureButton.putClientProperty("DisclosureIcon.currentState", newValue);
        this.removeAll();
        JComponent c = this.getDisclosedComponent(newValue);
        GridBagLayout layout = (GridBagLayout)this.getLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        if (c != null) {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.anchor = 17;
            this.add((Component)c, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.weightx = 0.0;
            gbc.insets = new Insets(0, 1, 0, 1);
            gbc.weighty = 1.0;
            gbc.fill = 0;
            gbc.anchor = 16;
            this.add((Component)this.disclosureButton, gbc);
        } else {
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 0;
            gbc.anchor = 16;
            gbc.insets = new Insets(0, 1, 0, 1);
            this.add((Component)this.disclosureButton, gbc);
        }
        this.invalidate();
        Container parent = this.getParent();
        while (parent.getParent() != null && !parent.getParent().isValid()) {
            parent = parent.getParent();
        }
        parent.validate();
        this.repaint();
        this.firePropertyChange(DISCLOSURE_STATE_PROPERTY, oldValue, newValue);
    }

    public int getDisclosureStateCount() {
        Integer value = (Integer)this.disclosureButton.getClientProperty("DisclosureIcon.numberOfStates");
        return value == null ? 2 : value;
    }

    public int getDisclosureState() {
        Integer value = (Integer)this.disclosureButton.getClientProperty("DisclosureIcon.currentState");
        return value == null ? 1 : value;
    }

    protected JComponent getDisclosedComponent(int state) {
        return new JLabel(Integer.toString(state));
    }
}

