/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import javax.swing.JComponent;
import javax.swing.JSlider;
import org.jhotdraw.gui.AttributeEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAttributeSlider
extends JSlider
implements AttributeEditor<Double> {
    private boolean isMultipleValues;
    private Double attributeValue;
    private double scaleFactor = 1.0;

    public JAttributeSlider() {
        this(1, 0, 100, 50);
    }

    public JAttributeSlider(int orientation, int min, int max, int value) {
        super(orientation, min, max, value);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setAttributeValue(Double newValue) {
        this.attributeValue = newValue;
        this.setValue((int)(newValue * this.scaleFactor));
    }

    @Override
    public Double getAttributeValue() {
        return this.attributeValue;
    }

    public void setScaleFactor(double newValue) {
        this.scaleFactor = newValue;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setMultipleValues(boolean newValue) {
        boolean oldValue = this.isMultipleValues;
        this.isMultipleValues = newValue;
        this.firePropertyChange("multipleValues", oldValue, newValue);
    }

    @Override
    public boolean isMultipleValues() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void fireStateChanged() {
        super.fireStateChanged();
        Double oldValue = this.attributeValue;
        this.attributeValue = (double)this.getValue() / this.scaleFactor;
        this.firePropertyChange("attributeValue", oldValue, this.attributeValue);
    }

    private void initComponents() {
    }
}

