/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DisclosureIcon
implements Icon {
    public static final String STATE_COUNT_PROPERTY = "DisclosureIcon.numberOfStates";
    public static final String CURRENT_STATE_PROPERTY = "DisclosureIcon.currentState";

    public void paintIcon(Component component, Graphics g, int x, int y) {
        JComponent c = (JComponent)component;
        int nbOfStates = c.getClientProperty(STATE_COUNT_PROPERTY) instanceof Integer ? (Integer)c.getClientProperty(STATE_COUNT_PROPERTY) : 2;
        int currentState = c.getClientProperty(CURRENT_STATE_PROPERTY) instanceof Integer ? (Integer)c.getClientProperty(CURRENT_STATE_PROPERTY) : 1;
        g.setColor(Color.black);
        g.drawRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1);
        g.setColor(new Color(0x666666));
        g.fillRect(x + 1, y + 1, 1 + (this.getIconWidth() - 3) * currentState / (nbOfStates - 1), this.getIconHeight() - 2);
    }

    public int getIconWidth() {
        return 10;
    }

    public int getIconHeight() {
        return 8;
    }
}

