/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.BringToFrontAction;

public class SendToBackAction
extends AbstractSelectedAction {
    public static String ID = "edit.sendToBack";

    public SendToBackAction(DrawingEditor editor) {
        super(editor);
        this.labels.configureAction(this, ID);
    }

    public void actionPerformed(ActionEvent e) {
        final DrawingView view = this.getView();
        final LinkedList<Figure> figures = new LinkedList<Figure>(view.getSelectedFigures());
        SendToBackAction.sendToBack(view, figures);
        this.fireUndoableEditHappened(new AbstractUndoableEdit(){

            public String getPresentationName() {
                return SendToBackAction.this.labels.getTextProperty(ID);
            }

            public void redo() throws CannotRedoException {
                super.redo();
                SendToBackAction.sendToBack(view, figures);
            }

            public void undo() throws CannotUndoException {
                super.undo();
                BringToFrontAction.bringToFront(view, figures);
            }
        });
    }

    public static void sendToBack(DrawingView view, Collection figures) {
        Iterator i = figures.iterator();
        Drawing drawing = view.getDrawing();
        while (i.hasNext()) {
            Figure figure = (Figure)i.next();
            drawing.sendToBack(figure);
        }
    }
}

