/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.net.URL;
import javax.swing.ImageIcon;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingColorIcon
extends ImageIcon {
    private DrawingEditor editor;
    private AttributeKey<Color> key;
    private Shape colorShape;

    public DrawingColorIcon(DrawingEditor editor, AttributeKey<Color> key, URL imageLocation, Shape colorShape) {
        super(imageLocation);
        this.editor = editor;
        this.key = key;
        this.colorShape = colorShape;
    }

    public DrawingColorIcon(DrawingEditor editor, AttributeKey<Color> key, Image image, Shape colorShape) {
        super(image);
        this.editor = editor;
        this.key = key;
        this.colorShape = colorShape;
    }

    @Override
    public void paintIcon(Component c, Graphics gr, int x, int y) {
        DrawingView view;
        Color color;
        Graphics2D g = (Graphics2D)gr;
        super.paintIcon(c, g, x, y);
        if (this.editor != null && (color = (view = this.editor.getActiveView()) != null ? this.key.get(view.getDrawing()) : this.key.getDefaultValue()) != null) {
            g.setColor(color);
            g.translate(x, y);
            g.fill(this.colorShape);
            g.translate(-x, -y);
        }
    }
}

