/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextOverflowHandle
extends AbstractHandle {
    public TextOverflowHandle(TextHolderFigure owner) {
        super(owner);
    }

    public TextHolderFigure getOwner() {
        return (TextHolderFigure)super.getOwner();
    }

    public boolean contains(Point p) {
        return false;
    }

    public void draw(Graphics2D g) {
        if (this.getOwner().isTextOverflow()) {
            this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_STROKE_COLOR));
            g.setColor(this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_STROKE_COLOR));
            Rectangle r = this.basicGetBounds();
            g.drawLine(r.x + 1, r.y + 1, r.x + r.width - 2, r.y + r.height - 2);
            g.drawLine(r.x + r.width - 2, r.y + 1, r.x + 1, r.y + r.height - 2);
        }
    }

    protected Rectangle basicGetBounds() {
        Rectangle2D.Double b = this.getOwner().getBounds();
        Point2D.Double p = new Point2D.Double(b.x + b.width, b.y + b.height);
        if (AttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
            AttributeKeys.TRANSFORM.get(this.getOwner()).transform(p, p);
        }
        Rectangle r = new Rectangle(this.view.drawingToView(p));
        int h = this.getHandlesize();
        r.x -= h;
        r.y -= h;
        r.width = r.height = h;
        return r;
    }

    public void trackStart(Point anchor, int modifiersEx) {
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
    }

    public String getToolTipText(Point p) {
        return this.getOwner().isTextOverflow() ? ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.textOverflow.toolTipText") : null;
    }
}

